/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.hacks;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ScaffoldConfig;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.utils.InventorySlot;
import com.zergatul.cheatutils.utils.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class Scaffold
implements Module {
    public static final Scaffold instance = new Scaffold();
    private final Minecraft mc = Minecraft.m_91087_();
    private final List<BlockPos> list = new ArrayList<BlockPos>();

    private Scaffold() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
    }

    private void onClientTickEnd() {
        if (this.mc.f_91074_ == null || this.mc.f_91073_ == null) {
            return;
        }
        ScaffoldConfig config = ConfigStore.instance.getConfig().scaffoldConfig;
        if (config.enabled) {
            double x = this.mc.f_91074_.m_20185_();
            double y = this.mc.f_91074_.m_20186_();
            double z = this.mc.f_91074_.m_20189_();
            int yb = Mth.m_14107_((double)y) - 1;
            this.list.clear();
            this.list.add(new BlockPos(Mth.m_14107_((double)x), yb, Mth.m_14107_((double)z)));
            if (config.distance > 0.0) {
                BlockPos bp4;
                BlockPos bp3;
                BlockPos bp2;
                BlockPos bp1 = new BlockPos((Vec3i)new BlockPos(Mth.m_14107_((double)(x + config.distance)), yb, Mth.m_14107_((double)z)));
                if (!this.list.contains(bp1)) {
                    this.list.add(bp1);
                }
                if (!this.list.contains(bp2 = new BlockPos((Vec3i)new BlockPos(Mth.m_14107_((double)(x - config.distance)), yb, Mth.m_14107_((double)z))))) {
                    this.list.add(bp2);
                }
                if (!this.list.contains(bp3 = new BlockPos((Vec3i)new BlockPos(Mth.m_14107_((double)x), yb, Mth.m_14107_((double)(z - config.distance)))))) {
                    this.list.add(bp3);
                }
                if (!this.list.contains(bp4 = new BlockPos((Vec3i)new BlockPos(Mth.m_14107_((double)x), yb, Mth.m_14107_((double)(z + config.distance)))))) {
                    this.list.add(bp4);
                }
            }
            boolean placed = false;
            for (BlockPos bp : this.list) {
                if (!this.canPlaceBlock(this.mc.f_91073_.m_8055_(bp))) continue;
                for (Direction direction : Direction.values()) {
                    BlockPos other = bp.m_121945_(direction);
                    BlockState state = this.mc.f_91073_.m_8055_(other);
                    if (state.m_60808_((BlockGetter)this.mc.f_91073_, other).m_83281_()) continue;
                    this.placeBlock(bp, direction.m_122424_(), other, config);
                    placed = true;
                    break;
                }
                if (!placed) continue;
                break;
            }
            if (!placed && config.attachToAir) {
                for (BlockPos bp : this.list) {
                    if (!this.canPlaceBlock(this.mc.f_91073_.m_8055_(bp))) continue;
                    BlockPos other = bp.m_121945_(Direction.DOWN);
                    this.placeBlock(bp, Direction.UP, other, config);
                    break;
                }
            }
        }
    }

    private boolean canPlaceBlock(BlockState state) {
        return state.m_247087_();
    }

    private void placeBlock(BlockPos destination, Direction direction, BlockPos neighbour, ScaffoldConfig config) {
        int selectedSlot = this.mc.f_91074_.m_150109_().f_35977_;
        Optional<InteractionHand> optional = this.selectItem(config);
        if (optional.isEmpty()) {
            return;
        }
        InteractionHand hand = optional.get();
        ItemStack itemStack = this.mc.f_91074_.m_21120_(hand);
        Item item = itemStack.m_41720_();
        Vec3 location = new Vec3((double)((float)destination.m_123341_() + 0.5f) + (double)direction.m_122424_().m_122429_() * 0.5, (double)((float)destination.m_123342_() + 0.5f) + (double)direction.m_122424_().m_122430_() * 0.5, (double)((float)destination.m_123343_() + 0.5f) + (double)direction.m_122424_().m_122431_() * 0.5);
        BlockHitResult hit = new BlockHitResult(location, direction, neighbour, false);
        InteractionResult result = this.mc.f_91072_.m_233732_(this.mc.f_91074_, hand, hit);
        if (result.m_19077_() && result.m_19080_()) {
            this.mc.f_91074_.m_6674_(hand);
        }
        if (config.keepSelectedSlot) {
            this.mc.f_91074_.m_150109_().f_35977_ = selectedSlot;
        }
        if (itemStack.m_41619_() && config.replaceBlocksFromInventory) {
            for (int i = 9; i < 36; ++i) {
                ItemStack itemStack1 = this.mc.f_91074_.m_150109_().m_8020_(i);
                if (itemStack1.m_41619_() || item != itemStack1.m_41720_()) continue;
                InventoryUtils.moveItemStack(new InventorySlot(i), hand == InteractionHand.MAIN_HAND ? new InventorySlot(this.mc.f_91074_.m_150109_().f_35977_) : new InventorySlot(EquipmentSlot.OFFHAND));
                return;
            }
        }
    }

    private Optional<InteractionHand> selectItem(ScaffoldConfig config) {
        BlockItem blockItem;
        BlockItem blockItem2;
        Item mainHandItem = this.mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (mainHandItem instanceof BlockItem && this.isValidBlock((blockItem2 = (BlockItem)mainHandItem).m_40614_(), config)) {
            return Optional.of(InteractionHand.MAIN_HAND);
        }
        Item offHandItem = this.mc.f_91074_.m_21120_(InteractionHand.OFF_HAND).m_41720_();
        if (offHandItem instanceof BlockItem && this.isValidBlock((blockItem = (BlockItem)offHandItem).m_40614_(), config)) {
            return Optional.of(InteractionHand.OFF_HAND);
        }
        for (int i = 0; i < 9; ++i) {
            BlockItem blockItem3;
            ItemStack stack = this.mc.f_91074_.m_150109_().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem) || !this.isValidBlock((blockItem3 = (BlockItem)item).m_40614_(), config)) continue;
            this.mc.f_91074_.m_150109_().f_35977_ = i;
            return Optional.of(InteractionHand.MAIN_HAND);
        }
        return Optional.empty();
    }

    private boolean isValidBlock(Block block, ScaffoldConfig config) {
        if (!block.m_49966_().m_60838_((BlockGetter)this.mc.f_91073_, new BlockPos(0, 0, 0))) {
            return false;
        }
        return !(block instanceof FallingBlock);
    }
}

