/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.hacks;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.KillAuraConfig;
import com.zergatul.cheatutils.controllers.FakeRotationController;
import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import com.zergatul.cheatutils.controllers.PlayerMotionController;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.utils.MathUtils;
import com.zergatul.cheatutils.wrappers.AttackRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class KillAura
implements Module {
    public static final KillAura instance = new KillAura();
    private final Minecraft mc = Minecraft.m_91087_();
    private long ticks;
    private long lastAttackTick;
    private Entity target;
    private final List<Entity> targets = new ArrayList<Entity>();

    private KillAura() {
        PlayerMotionController.instance.addOnAfterSendPosition(this::onAfterSendPosition);
        Events.ClientPlayerLoggingIn.add(this::onPlayerLoggingIn);
        Events.ClientTickEnd.add(this::onClientTickEnd);
        Events.DimensionChange.add(this::onDimensionChange);
    }

    public void onEnabled() {
        this.lastAttackTick = 0L;
    }

    private void onPlayerLoggingIn(Connection connection) {
        this.ticks = 0L;
        this.lastAttackTick = 0L;
    }

    private void onDimensionChange() {
        this.lastAttackTick = 0L;
    }

    private void onClientTickEnd() {
        ++this.ticks;
        KillAuraConfig config = ConfigStore.instance.getConfig().killAuraConfig;
        if (!config.enabled) {
            this.target = null;
            this.targets.clear();
            return;
        }
        LocalPlayer player = this.mc.f_91074_;
        ClientLevel world = this.mc.f_91073_;
        if (player == null || world == null) {
            return;
        }
        if (!this.shouldAttackNow(config)) {
            return;
        }
        this.target = null;
        this.targets.clear();
        int targetPriority = Integer.MAX_VALUE;
        double targetDistance2 = Double.MAX_VALUE;
        double maxRange2 = this.getRangeSquared(config);
        Vec3 eyePos = player.m_146892_();
        for (Entity entity : world.m_104735_()) {
            int priority;
            LivingEntity living;
            double distance2 = entity.m_20238_(eyePos);
            if (distance2 > maxRange2 || entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_6084_() || (priority = this.getPriority(config, entity)) < 0) continue;
            if (config.maxHorizontalAngle != null || config.maxVerticalAngle != null) {
                double targetXRot;
                double targetYRot;
                double delta;
                Vec3 attackPoint = this.getAttackPoint(entity);
                Vec3 diff = attackPoint.m_82546_(eyePos);
                double diffXZ = Math.sqrt(diff.f_82479_ * diff.f_82479_ + diff.f_82480_ * diff.f_82480_);
                if (config.maxHorizontalAngle != null && (delta = MathUtils.deltaAngle180(targetYRot = Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0, player.m_146908_())) > config.maxHorizontalAngle || config.maxVerticalAngle != null && (delta = MathUtils.deltaAngle180(targetXRot = Math.toDegrees(-Math.atan2(diff.f_82480_, diffXZ)), player.m_146909_())) > config.maxVerticalAngle) continue;
            }
            if (config.attackAll) {
                this.targets.add(entity);
                continue;
            }
            if (priority >= targetPriority && (priority != targetPriority || !(distance2 < targetDistance2))) continue;
            this.target = entity;
            targetPriority = priority;
            targetDistance2 = distance2;
        }
        if (this.target != null) {
            FakeRotationController.instance.setServerRotation(this.getAttackPoint(this.target));
        }
        if (this.targets.size() > 0) {
            this.targets.sort(Comparator.comparingDouble(e -> e.m_20238_(eyePos)));
        }
    }

    private Vec3 getAttackPoint(Entity entity) {
        return entity.m_20191_().m_82399_();
    }

    private int getPriority(KillAuraConfig config, Entity entity) {
        int i = 0;
        for (KillAuraConfig.PriorityEntry entry : config.priorities) {
            if (entry.enabled && entry.predicate.test(entity)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void onAfterSendPosition() {
        LocalPlayer player;
        if (this.target != null) {
            player = this.mc.f_91074_;
            this.mc.f_91072_.m_105223_((Player)player, this.target);
            this.mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
            this.target = null;
            this.lastAttackTick = this.ticks;
        }
        if (this.targets.size() > 0) {
            player = this.mc.f_91074_;
            this.mc.f_91072_.m_105223_((Player)player, this.targets.get(0));
            for (int i = 1; i < this.targets.size(); ++i) {
                NetworkPacketsController.instance.sendPacket((Packet<?>)ServerboundInteractPacket.m_179605_((Entity)this.targets.get(i), (boolean)player.m_6144_()));
            }
            this.mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
            this.targets.clear();
            this.lastAttackTick = this.ticks;
        }
    }

    private double getRangeSquared(KillAuraConfig config) {
        double range = config.overrideAttackRange ? config.maxRange : AttackRange.get();
        return range * range;
    }

    private boolean shouldAttackNow(KillAuraConfig config) {
        if ("Cooldown".equals(config.delayMode)) {
            return this.mc.f_91074_.m_36403_((float)(-config.extraTicks)) == 1.0f;
        }
        return this.ticks - this.lastAttackTick >= (long)config.attackTickInterval;
    }
}

