/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.hacks;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ElytraHackConfig;
import com.zergatul.cheatutils.modules.Module;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class ElytraFly
implements Module {
    public static final ElytraFly instance = new ElytraFly();
    private final Minecraft mc = Minecraft.m_91087_();
    private boolean applySpeedLimit;
    private boolean applyFly;

    private ElytraFly() {
        Events.ClientTickStart.add(this::onClientTickStart);
        Events.ClientTickEnd.add(this::onClientTickEnd);
    }

    public Vec3 onBeforeMove(MoverType type, Vec3 delta) {
        if (type == MoverType.SELF && this.applySpeedLimit) {
            ElytraHackConfig config = ConfigStore.instance.getConfig().elytraHackConfig;
            double speed = delta.m_82553_() * 20.0;
            if (speed > config.maxSpeed) {
                delta = delta.m_82541_().m_82490_(config.maxSpeed / 20.0);
            }
            this.mc.f_91074_.m_20256_(delta);
        }
        return delta;
    }

    public void onBeforeAiStep() {
        ElytraHackConfig config = ConfigStore.instance.getConfig().elytraHackConfig;
        if (this.applyFly) {
            this.mc.f_91074_.m_36321_();
            this.mc.f_91074_.m_150110_().f_35935_ = true;
            this.mc.f_91074_.m_150110_().m_35943_((float)(config.maxSpeed / 100.0));
        }
    }

    public float onModifyFlyingHorizontalMultiplier(float value) {
        return this.applyFly ? 1.6666666f : value;
    }

    public void onAfterAiStep() {
        if (this.applyFly) {
            if (this.mc.f_91074_.m_150110_().f_35935_) {
                this.mc.f_91074_.m_36320_();
            }
            this.mc.f_91074_.m_150110_().f_35935_ = false;
            this.applyFly = false;
        }
    }

    public boolean shouldPlaySound() {
        return !this.applyFly;
    }

    private void onClientTickStart() {
        ElytraHackConfig config = ConfigStore.instance.getConfig().elytraHackConfig;
        if (!config.enabled) {
            return;
        }
        if (this.mc.f_91074_ == null) {
            return;
        }
        ItemStack chest = this.mc.f_91074_.m_6844_(EquipmentSlot.CHEST);
        if (chest.m_41720_() != Items.f_42741_) {
            return;
        }
        if (!this.mc.f_91074_.m_21255_()) {
            return;
        }
        switch (config.method) {
            case "CreativeFly": {
                this.applyFly = true;
                this.applySpeedLimit = true;
                break;
            }
            default: {
                Vec3 delta = this.mc.f_91074_.m_20184_();
                Input input = this.mc.f_91074_.f_108618_;
                if (input.f_108572_) {
                    delta = delta.m_82520_(0.0, config.vanillaFlyVerticalAcceleration / 20.0, 0.0);
                }
                if (input.f_108573_) {
                    delta = delta.m_82492_(0.0, config.vanillaFlyVerticalAcceleration / 20.0, 0.0);
                }
                float yaw = (float)Math.toRadians(this.mc.f_91074_.m_146908_());
                Vec3 forward = new Vec3(-Math.sin(yaw), 0.0, Math.cos(yaw)).m_82490_(config.vanillaFlyHorizontalAcceleration / 20.0);
                if (input.f_108568_) {
                    delta = delta.m_82549_(forward);
                }
                if (input.f_108569_) {
                    delta = delta.m_82546_(forward);
                }
                this.mc.f_91074_.m_20256_(delta);
                this.applySpeedLimit = true;
            }
        }
    }

    private void onClientTickEnd() {
        this.applySpeedLimit = false;
    }
}

