/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.hacks;

import com.mojang.datafixers.util.Pair;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.mixins.common.accessors.ClientLevelAccessor;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.scripting.api.Root;
import com.zergatul.cheatutils.utils.BlockPlacingMethod;
import com.zergatul.cheatutils.utils.BlockUtils;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.prediction.BlockStatePredictionHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BedrockBreaker
implements Module {
    public static final BedrockBreaker instance = new BedrockBreaker();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Direction[] horizontal = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};
    private BlockPos bedrockPos;
    private BlockPos torchPos;
    private State state;
    private int tickCount;

    private BedrockBreaker() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
    }

    public void process() {
        if (this.mc.f_91074_ == null) {
            return;
        }
        if (this.mc.f_91073_ == null) {
            return;
        }
        if (this.mc.f_91077_ == null) {
            return;
        }
        if (this.mc.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult hitResult = (BlockHitResult)this.mc.f_91077_;
        BlockPos pos = hitResult.m_82425_();
        if (this.mc.f_91073_.m_8055_(pos).m_60734_() != Blocks.f_50752_) {
            return;
        }
        if (this.bedrockPos != null && this.bedrockPos.equals((Object)pos)) {
            return;
        }
        this.bedrockPos = pos;
        this.state = State.START;
        this.tickCount = 0;
    }

    private void onClientTickEnd() {
        if (this.mc.f_91074_ == null) {
            return;
        }
        if (this.mc.f_91073_ == null) {
            return;
        }
        if (this.bedrockPos == null) {
            return;
        }
        ++this.tickCount;
        switch (this.state) {
            case START: {
                int pistonSlot = this.findItem(Items.f_41869_);
                if (pistonSlot < 0) {
                    this.reset("Cannot find piston on hotbar");
                    return;
                }
                BlockUtils.PlaceBlockPlan plan = BlockUtils.getPlacingPlan(this.bedrockPos.m_7494_(), false, BlockPlacingMethod.FACING_TOP);
                if (plan == null) {
                    this.reset("Cannot place initial piston");
                    return;
                }
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundSetCarriedItemPacket(pistonSlot));
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(this.mc.f_91074_.m_146908_(), 90.0f, this.mc.f_91074_.m_20096_()));
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundUseItemOnPacket(InteractionHand.MAIN_HAND, new BlockHitResult(plan.target(), plan.direction(), plan.neighbour(), false), this.getSequenceNumber()));
                int torchSlot = this.findItem(Items.f_41978_);
                if (torchSlot < 0) {
                    this.reset("Cannot find redstone torch on hotbar");
                    return;
                }
                this.torchPos = null;
                for (Direction direction : this.sortByDistance(this.bedrockPos.m_7494_(), this.horizontal)) {
                    BlockPos pos = this.bedrockPos.m_7494_().m_121945_(direction);
                    BlockState state = this.mc.f_91073_.m_8055_(pos);
                    if (!Blocks.f_50174_.m_7898_(Blocks.f_50174_.m_49966_(), (LevelReader)this.mc.f_91073_, pos) || !state.m_247087_()) continue;
                    this.torchPos = pos;
                    break;
                }
                if (this.torchPos == null) {
                    this.reset("Cannot find location to place torch");
                    return;
                }
                plan = BlockUtils.getPlacingPlan(this.torchPos, false, BlockPlacingMethod.FROM_TOP, Blocks.f_50174_.m_49966_());
                if (plan == null) {
                    this.reset("Cannot place redstone torch");
                    return;
                }
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundSetCarriedItemPacket(torchSlot));
                this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundUseItemOnPacket(InteractionHand.MAIN_HAND, new BlockHitResult(plan.target(), plan.direction(), plan.neighbour(), false), this.getSequenceNumber()));
                this.state = State.WAIT_PISTON_EXTEND;
                break;
            }
            case WAIT_PISTON_EXTEND: {
                if (this.mc.f_91073_.m_8055_(this.bedrockPos.m_7494_().m_7494_()).m_60734_() == Blocks.f_50040_) {
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, this.torchPos, Direction.UP, this.getSequenceNumber()));
                    this.mc.f_91073_.m_46961_(this.torchPos, false);
                    int pickaxeSlot = this.findItem(Items.f_42395_);
                    if (pickaxeSlot < 0) {
                        this.reset("Cannot select pickaxe");
                        return;
                    }
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundSetCarriedItemPacket(pickaxeSlot));
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, this.bedrockPos.m_7494_(), Direction.UP, this.getSequenceNumber()));
                    this.mc.f_91073_.m_46961_(this.bedrockPos.m_7494_(), false);
                    int pistonSlot = this.findItem(Items.f_41869_);
                    if (pistonSlot < 0) {
                        this.reset("Cannot select piston");
                        return;
                    }
                    BlockUtils.PlaceBlockPlan plan = BlockUtils.getPlacingPlan(this.bedrockPos.m_7494_(), false, BlockPlacingMethod.FACING_BOTTOM);
                    if (plan == null) {
                        this.reset("Cannot place reverse piston");
                        return;
                    }
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundSetCarriedItemPacket(pistonSlot));
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(this.mc.f_91074_.m_146908_(), -90.0f, this.mc.f_91074_.m_20096_()));
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundUseItemOnPacket(InteractionHand.MAIN_HAND, new BlockHitResult(plan.target(), plan.direction(), plan.neighbour(), false), this.getSequenceNumber()));
                    this.state = State.WAIT_BEDROCK_BREAK;
                    break;
                }
                if (this.tickCount <= 10) break;
                this.reset("Wait for piston extend timeout");
                break;
            }
            case WAIT_BEDROCK_BREAK: {
                if (this.mc.f_91073_.m_8055_(this.bedrockPos).m_60795_()) {
                    if (this.mc.f_91073_.m_8055_(this.bedrockPos.m_7494_()).m_60713_(Blocks.f_50110_)) {
                        return;
                    }
                    int pickaxeSlot = this.findItem(Items.f_42395_);
                    if (pickaxeSlot < 0) {
                        this.reset("Cannot select pickaxe");
                        return;
                    }
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundSetCarriedItemPacket(pickaxeSlot));
                    this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, this.bedrockPos.m_7494_(), Direction.DOWN, this.getSequenceNumber()));
                    this.reset(null);
                    break;
                }
                if (this.tickCount <= 20) break;
                this.reset("Wait for bedrock break timeout");
            }
        }
    }

    private int findItem(Item item) {
        Inventory inventory = this.mc.f_91074_.m_150109_();
        for (int i = 0; i < 9; ++i) {
            if (!inventory.m_8020_(i).m_150930_(item)) continue;
            return i;
        }
        return -1;
    }

    private int getSequenceNumber() {
        BlockStatePredictionHandler handler = ((ClientLevelAccessor)this.mc.f_91073_).getBlockStatePredictionHandler_CU();
        handler.m_233855_();
        int num = handler.m_233871_();
        handler.close();
        return num;
    }

    private Direction[] sortByDistance(BlockPos origin, Direction[] directions) {
        return (Direction[])Arrays.stream(directions).map(d -> new Pair(d, (Object)origin.m_121945_(d).m_203193_((Position)this.mc.f_91074_.m_146892_()))).sorted(Comparator.comparingDouble(Pair::getSecond)).map(p -> (Direction)p.getFirst()).toArray(Direction[]::new);
    }

    private void reset(String message) {
        this.bedrockPos = null;
        this.state = State.START;
        this.tickCount = 0;
        if (this.mc.f_91074_ != null) {
            this.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundSetCarriedItemPacket(this.mc.f_91074_.m_150109_().f_35977_));
        }
        if (message != null) {
            Root.main.systemMessage(message);
        }
    }

    private static enum State {
        START,
        WAIT_PISTON_EXTEND,
        WAIT_BEDROCK_BREAK;

    }
}

