/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.esp;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.zergatul.cheatutils.collections.LinesIterable;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ProjectilePathConfig;
import com.zergatul.cheatutils.modules.utilities.RenderUtilities;
import com.zergatul.cheatutils.render.DebugLinesLineRenderer;
import com.zergatul.cheatutils.render.LineRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class ProjectilePath {
    public static final ProjectilePath instance = new ProjectilePath();
    private final Minecraft mc = Minecraft.m_91087_();
    private final List<ThrowableItemEntry> entries = Lists.newArrayList((Object[])new ThrowableItemEntry[]{new EnderPearlEntry(), new SnowballEntry(), new EggEntry(), new PotionEntry(), new ExpBottleEntry(), new BowItemEntry(), new CrossbowItemEntry(), new TridentItemEntry()});
    private final Map<Integer, LinkedList<TraceRecord>> traces = new HashMap<Integer, LinkedList<TraceRecord>>();

    private ProjectilePath() {
        Events.RenderWorldLast.add(this::render);
    }

    private void render(RenderWorldLastEvent event) {
        if (this.mc.f_91073_ == null) {
            return;
        }
        if (!ConfigStore.instance.getConfig().esp) {
            return;
        }
        ProjectilePathConfig config = this.getConfig();
        if (config.showTraces) {
            LinkedList<TraceRecord> list;
            long time = System.nanoTime();
            for (Entity entity : this.mc.f_91073_.m_104735_()) {
                if (!(entity instanceof Projectile)) continue;
                if (!this.traces.containsKey(entity.m_19879_())) {
                    this.traces.put(entity.m_19879_(), new LinkedList());
                }
                list = this.traces.get(entity.m_19879_());
                Vec3 vec3 = entity.m_20318_(event.getTickDelta());
                if (list.size() == 0) {
                    list.addFirst(new TraceRecord(vec3, time));
                    continue;
                }
                TraceRecord first = list.getFirst();
                if (first.position.m_82557_(vec3) > 0.01) {
                    list.addFirst(new TraceRecord(vec3, time));
                    continue;
                }
                first.position = vec3;
                first.time = time;
            }
            Iterator<Map.Entry<Integer, LinkedList<TraceRecord>>> iterator = this.traces.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, LinkedList<TraceRecord>> entry = iterator.next();
                list = entry.getValue();
                while (list.size() > 0 && list.getLast().time + (long)config.tracesDuration * 1000000000L < time) {
                    list.removeLast();
                }
                if (list.size() != 0) continue;
                iterator.remove();
            }
            DebugLinesLineRenderer renderer = new DebugLinesLineRenderer();
            renderer.begin(event, true);
            for (List list2 : this.traces.values()) {
                if (list2.size() < 2) continue;
                for (Pair pair : new LinesIterable(list2)) {
                    TraceRecord r1 = (TraceRecord)pair.getFirst();
                    TraceRecord r2 = (TraceRecord)pair.getSecond();
                    long remain1 = r1.time + (long)config.tracesDuration * 1000000000L - time;
                    float alpha1 = Math.min(1.0f, (float)remain1 / 1.0E9f / (float)config.fadeDuration);
                    long remain2 = r2.time + (long)config.tracesDuration * 1000000000L - time;
                    float alpha2 = Math.min(1.0f, (float)remain2 / 1.0E9f / (float)config.fadeDuration);
                    ((LineRenderer)renderer).line(r1.position.f_82479_, r1.position.f_82480_, r1.position.f_82481_, 0.5f, 1.0f, 0.5f, alpha1, r2.position.f_82479_, r2.position.f_82480_, r2.position.f_82481_, 0.5f, 1.0f, 0.5f, alpha2);
                }
            }
            ((LineRenderer)renderer).end();
        }
        ThrowableItemEntry entry = null;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).shouldDraw()) continue;
            entry = this.entries.get(i);
            break;
        }
        if (entry == null) {
            return;
        }
        if (this.mc.f_91074_ == null) {
            return;
        }
        Vec3 playerPos = event.getPlayerPos();
        float partialTick = event.getTickDelta();
        double x = playerPos.f_82479_;
        double d = playerPos.f_82480_ + (double)this.mc.f_91074_.m_20192_();
        double z = playerPos.f_82481_;
        Vec3 from = new Vec3(x, d, z);
        float xRot = this.mc.f_91074_.m_5686_(partialTick);
        float yRot = this.mc.f_91074_.m_5675_(partialTick);
        double shiftX = -Mth.m_14031_((float)((yRot + 90.0f) * ((float)Math.PI / 180)));
        double shiftY = -0.5;
        double shiftZ = Mth.m_14089_((float)((yRot + 90.0f) * ((float)Math.PI / 180)));
        Vec3 shift = new Vec3(shiftX, shiftY, shiftZ);
        float speedX = -Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        float speedY = -Mth.m_14031_((float)((xRot + entry.getXRotDelta()) * ((float)Math.PI / 180)));
        float speedZ = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
        Vec3 movement = new Vec3((double)speedX, (double)speedY, (double)speedZ).m_82541_().m_82490_((double)entry.getSpeed());
        Vec3 playerSpeed = this.mc.f_91074_.m_20184_();
        if (this.mc.f_91074_.m_20096_()) {
            playerSpeed = playerSpeed.m_82492_(0.0, playerSpeed.f_82480_, 0.0);
        }
        movement = movement.m_82549_(playerSpeed);
        LineRenderer renderer = RenderUtilities.instance.getLineRenderer();
        renderer.begin(event, true);
        List<Vec3> mainPath = this.calculatePath(entry, from, movement, shift);
        this.drawPath(mainPath, renderer);
        renderer.end();
    }

    private ProjectilePathConfig getConfig() {
        return ConfigStore.instance.getConfig().projectilePathConfig;
    }

    private List<Vec3> calculatePath(ThrowableItemEntry entry, Vec3 from, Vec3 speed, Vec3 shift) {
        ArrayList<Vec3> list = new ArrayList<Vec3>(100);
        for (int i = 0; i < 100; ++i) {
            list.add(from.m_82549_(shift.m_82490_(this.getShiftFactor(i))));
            from = from.m_82549_(speed);
            speed = speed.m_82490_((double)entry.getResistance()).m_82520_(0.0, (double)(-entry.getGravity()), 0.0);
        }
        return list;
    }

    private void drawPath(List<Vec3> path, LineRenderer renderer) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Vec3 point1 = path.get(i);
            Vec3 point2 = path.get(i + 1);
            renderer.line(point1.f_82479_, point1.f_82480_, point1.f_82481_, point2.f_82479_, point2.f_82480_, point2.f_82481_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private double getShiftFactor(int step) {
        return 1.0 / (4.0 + 1.0 * (double)step * (double)step / 20.0);
    }

    private ItemStack getItemStackInHand() {
        LocalPlayer player = this.mc.f_91074_;
        if (player == null) {
            return null;
        }
        return player.m_21120_(InteractionHand.MAIN_HAND);
    }

    private static abstract class ThrowableItemEntry {
        private ThrowableItemEntry() {
        }

        public abstract boolean shouldDraw();

        public abstract float getXRotDelta();

        public abstract float getSpeed();

        public abstract float getGravity();

        public float getResistance() {
            return 0.99f;
        }

        public abstract float getDeviation();
    }

    private class EnderPearlEntry
    extends SimpleThrowableItemEntry {
        public EnderPearlEntry() {
            super(Items.f_42584_, 0.0f, 1.5f, 1.0f);
        }

        @Override
        public boolean shouldDraw() {
            return ProjectilePath.this.getConfig().enderPearls && super.shouldDraw();
        }
    }

    private class SnowballEntry
    extends SimpleThrowableItemEntry {
        public SnowballEntry() {
            super(Items.f_42452_, 0.0f, 1.5f, 1.0f);
        }

        @Override
        public boolean shouldDraw() {
            return ProjectilePath.this.getConfig().snowballs && super.shouldDraw();
        }
    }

    private class EggEntry
    extends SimpleThrowableItemEntry {
        public EggEntry() {
            super(Items.f_42521_, 0.0f, 1.5f, 1.0f);
        }

        @Override
        public boolean shouldDraw() {
            return ProjectilePath.this.getConfig().eggs && super.shouldDraw();
        }
    }

    private class PotionEntry
    extends SimpleThrowableItemEntry {
        public PotionEntry() {
            super(Items.f_42736_, -20.0f, 0.5f, 1.0f);
        }

        @Override
        public boolean shouldDraw() {
            return ProjectilePath.this.getConfig().potions && super.shouldDraw();
        }

        @Override
        public float getGravity() {
            return 0.05f;
        }
    }

    private class ExpBottleEntry
    extends SimpleThrowableItemEntry {
        public ExpBottleEntry() {
            super(Items.f_42612_, -20.0f, 0.7f, 1.0f);
        }

        @Override
        public boolean shouldDraw() {
            return ProjectilePath.this.getConfig().expBottles && super.shouldDraw();
        }

        @Override
        public float getGravity() {
            return 0.07f;
        }
    }

    private class BowItemEntry
    extends ThrowableItemEntry {
        private BowItemEntry() {
        }

        @Override
        public boolean shouldDraw() {
            if (!ProjectilePath.this.getConfig().bows) {
                return false;
            }
            LocalPlayer player = ProjectilePath.this.mc.f_91074_;
            if (player == null) {
                return false;
            }
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (itemStack.m_41720_() != Items.f_42411_) {
                return false;
            }
            return player.m_6117_();
        }

        @Override
        public float getXRotDelta() {
            return 0.0f;
        }

        @Override
        public float getSpeed() {
            LocalPlayer player = ProjectilePath.this.mc.f_91074_;
            if (player == null) {
                return 0.0f;
            }
            int ticks = player.m_21252_();
            float power = BowItem.m_40661_((int)ticks);
            return power * 3.0f;
        }

        @Override
        public float getGravity() {
            return 0.05f;
        }

        @Override
        public float getDeviation() {
            return 1.0f;
        }
    }

    private class CrossbowItemEntry
    extends BowItemEntry {
        private CrossbowItemEntry() {
        }

        @Override
        public boolean shouldDraw() {
            if (!ProjectilePath.this.getConfig().crossbows) {
                return false;
            }
            ItemStack itemStack = ProjectilePath.this.getItemStackInHand();
            if (itemStack == null) {
                return false;
            }
            if (itemStack.m_41720_() != Items.f_42717_) {
                return false;
            }
            return CrossbowItem.m_40932_((ItemStack)itemStack);
        }

        @Override
        public float getSpeed() {
            ItemStack itemStack = ProjectilePath.this.getItemStackInHand();
            if (itemStack == null) {
                return 0.0f;
            }
            return CrossbowItem.m_40871_((ItemStack)itemStack, (Item)Items.f_42688_) ? 1.6f : 3.15f;
        }
    }

    private class TridentItemEntry
    extends BowItemEntry {
        private TridentItemEntry() {
        }

        @Override
        public boolean shouldDraw() {
            if (!ProjectilePath.this.getConfig().tridents) {
                return false;
            }
            LocalPlayer player = ProjectilePath.this.mc.f_91074_;
            if (player == null) {
                return false;
            }
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            return itemStack.m_41720_() == Items.f_42713_;
        }

        @Override
        public float getXRotDelta() {
            return 0.0f;
        }

        @Override
        public float getSpeed() {
            return 2.5f;
        }

        @Override
        public float getDeviation() {
            return 1.0f;
        }
    }

    private static class TraceRecord {
        public Vec3 position;
        public long time;

        public TraceRecord(Vec3 position, long time) {
            this.position = position;
            this.time = time;
        }
    }

    private abstract class SimpleThrowableItemEntry
    extends ThrowableItemEntry {
        private final Item item;
        private final float xRotDelta;
        private final float speed;
        private final float deviation;

        public SimpleThrowableItemEntry(Item item, float xRotDelta, float speed, float deviation) {
            this.item = item;
            this.xRotDelta = xRotDelta;
            this.speed = speed;
            this.deviation = deviation;
        }

        @Override
        public boolean shouldDraw() {
            ItemStack itemStack = ProjectilePath.this.getItemStackInHand();
            if (itemStack == null) {
                return false;
            }
            return itemStack.m_41720_() == this.item;
        }

        @Override
        public float getXRotDelta() {
            return this.xRotDelta;
        }

        @Override
        public float getSpeed() {
            return this.speed;
        }

        @Override
        public float getGravity() {
            return 0.03f;
        }

        @Override
        public float getDeviation() {
            return this.deviation;
        }
    }
}

