/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.esp;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.LightLevelConfig;
import com.zergatul.cheatutils.controllers.ChunkController;
import com.zergatul.cheatutils.interfaces.LevelChunkMixinInterface;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.utils.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class LightLevel
implements Module {
    public static final LightLevel instance = new LightLevel();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Logger logger = LogManager.getLogger(LightLevel.class);
    private final ResourceLocation[] textures = new ResourceLocation[16];
    private final Object loopWaitEvent = new Object();
    private final Thread eventLoop;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final HashMap<ChunkPos, HashSet<BlockPos>> chunks = new HashMap();
    private final List<BlockPos> listForRendering = new ArrayList<BlockPos>();
    private boolean active = false;
    private VertexBuffer vertexBuffer;
    private final Map<Direction, Pair<float[], float[]>> rotations = Map.ofEntries(Map.entry(Direction.NORTH, new Pair((Object)new float[]{0.0f, 0.0f, 1.0f, 1.0f}, (Object)new float[]{0.0f, 1.0f, 1.0f, 0.0f})), Map.entry(Direction.SOUTH, new Pair((Object)new float[]{1.0f, 1.0f, 0.0f, 0.0f}, (Object)new float[]{1.0f, 0.0f, 0.0f, 1.0f})), Map.entry(Direction.EAST, new Pair((Object)new float[]{0.0f, 1.0f, 1.0f, 0.0f}, (Object)new float[]{1.0f, 1.0f, 0.0f, 0.0f})), Map.entry(Direction.WEST, new Pair((Object)new float[]{1.0f, 0.0f, 0.0f, 1.0f}, (Object)new float[]{0.0f, 0.0f, 1.0f, 1.0f})));

    private LightLevel() {
        for (int i = 0; i < 16; ++i) {
            this.textures[i] = new ResourceLocation("cheatutils", "textures/light-level-" + i + ".png");
        }
        RenderSystem.recordRenderCall(() -> {
            this.vertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        });
        Events.RenderWorldLast.add(this::render);
        Events.ScannerChunkLoaded.add(this::onChunkLoaded);
        Events.ScannerChunkUnloaded.add(this::onChunkUnLoaded);
        Events.ScannerBlockUpdated.add(this::onBlockChanged);
        this.eventLoop = new Thread(() -> {
            try {
                block6: while (true) {
                    Object object = this.loopWaitEvent;
                    synchronized (object) {
                        this.loopWaitEvent.wait();
                    }
                    while (true) {
                        if (this.queue.size() <= 0) continue block6;
                        Runnable process = this.queue.remove();
                        process.run();
                        Thread.yield();
                    }
                    break;
                }
            }
            catch (InterruptedException process) {
            }
            catch (Throwable e) {
                this.logger.error("LightLevel scan thread crash.", e);
            }
        }, "LightLevelScanThread");
        this.eventLoop.start();
    }

    public void onChanged() {
        boolean value = ConfigStore.instance.getConfig().lightLevelConfig.enabled;
        if (this.active != value) {
            this.active = value;
            if (this.active) {
                for (Pair<Dimension, LevelChunk> pair : ChunkController.instance.getLoadedChunks()) {
                    this.onChunkLoaded((LevelChunk)pair.getSecond());
                }
            } else {
                this.queue.clear();
            }
        }
    }

    private void render(RenderWorldLastEvent event) {
        LightLevelConfig config = ConfigStore.instance.getConfig().lightLevelConfig;
        if (!config.enabled) {
            return;
        }
        Camera camera = this.mc.f_91063_.m_109153_();
        Vec3 view = camera.m_90583_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Direction direction = Direction.m_122364_((double)camera.m_90590_());
        Pair<float[], float[]> texRot = this.rotations.get(direction);
        float[] u = (float[])texRot.getFirst();
        float[] v = (float[])texRot.getSecond();
        double maxDistance2 = config.maxDistance * config.maxDistance;
        double xc = config.useFreeCamPosition ? view.f_82479_ : this.mc.f_91074_.m_20185_();
        double yc = config.useFreeCamPosition ? view.f_82480_ : this.mc.f_91074_.m_20186_();
        double zc = config.useFreeCamPosition ? view.f_82481_ : this.mc.f_91074_.m_20189_();
        ArrayList<BlockPos> listTracers = new ArrayList<BlockPos>();
        for (BlockPos pos : this.getBlockForRendering()) {
            double dz;
            double dy;
            double dx = xc - (double)pos.m_123341_();
            if (dx * dx + (dy = yc - (double)pos.m_123342_()) * dy + (dz = zc - (double)pos.m_123343_()) * dz > maxDistance2) continue;
            int blockLight = this.mc.f_91073_.m_45517_(LightLayer.BLOCK, pos);
            if (blockLight == 0) {
                listTracers.add(pos);
            }
            if (!config.showLightLevelValue) continue;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.textures[blockLight]);
            float y = (float)((double)pos.m_123342_() + 0.05 - view.f_82480_);
            float x1 = (float)((double)pos.m_123341_() + 0.05 - view.f_82479_);
            float z1 = (float)((double)pos.m_123343_() + 0.05 - view.f_82481_);
            float x2 = x1 + 0.9f;
            float z2 = z1 + 0.9f;
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_5483_((double)x1, (double)y, (double)z1).m_7421_(u[0], v[0]).m_5752_();
            bufferBuilder.m_5483_((double)x1, (double)y, (double)z2).m_7421_(u[1], v[1]).m_5752_();
            bufferBuilder.m_5483_((double)x2, (double)y, (double)z2).m_7421_(u[2], v[2]).m_5752_();
            bufferBuilder.m_5483_((double)x2, (double)y, (double)z1).m_7421_(u[3], v[3]).m_5752_();
            this.vertexBuffer.m_85921_();
            this.vertexBuffer.m_231221_(bufferBuilder.m_231175_());
            this.vertexBuffer.m_253207_(event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172817_());
            VertexBuffer.m_85931_();
        }
        Vec3 tracerCenter = event.getTracerCenter();
        double tracerX = tracerCenter.f_82479_;
        double tracerY = tracerCenter.f_82480_;
        double tracerZ = tracerCenter.f_82481_;
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        for (BlockPos pos : listTracers) {
            double y = (double)pos.m_123342_() + 0.05 - view.f_82480_;
            if (config.showTracers) {
                buffer.m_5483_(tracerX - view.f_82479_, tracerY - view.f_82480_, tracerZ - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
                buffer.m_5483_((double)pos.m_123341_() + 0.5 - view.f_82479_, y, (double)pos.m_123343_() + 0.5 - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            }
            if (!config.showLocations) continue;
            double x1 = (double)pos.m_123341_() + 0.05 - view.f_82479_;
            double z1 = (double)pos.m_123343_() + 0.05 - view.f_82481_;
            double x2 = x1 + 0.9;
            double z2 = z1 + 0.9;
            buffer.m_5483_(x1, y, z1).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            buffer.m_5483_(x1, y, z2).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            buffer.m_5483_(x1, y, z2).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            buffer.m_5483_(x2, y, z2).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            buffer.m_5483_(x2, y, z2).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            buffer.m_5483_(x2, y, z1).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            buffer.m_5483_(x2, y, z1).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
            buffer.m_5483_(x1, y, z1).m_85950_(1.0f, 1.0f, 1.0f, 0.5f).m_5752_();
        }
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        GL11.glEnable((int)2848);
        this.vertexBuffer.m_85921_();
        this.vertexBuffer.m_231221_(buffer.m_231175_());
        this.vertexBuffer.m_253207_(event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockPos> getBlockForRendering() {
        this.listForRendering.clear();
        HashMap<ChunkPos, HashSet<BlockPos>> hashMap = this.chunks;
        synchronized (hashMap) {
            Iterator<HashSet<BlockPos>> iterator = this.chunks.values().iterator();
            while (iterator.hasNext()) {
                HashSet<BlockPos> set;
                HashSet<BlockPos> hashSet = set = iterator.next();
                synchronized (hashSet) {
                    this.listForRendering.addAll(set);
                }
            }
        }
        return this.listForRendering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChunkLoaded(LevelChunk chunk) {
        if (!this.active) {
            return;
        }
        this.queue.add(() -> {
            HashSet<Object> set;
            Dimension dimension = ((LevelChunkMixinInterface)chunk).getDimension();
            ChunkPos chunkPos = chunk.m_7697_();
            HashMap<ChunkPos, HashSet<BlockPos>> hashMap = this.chunks;
            synchronized (hashMap) {
                set = this.chunks.get(chunkPos);
                if (set == null) {
                    set = new HashSet();
                    this.chunks.put(chunkPos, set);
                }
            }
            int xc = chunk.m_7697_().f_45578_ << 4;
            int zc = chunk.m_7697_().f_45579_ << 4;
            HashSet<Object> hashSet = set;
            synchronized (hashSet) {
                set.clear();
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z);
                        for (int y = dimension.getMinY(); y <= height; ++y) {
                            int xb = xc | x;
                            int zb = zc | z;
                            BlockPos pos = new BlockPos(xb, y, zb);
                            this.checkBlock((ChunkAccess)chunk, pos, set);
                        }
                    }
                }
            }
        });
        Object object = this.loopWaitEvent;
        synchronized (object) {
            this.loopWaitEvent.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChunkUnLoaded(ChunkAccess chunk) {
        if (!this.active) {
            return;
        }
        this.queue.add(() -> {
            HashMap<ChunkPos, HashSet<BlockPos>> hashMap = this.chunks;
            synchronized (hashMap) {
                this.chunks.remove(chunk.m_7697_());
            }
        });
        Object object = this.loopWaitEvent;
        synchronized (object) {
            this.loopWaitEvent.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBlockChanged(BlockUpdateEvent event) {
        if (!this.active) {
            return;
        }
        this.queue.add(() -> {
            HashSet<BlockPos> set;
            LevelChunk chunk = event.chunk();
            Cloneable cloneable = this.chunks;
            synchronized (cloneable) {
                set = this.chunks.get(chunk.m_7697_());
            }
            if (set == null) {
                return;
            }
            cloneable = set;
            synchronized (cloneable) {
                BlockPos pos = event.pos();
                BlockPos above = pos.m_7494_();
                BlockPos below = pos.m_7495_();
                BlockPos below2 = below.m_7495_();
                set.remove(pos);
                set.remove(above);
                set.remove(below);
                set.remove(below2);
                this.checkBlock((ChunkAccess)chunk, pos, set);
                this.checkBlock((ChunkAccess)chunk, above, set);
                this.checkBlock((ChunkAccess)chunk, below, set);
                this.checkBlock((ChunkAccess)chunk, below2, set);
            }
        });
        Object object = this.loopWaitEvent;
        synchronized (object) {
            this.loopWaitEvent.notify();
        }
    }

    private void checkBlock(ChunkAccess chunk, BlockPos pos, HashSet<BlockPos> set) {
        if (this.canSpawnOn(chunk.m_8055_(pos), pos)) {
            BlockPos posAbove = pos.m_7494_();
            BlockState stateAbove = chunk.m_8055_(posAbove);
            if (stateAbove.m_280296_()) {
                return;
            }
            if (!stateAbove.m_60819_().m_76178_()) {
                return;
            }
            if (stateAbove.m_204336_(BlockTags.f_13054_)) {
                return;
            }
            BlockState stateAbove2 = chunk.m_8055_(posAbove.m_7494_());
            if (stateAbove2.m_280296_()) {
                return;
            }
            set.add(posAbove);
        }
    }

    private boolean canSpawnOn(BlockState state, BlockPos pos) {
        if (state.m_60734_() instanceof SlabBlock) {
            return state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.BOTTOM;
        }
        if (state.m_60734_() instanceof StairBlock) {
            return state.m_61143_((Property)StairBlock.f_56842_) == Half.TOP;
        }
        if (!state.m_60815_()) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_50752_) {
            return false;
        }
        return state.m_280296_() && state.m_60838_((BlockGetter)this.mc.f_91073_, pos);
    }
}

