/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.esp;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.FreeCamConfig;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.render.Primitives;
import com.zergatul.cheatutils.utils.FreeCamPath;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FreeCam
implements Module {
    public static final FreeCam instance = new FreeCam();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vector3f forwards = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f left = new Vector3f(1.0f, 0.0f, 0.0f);
    private final FreeCamPath path = new FreeCamPath(this);
    private boolean active;
    private CameraType oldCameraType;
    private Input playerInput;
    private Input freecamInput;
    private double x;
    private double y;
    private double z;
    private float yRot;
    private float xRot;
    private double forwardVelocity;
    private double leftVelocity;
    private double upVelocity;
    private long lastTime;
    private boolean freecamHitResultPicking;
    private boolean cameraLock;
    private boolean eyeLock;
    private boolean gameRendererPicking;
    private boolean moveAlongPath;
    private long pathStartTime;

    private FreeCam() {
        Events.ClientTickStart.add(this::onClientTickStart);
        Events.RenderTickStart.add(this::onRenderTickStart);
        Events.RenderWorldLast.add(this::onRenderWorldLast);
        Events.WorldUnload.add(this::onWorldUnload);
    }

    public boolean isActive() {
        return this.active;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getXRot() {
        return this.xRot;
    }

    public float getYRot() {
        return this.yRot;
    }

    public void toggle() {
        if (this.active) {
            this.disable();
        } else {
            this.enable();
        }
    }

    public void toggleCameraLock() {
        if (this.mc.f_91074_ == null) {
            return;
        }
        if (this.active) {
            this.cameraLock = !this.cameraLock;
            this.mc.f_91074_.f_108618_ = this.cameraLock ? this.playerInput : this.freecamInput;
        }
    }

    public void toggleEyeLock() {
        if (this.active) {
            this.eyeLock = !this.eyeLock;
        }
    }

    public FreeCamPath getPath() {
        return this.path;
    }

    public void enable() {
        if (this.active) {
            return;
        }
        Entity entity = this.mc.m_91288_();
        if (entity == null) {
            return;
        }
        this.active = true;
        this.cameraLock = false;
        this.eyeLock = false;
        this.oldCameraType = this.mc.f_91066_.m_92176_();
        this.playerInput = new KeyboardInput(this.mc.f_91066_);
        this.mc.f_91074_.f_108618_ = this.freecamInput = new Input();
        this.mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        if (this.oldCameraType.m_90612_() != this.mc.f_91066_.m_92176_().m_90612_()) {
            this.mc.f_91063_.m_109106_(this.mc.f_91066_.m_92176_().m_90612_() ? this.mc.m_91288_() : null);
        }
        float frameTime = this.mc.m_91296_();
        Vec3 pos = entity.m_20299_(frameTime);
        this.x = pos.f_82479_;
        this.y = pos.f_82480_;
        this.z = pos.f_82481_;
        this.yRot = entity.m_5675_(frameTime);
        this.xRot = entity.m_5686_(frameTime);
        this.calculateVectors();
        double distance = -2.0;
        this.x += (double)this.forwards.x() * distance;
        this.y += (double)this.forwards.y() * distance;
        this.z += (double)this.forwards.z() * distance;
        this.forwardVelocity = 0.0;
        this.leftVelocity = 0.0;
        this.upVelocity = 0.0;
        this.lastTime = 0L;
    }

    public void disable() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.moveAlongPath = false;
        CameraType cameraType = this.mc.f_91066_.m_92176_();
        this.mc.f_91066_.m_92157_(this.oldCameraType);
        this.mc.f_91074_.f_108618_ = this.playerInput;
        if (cameraType.m_90612_() != this.mc.f_91066_.m_92176_().m_90612_()) {
            this.mc.f_91063_.m_109106_(this.mc.f_91066_.m_92176_().m_90612_() ? this.mc.m_91288_() : null);
        }
        this.oldCameraType = null;
    }

    public boolean onPlayerTurn(double yRot, double xRot) {
        if (this.active && !this.cameraLock) {
            if (!this.eyeLock && !this.moveAlongPath) {
                this.xRot += (float)xRot * 0.15f;
                this.yRot += (float)yRot * 0.15f;
                this.xRot = Mth.m_14036_((float)this.xRot, (float)-90.0f, (float)90.0f);
                this.calculateVectors();
            }
            return false;
        }
        return !ConfigStore.instance.getConfig().lockInputsConfig.mouseInputDisabled;
    }

    public boolean onRenderCrosshairIsFirstPerson(boolean isFirstPerson) {
        FreeCamConfig config = this.getConfig();
        if (this.active) {
            return !this.cameraLock && !this.eyeLock && config.target;
        }
        return isFirstPerson;
    }

    public boolean onRenderItemInHandIsFirstPerson(CameraType cameraType) {
        FreeCamConfig config = this.getConfig();
        if (this.active && config.renderHands && !this.cameraLock && !this.eyeLock) {
            return true;
        }
        return cameraType.m_90612_();
    }

    private void onRenderTickStart() {
        if (!this.active) {
            return;
        }
        if (this.lastTime == 0L) {
            this.lastTime = System.nanoTime();
            return;
        }
        long currTime = System.nanoTime();
        float frameTime = (float)(currTime - this.lastTime) / 1.0E9f;
        this.lastTime = currTime;
        FreeCamConfig config = this.getConfig();
        if (this.moveAlongPath) {
            FreeCamPath.Entry entry = this.path.interpolate((double)(currTime - this.pathStartTime) / 1000000.0);
            if (entry == null) {
                this.moveAlongPath = false;
            } else {
                this.x = entry.position().f_82479_;
                this.y = entry.position().f_82480_;
                this.z = entry.position().f_82481_;
                this.xRot = (float)entry.xRot();
                this.yRot = (float)entry.yRot();
            }
        } else {
            Input input = this.playerInput;
            float forwardImpulse = (input.f_108568_ ? 1 : 0) + (input.f_108569_ ? -1 : 0);
            float leftImpulse = (input.f_108570_ ? 1 : 0) + (input.f_108571_ ? -1 : 0);
            float upImpulse = (input.f_108572_ ? 1 : 0) + (input.f_108573_ ? -1 : 0);
            double slowdown = Math.pow(config.slowdownFactor, frameTime);
            this.forwardVelocity = this.combineMovement(this.forwardVelocity, forwardImpulse, frameTime, config.acceleration, slowdown);
            this.leftVelocity = this.combineMovement(this.leftVelocity, leftImpulse, frameTime, config.acceleration, slowdown);
            this.upVelocity = this.combineMovement(this.upVelocity, upImpulse, frameTime, config.acceleration, slowdown);
            double dx = (double)this.forwards.x() * this.forwardVelocity + (double)this.left.x() * this.leftVelocity;
            double dy = (double)this.forwards.y() * this.forwardVelocity + this.upVelocity + (double)this.left.y() * this.leftVelocity;
            double dz = (double)this.forwards.z() * this.forwardVelocity + (double)this.left.z() * this.leftVelocity;
            double speed = new Vec3(dx *= (double)frameTime, dy *= (double)frameTime, dz *= (double)frameTime).m_82553_() / (double)frameTime;
            if (speed > config.maxSpeed) {
                double factor = config.maxSpeed / speed;
                this.forwardVelocity *= factor;
                this.leftVelocity *= factor;
                this.upVelocity *= factor;
                dx *= factor;
                dy *= factor;
                dz *= factor;
            }
            this.x += dx;
            this.y += dy;
            this.z += dz;
        }
        this.applyEyeLock();
    }

    private void onClientTickStart() {
        if (this.active) {
            while (this.mc.f_91066_.f_92103_.m_90859_()) {
            }
            this.playerInput.m_214106_(false, 0.0f);
        }
    }

    private void onWorldUnload() {
        this.disable();
    }

    private void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!this.active || this.moveAlongPath) {
            return;
        }
        List<FreeCamPath.Entry> path = this.getPath().get();
        if (path.size() < 2) {
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Vec3 view = event.getCamera().m_90583_();
        for (int i = 1; i < path.size(); ++i) {
            FreeCamPath.Entry e1 = path.get(i - 1);
            FreeCamPath.Entry e2 = path.get(i);
            bufferBuilder.m_5483_(e1.position().f_82479_ - view.f_82479_, e1.position().f_82480_ - view.f_82480_, e1.position().f_82481_ - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_(e2.position().f_82479_ - view.f_82479_, e2.position().f_82480_ - view.f_82480_, e2.position().f_82481_ - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
        }
        Primitives.renderLines(bufferBuilder, event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix());
    }

    public void startPath() {
        if (!this.active) {
            return;
        }
        this.moveAlongPath = true;
        this.pathStartTime = System.nanoTime();
    }

    public boolean shouldOverrideCameraEntityPosition(Entity entity) {
        FreeCamConfig config = this.getConfig();
        if (this.active && !this.cameraLock && !this.eyeLock && config.target) {
            return entity == this.mc.m_91288_() && this.gameRendererPicking || this.freecamHitResultPicking;
        }
        return false;
    }

    public void onRenderDebugScreenLeft(List<String> list) {
        if (this.active) {
            list.add("");
            String coordinates = String.format(Locale.ROOT, "Free Cam XYZ: %.3f / %.5f / %.3f", this.x, this.y, this.z);
            list.add(coordinates);
        }
    }

    public HitResult getHitResult() {
        if (!this.active || this.mc.f_91074_ == null) {
            return null;
        }
        if (this.cameraLock || this.eyeLock) {
            return null;
        }
        if (!this.getConfig().target) {
            return null;
        }
        this.freecamHitResultPicking = true;
        try {
            HitResult hitResult = this.mc.f_91074_.m_19907_(20.0, 0.0f, false);
            return hitResult;
        }
        finally {
            this.freecamHitResultPicking = false;
        }
    }

    public void onDebugScreenGetSystemInformation(List<String> list) {
        HitResult hit = this.getHitResult();
        if (hit == null) {
            return;
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hit).m_82425_();
            BlockState state = this.mc.f_91073_.m_8055_(pos);
            list.add("");
            list.add(String.valueOf(ChatFormatting.UNDERLINE) + "Free Cam Targeted Block: " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_());
            list.add(String.valueOf(Registries.BLOCKS.getKey(state.m_60734_())));
            for (Map.Entry entry : state.m_61148_().entrySet()) {
                list.add(this.getPropertyValueString(entry));
            }
            state.m_204343_().map(tag -> "#" + String.valueOf(tag.f_203868_())).forEach(list::add);
        }
    }

    public void onBeforeGameRendererPick() {
        this.gameRendererPicking = true;
    }

    public void onAfterGameRendererPick() {
        this.gameRendererPicking = false;
    }

    private void applyEyeLock() {
        if (!this.eyeLock) {
            return;
        }
        Entity entity = this.mc.m_91288_();
        if (entity == null) {
            return;
        }
        float partialTicks = 1.0f;
        Vec3 pos = entity.m_20299_(partialTicks);
        double dx = this.x - pos.f_82479_;
        double dy = this.y - pos.f_82480_;
        double dz = this.z - pos.f_82481_;
        this.xRot = (float)(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) / Math.PI * 180.0);
        this.yRot = (float)(Math.atan2(dz, dx) / Math.PI * 180.0 + 90.0);
        this.xRot = Mth.m_14036_((float)this.xRot, (float)-90.0f, (float)90.0f);
        this.calculateVectors();
    }

    private void calculateVectors() {
        this.rotation.rotationYXZ(-this.yRot * ((float)Math.PI / 180), this.xRot * ((float)Math.PI / 180), 0.0f);
        this.forwards.set(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.rotation);
        this.up.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.rotation);
        this.left.set(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.rotation);
    }

    private double combineMovement(double velocity, double impulse, double frameTime, double acceleration, double slowdown) {
        if (impulse != 0.0) {
            if (impulse > 0.0 && velocity < 0.0) {
                velocity = 0.0;
            }
            if (impulse < 0.0 && velocity > 0.0) {
                velocity = 0.0;
            }
            velocity += acceleration * impulse * frameTime;
        } else {
            velocity *= slowdown;
        }
        return velocity;
    }

    private String getPropertyValueString(Map.Entry<Property<?>, Comparable<?>> p_94072_) {
        Property<?> property = p_94072_.getKey();
        Comparable<?> comparable = p_94072_.getValue();
        Object s = Util.m_137453_(property, comparable);
        if (Boolean.TRUE.equals(comparable)) {
            s = String.valueOf(ChatFormatting.GREEN) + (String)s;
        } else if (Boolean.FALSE.equals(comparable)) {
            s = String.valueOf(ChatFormatting.RED) + (String)s;
        }
        return property.m_61708_() + ": " + (String)s;
    }

    private FreeCamConfig getConfig() {
        return ConfigStore.instance.getConfig().freeCamConfig;
    }
}

