/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.esp;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.Config;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.controllers.ChunkController;
import com.zergatul.cheatutils.utils.Dimension;
import com.zergatul.cheatutils.utils.SharedVertexBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class EndCityChunks {
    public static final EndCityChunks instance = new EndCityChunks();
    private final Minecraft mc = Minecraft.m_91087_();

    private EndCityChunks() {
        Events.RenderWorldLast.add(this::render);
    }

    private void render(RenderWorldLastEvent event) {
        Config config = ConfigStore.instance.getConfig();
        if (!config.esp || !config.endCityChunksConfig.enabled) {
            return;
        }
        if (this.mc.f_91074_ == null) {
            return;
        }
        if (this.mc.f_91074_.m_9236_().m_46472_() != Level.f_46430_) {
            return;
        }
        Vec3 view = event.getCamera().m_90583_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (Pair<Dimension, LevelChunk> pair : ChunkController.instance.getLoadedChunks()) {
            LevelChunk chunk = (LevelChunk)pair.getSecond();
            int sx = Math.floorMod(chunk.m_7697_().f_45578_, 20);
            int sz = Math.floorMod(chunk.m_7697_().f_45579_, 20);
            boolean isEndCityChunk = 0 <= sx && sx <= 8 && 0 <= sz && sz <= 8;
            if (!isEndCityChunk) continue;
            int x1 = chunk.m_7697_().f_45578_ * 16;
            int z1 = chunk.m_7697_().f_45579_ * 16;
            int x2 = x1 + 16;
            int z2 = z1 + 16;
            float r = sx == 4 || sz == 4 ? 1.0f : 0.0f;
            float g = 1.0f;
            float b = 0.0f;
            for (float y = 32.1f; y < 100.0f; y += 32.0f) {
                bufferBuilder.m_5483_((double)x1 - view.f_82479_, (double)y - view.f_82480_, (double)z1 - view.f_82481_).m_85950_(r, g, b, 0.1f).m_5752_();
                bufferBuilder.m_5483_((double)x1 - view.f_82479_, (double)y - view.f_82480_, (double)z2 - view.f_82481_).m_85950_(r, g, b, 0.1f).m_5752_();
                bufferBuilder.m_5483_((double)x2 - view.f_82479_, (double)y - view.f_82480_, (double)z2 - view.f_82481_).m_85950_(r, g, b, 0.1f).m_5752_();
                bufferBuilder.m_5483_((double)x2 - view.f_82479_, (double)y - view.f_82480_, (double)z1 - view.f_82481_).m_85950_(r, g, b, 0.1f).m_5752_();
            }
        }
        SharedVertexBuffer.instance.m_85921_();
        SharedVertexBuffer.instance.m_231221_(bufferBuilder.m_231175_());
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        SharedVertexBuffer.instance.m_253207_(event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }
}

