/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.automation;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import com.zergatul.cheatutils.mixins.common.accessors.MultiPlayerGameModeAccessor;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.utils.BlockUtils;
import com.zergatul.cheatutils.utils.EntityInteraction;
import com.zergatul.cheatutils.wrappers.PickRange;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.shapes.CollisionContext;

public class VillagerRoller
implements Module {
    public static final VillagerRoller instance = new VillagerRoller();
    private final Minecraft mc = Minecraft.m_91087_();
    private boolean active;
    private State state = State.STOPPED;
    private volatile BlockPos pos;
    private volatile boolean lecternPlaced;
    private volatile boolean lecternDestroyed;
    private volatile MerchantOffers offers;
    private int villagerId;
    private int slot;
    private String stopReason;
    private String enchantmentId;
    private String enchantmentName;
    private int level;
    private int price;
    private boolean curse;
    private int maxLevel;
    private int minPrice;
    private int maxPrice;
    private Runnable script;

    private VillagerRoller() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
        Events.ScannerBlockUpdated.add(this::onBlockChanged);
        Events.EntityInteract.add(this::onEntityInteract);
        Events.ClientPlayerLoggingOut.add(this::onPlayerLoggingOut);
        NetworkPacketsController.instance.addServerPacketHandler(this::onServerPacket);
    }

    public boolean isActive() {
        return this.active;
    }

    public void start() {
        if (!this.active) {
            this.active = true;
            this.state = State.SETUP_WAITING_FOR_LECTERN_PLACE;
            this.pos = null;
            this.lecternPlaced = false;
            this.lecternDestroyed = false;
            this.offers = null;
            this.stopReason = null;
        }
    }

    public void stop() {
        this.stop("Requested by user");
    }

    public void toggle() {
        if (this.active) {
            this.stop();
        } else {
            this.start();
        }
    }

    public String getStopReason() {
        return this.stopReason;
    }

    public void resetStopReason() {
        this.stopReason = null;
    }

    public String getState() {
        return this.state.toString();
    }

    public void setScript(Runnable script) {
        this.script = script;
    }

    public boolean isBreakingBlock() {
        return this.active && this.state == State.BREAKING_LECTERN_PROGRESS;
    }

    public String getEnchantmentId() {
        return this.enchantmentId;
    }

    public String getEnchantmentName() {
        return this.enchantmentName;
    }

    public int getLevel() {
        return this.level;
    }

    public int getPrice() {
        return this.price;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getMinPrice() {
        return this.minPrice;
    }

    public int getMaxPrice() {
        return this.maxPrice;
    }

    public boolean isCurse() {
        return this.curse;
    }

    private void onClientTickEnd() {
        if (!this.active) {
            return;
        }
        if (this.mc.f_91073_ == null) {
            return;
        }
        if (this.mc.f_91074_ == null) {
            return;
        }
        if (this.mc.f_91072_ == null) {
            return;
        }
        while (true) {
            switch (this.state) {
                case STOPPED: 
                case SETUP_WAITING_FOR_VILLAGER_INTERACT: {
                    return;
                }
                case SETUP_WAITING_FOR_LECTERN_PLACE: {
                    if (this.lecternPlaced) {
                        this.lecternPlaced = false;
                        this.state = State.SETUP_WAITING_FOR_VILLAGER_INTERACT;
                    }
                    return;
                }
                case SETUP_WAITING_FOR_LECTERN_BREAK: {
                    if (this.lecternDestroyed) {
                        this.lecternDestroyed = false;
                        this.slot = this.mc.f_91074_.m_150109_().f_35977_;
                        this.state = State.WAITING_FOR_PROFESSION_LOSE;
                    }
                    return;
                }
                case WAITING_FOR_PROFESSION_LOSE: {
                    Villager villager;
                    this.mc.f_91072_.m_105276_();
                    Entity entity = this.mc.f_91073_.m_6815_(this.villagerId);
                    if (entity == null) {
                        this.stop("Selected villager no longer exists");
                        return;
                    }
                    if (entity instanceof Villager) {
                        villager = (Villager)entity;
                        if (villager.m_7141_().m_35571_() == VillagerProfession.f_35585_) {
                            this.state = State.PLACING_LECTERN;
                            break;
                        }
                        return;
                    }
                    this.stop("Selected villager is not a villager anymore. LOL");
                    return;
                }
                case PLACING_LECTERN: {
                    Inventory inventory = this.mc.f_91074_.m_150109_();
                    int lecternSlot = -1;
                    for (int i = 0; i < 9; ++i) {
                        if (!inventory.m_8020_(i).m_150930_(Items.f_42774_)) continue;
                        lecternSlot = i;
                        break;
                    }
                    if (lecternSlot >= 0) {
                        double reachDistance = PickRange.get();
                        if (this.pos.m_203193_((Position)this.mc.f_91074_.m_146892_()) > reachDistance * reachDistance) {
                            return;
                        }
                        if (!this.mc.f_91073_.m_8055_(this.pos).m_247087_()) {
                            return;
                        }
                        CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this.mc.f_91074_);
                        if (!this.mc.f_91073_.m_45752_(Blocks.f_50624_.m_49966_(), this.pos, collisioncontext)) {
                            return;
                        }
                        inventory.f_35977_ = lecternSlot;
                        BlockUtils.PlaceBlockPlan plan = new BlockUtils.PlaceBlockPlan(this.pos.m_121945_(Direction.DOWN).m_7949_(), Direction.DOWN, this.pos);
                        BlockUtils.applyPlacingPlan(plan, false);
                        this.state = State.WAITING_FOR_LECTERN_BLOCK_UPDATE;
                    }
                    return;
                }
                case WAITING_FOR_LECTERN_BLOCK_UPDATE: {
                    if (this.lecternPlaced) {
                        this.lecternPlaced = false;
                        this.state = State.WAITING_FOR_PROFESSION_GAIN;
                    }
                    return;
                }
                case WAITING_FOR_PROFESSION_GAIN: {
                    Villager villager;
                    Entity entity = this.mc.f_91073_.m_6815_(this.villagerId);
                    if (entity == null) {
                        this.stop("Selected villager no longer exists");
                        return;
                    }
                    if (entity instanceof Villager) {
                        villager = (Villager)entity;
                        if (villager.m_7141_().m_35571_() == VillagerProfession.f_35594_) {
                            EntityInteraction.interact((Entity)villager);
                            this.offers = null;
                            this.state = State.WAITING_FOR_TRADE_MENU;
                        }
                    } else {
                        this.stop("Selected villager is not a villager anymore. LOL");
                    }
                    return;
                }
                case WAITING_FOR_TRADE_MENU: {
                    if (this.offers == null) {
                        return;
                    }
                    MerchantOffer offer = this.offers.stream().filter(o -> o.m_45368_().m_150930_(Items.f_42690_)).findFirst().orElse(null);
                    this.offers = null;
                    if (offer == null) {
                        this.state = State.START_BREAKING_LECTERN;
                        break;
                    }
                    ListTag list = EnchantedBookItem.m_41163_((ItemStack)offer.m_45368_());
                    if (list.size() == 0) {
                        this.stop("EnchantedBook with 0 enchantments");
                        return;
                    }
                    CompoundTag tag = list.m_128728_(0);
                    ResourceLocation id = EnchantmentHelper.m_182446_((CompoundTag)tag);
                    Enchantment enchantment = Registries.ENCHANTMENTS.getValue(id);
                    if (id != null && enchantment != null) {
                        this.enchantmentId = id.toString();
                        this.enchantmentName = Language.m_128107_().m_6834_(enchantment.m_44704_());
                        this.level = EnchantmentHelper.m_182438_((CompoundTag)tag);
                        this.price = offer.m_45352_().m_41613_();
                        this.maxLevel = enchantment.m_6586_();
                        this.curse = enchantment.m_6589_();
                        this.minPrice = 2 + this.level * 3;
                        this.maxPrice = 6 + this.level * 13;
                        if (enchantment.m_6591_()) {
                            this.minPrice *= 2;
                            this.maxPrice *= 2;
                        }
                        this.minPrice = Math.min(this.minPrice, 64);
                        this.maxPrice = Math.min(this.maxPrice, 64);
                        Runnable script = this.script;
                        if (script != null) {
                            script.run();
                        }
                        if (!this.active) {
                            return;
                        }
                    }
                    this.state = State.START_BREAKING_LECTERN;
                    break;
                }
                case START_BREAKING_LECTERN: {
                    if (this.mc.f_91073_.m_8055_(this.pos).m_60713_(Blocks.f_50624_)) {
                        this.mc.f_91074_.m_150109_().f_35977_ = this.slot;
                        if (this.mc.f_91072_.m_105269_(this.pos, Direction.UP)) {
                            this.state = State.BREAKING_LECTERN_PROGRESS;
                        }
                    }
                    return;
                }
                case BREAKING_LECTERN_PROGRESS: {
                    MultiPlayerGameModeAccessor mode = (MultiPlayerGameModeAccessor)this.mc.f_91072_;
                    if (mode.getIsDestroying_CU() && mode.getDestroyBlockPos_CU().equals((Object)this.pos) && mode.getDestroyProgress_CU() < 1.0f) {
                        this.mc.f_91072_.m_105283_(this.pos, Direction.UP);
                    } else {
                        this.mc.f_91072_.m_105276_();
                        this.state = State.WAITING_FOR_LECTERN_BREAK;
                    }
                    return;
                }
                case WAITING_FOR_LECTERN_BREAK: {
                    if (this.lecternDestroyed) {
                        this.lecternDestroyed = false;
                        this.state = State.WAITING_FOR_PROFESSION_LOSE;
                    }
                    return;
                }
            }
        }
    }

    private void onServerPacket(NetworkPacketsController.ServerPacketArgs args) {
        ClientboundOpenScreenPacket packet;
        if (!this.active) {
            return;
        }
        Packet<?> packet2 = args.packet;
        if (packet2 instanceof ClientboundOpenScreenPacket && (packet = (ClientboundOpenScreenPacket)packet2).m_132628_() == MenuType.f_39975_) {
            args.skip = true;
        }
        if ((packet2 = args.packet) instanceof ClientboundMerchantOffersPacket) {
            packet = (ClientboundMerchantOffersPacket)packet2;
            args.skip = true;
            this.offers = packet.m_132471_();
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClosePacket(packet.m_132468_()));
        }
    }

    private void onBlockChanged(BlockUpdateEvent event) {
        if (this.active) {
            if (this.state == State.SETUP_WAITING_FOR_LECTERN_PLACE && event.state().m_60734_() == Blocks.f_50624_) {
                this.pos = event.pos();
                this.lecternPlaced = true;
                return;
            }
            if (event.pos().equals((Object)this.pos)) {
                if (event.state().m_60795_()) {
                    this.lecternDestroyed = true;
                }
                if (event.state().m_60734_() == Blocks.f_50624_) {
                    this.lecternPlaced = true;
                }
            }
        }
    }

    private void onEntityInteract(Entity entity) {
        if (this.active && this.state == State.SETUP_WAITING_FOR_VILLAGER_INTERACT && entity instanceof Villager) {
            this.villagerId = entity.m_19879_();
            this.state = State.SETUP_WAITING_FOR_LECTERN_BREAK;
        }
    }

    private void onPlayerLoggingOut() {
        this.stop("Logout");
    }

    private void stop(String reason) {
        if (this.active) {
            this.stopReason = reason;
            this.state = State.STOPPED;
            this.active = false;
        }
    }

    private static enum State {
        STOPPED,
        SETUP_WAITING_FOR_LECTERN_PLACE,
        SETUP_WAITING_FOR_VILLAGER_INTERACT,
        SETUP_WAITING_FOR_LECTERN_BREAK,
        WAITING_FOR_PROFESSION_LOSE,
        PLACING_LECTERN,
        WAITING_FOR_LECTERN_BLOCK_UPDATE,
        WAITING_FOR_PROFESSION_GAIN,
        WAITING_FOR_TRADE_MENU,
        START_BREAKING_LECTERN,
        BREAKING_LECTERN_PROGRESS,
        WAITING_FOR_LECTERN_BREAK;

    }
}

