/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.automation;

import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.configs.AutoCraftConfig;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.mixins.common.accessors.CraftingScreenAccessor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoCraft {
    public static final AutoCraft instance = new AutoCraft();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Logger logger = LogManager.getLogger(AutoCraft.class);
    private State state = State.NONE;

    private AutoCraft() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
    }

    private void onClientTickEnd() {
        if (this.mc.f_91074_ == null || this.mc.f_91073_ == null) {
            this.state = State.NONE;
            return;
        }
        AutoCraftConfig config = ConfigStore.instance.getConfig().autoCraftConfig;
        if (!config.enabled || config.items.length == 0) {
            this.state = State.NONE;
            return;
        }
        Screen screen = this.mc.f_91080_;
        if (!(screen instanceof CraftingScreen)) {
            this.state = State.NONE;
            return;
        }
        CraftingScreen craftingScreen = (CraftingScreen)screen;
        if (this.state == State.NONE) {
            this.state = State.START;
        }
        this.mc.m_91307_().m_6180_("auto-craft");
        try {
            switch (this.state) {
                case START: {
                    Recipe<?> recipe = this.findRecipe(config);
                    if (recipe == null) break;
                    boolean shift = recipe.m_8043_(this.mc.f_91073_.m_9598_()).m_41720_().m_41459_() > 1;
                    this.mc.f_91072_.m_105217_(((CraftingMenu)craftingScreen.m_6262_()).f_38840_, recipe, shift);
                    this.state = State.RECIPE_CLICKED;
                    break;
                }
                case RECIPE_CLICKED: {
                    Slot slot = (Slot)((CraftingMenu)craftingScreen.m_6262_()).f_38839_.get(0);
                    if (!slot.m_6657_()) break;
                    ((CraftingScreenAccessor)craftingScreen).slotClicked_CU(slot, 0, 0, ClickType.QUICK_MOVE);
                    this.state = State.RESULT_CLICKED;
                    break;
                }
                case RESULT_CLICKED: {
                    Slot slot = (Slot)((CraftingMenu)craftingScreen.m_6262_()).f_38839_.get(0);
                    if (slot.m_6657_()) break;
                    this.state = State.START;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            config.enabled = false;
        }
        this.mc.m_91307_().m_7238_();
    }

    private Recipe<?> findRecipe(AutoCraftConfig config) {
        ImmutableList<ItemStack> inventory = new ImmutableList<ItemStack>(this.mc.f_91074_.m_150109_().f_35974_.stream().map(ItemStack::m_41777_).toList());
        List<Recipe> recipes = this.mc.f_91074_.m_108631_().m_90639_().stream().flatMap(c -> c.m_100516_().stream()).filter(r -> r instanceof CraftingRecipe).toList();
        for (Item baseItem : config.items) {
            LinkedList<CraftingTreeEntry> queue = new LinkedList<CraftingTreeEntry>();
            for (Recipe recipe : recipes) {
                if (!recipe.m_8043_(this.mc.f_91073_.m_9598_()).m_150930_(baseItem)) continue;
                queue.add(new CraftingTreeEntry(recipe, null));
            }
            while (queue.size() > 0) {
                CraftingTreeEntry entry = (CraftingTreeEntry)queue.poll();
                List<Item> missing = this.getMissingIngredients(entry, inventory);
                if (missing.size() == 0) {
                    return entry.recipe;
                }
                for (Item item : missing) {
                    block4: for (Recipe recipe : recipes) {
                        if (!recipe.m_8043_(this.mc.f_91073_.m_9598_()).m_150930_(item) || entry.has(recipe)) continue;
                        for (Ingredient ingredient : recipe.m_7527_()) {
                            for (ItemStack itemStack : ingredient.m_43908_()) {
                                if (entry.has(itemStack.m_41720_())) continue block4;
                            }
                        }
                        queue.add(new CraftingTreeEntry(recipe, entry));
                    }
                }
            }
        }
        return null;
    }

    private List<Item> getMissingIngredients(CraftingTreeEntry entry, ImmutableList<ItemStack> inventory) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (Ingredient ingredient : entry.recipe.m_7527_()) {
            boolean has = false;
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack itemStack = inventory.get(i);
                if (!ingredient.test(itemStack)) continue;
                ItemStack newItemStack = itemStack.m_41777_();
                newItemStack.m_41764_(itemStack.m_41613_() - 1);
                inventory = inventory.set(i, newItemStack);
                has = true;
                break;
            }
            if (has) continue;
            for (ItemStack itemStack : ingredient.m_43908_()) {
                Item item = itemStack.m_41720_();
                if (list.contains(item)) continue;
                list.add(item);
            }
        }
        return list;
    }

    private static enum State {
        NONE,
        START,
        RECIPE_CLICKED,
        RESULT_CLICKED,
        INVALID;

    }

    private record CraftingTreeEntry(Recipe<?> recipe, CraftingTreeEntry parent) {
        public boolean has(Recipe<?> recipe) {
            CraftingTreeEntry current = this;
            while (current != null) {
                if (current.recipe == recipe) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }

        public boolean has(Item item) {
            CraftingTreeEntry current = this;
            while (current != null) {
                if (current.recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_150930_(item)) {
                    return true;
                }
                current = current.parent;
            }
            return false;
        }
    }
}

