/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.automation;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.configs.AutoBucketConfig;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.utils.BlockUtils;
import com.zergatul.cheatutils.utils.Rotation;
import com.zergatul.cheatutils.utils.RotationUtils;
import com.zergatul.cheatutils.utils.VoxelShapeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AutoBucket
implements Module {
    public static final AutoBucket instance = new AutoBucket();
    private final Minecraft mc = Minecraft.m_91087_();
    private volatile boolean waterPlaced;
    private volatile long waterPlacedTime;
    private volatile BlockPos apprWaterPlacedPos;
    private volatile BlockPos realWaterPlacedPos;

    private AutoBucket() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
        Events.ScannerBlockUpdated.add(this::onBlockUpdated);
    }

    private void onClientTickEnd() {
        if (this.mc.f_91074_ == null || this.mc.f_91073_ == null) {
            return;
        }
        AutoBucketConfig config = ConfigStore.instance.getConfig().autoBucketConfig;
        if (!config.enabled) {
            return;
        }
        if (ConfigStore.instance.getConfig().flyHackConfig.enabled) {
            return;
        }
        if (this.mc.f_91074_.m_21255_()) {
            return;
        }
        Vec3 speed = this.mc.f_91074_.m_20184_();
        if (speed.f_82480_ > -config.speedThreshold / 20.0) {
            if (this.realWaterPlacedPos != null) {
                if (System.nanoTime() - this.waterPlacedTime < 4000000000L) {
                    Vec3 blockCenter = new Vec3((double)this.realWaterPlacedPos.m_123341_() + 0.5, (double)this.realWaterPlacedPos.m_123342_() + 0.5, (double)this.realWaterPlacedPos.m_123343_() + 0.5);
                    double d2 = this.mc.f_91074_.m_20318_(1.0f).m_82557_(blockCenter);
                    if (d2 < config.reachDistance * config.reachDistance) {
                        Rotation rotation = RotationUtils.getRotation(this.mc.f_91074_.m_146892_(), blockCenter);
                        float oldXRot = this.mc.f_91074_.m_146909_();
                        float oldYRot = this.mc.f_91074_.m_146908_();
                        this.mc.f_91074_.m_146926_(rotation.xRot());
                        this.mc.f_91074_.m_146922_(rotation.yRot());
                        this.mc.f_91072_.m_233721_((Player)this.mc.f_91074_, InteractionHand.MAIN_HAND);
                        this.mc.f_91074_.m_146926_(oldXRot);
                        this.mc.f_91074_.m_146922_(oldYRot);
                    }
                }
                this.realWaterPlacedPos = null;
            }
            return;
        }
        int stepsPerTick = 10;
        int ticks = 4;
        int steps = ticks * stepsPerTick;
        double multiplier = 1.0 / (double)stepsPerTick;
        Vec3 speedPerStep = speed.m_82542_(multiplier, multiplier, multiplier);
        double hw = this.mc.f_91074_.m_20205_() / 2.0f;
        double px = this.mc.f_91074_.m_20185_();
        double px1 = px - hw;
        double px2 = px + hw;
        double py = this.mc.f_91074_.m_20186_() - 0.2;
        double pz = this.mc.f_91074_.m_20189_();
        double pz1 = pz - hw;
        double pz2 = pz + hw;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<Long> covered = new ArrayList<Long>();
        BlockPos collisionPos = null;
        EntityDimensions dimensions = this.mc.f_91074_.m_6972_(this.mc.f_91074_.m_20089_());
        block0: for (int i = 0; i < steps; ++i) {
            BlockPos[] positions;
            px += speedPerStep.f_82479_;
            pz += speedPerStep.f_82481_;
            int bx1 = Mth.m_14107_((double)((px1 += speedPerStep.f_82479_) + 1.0E-4));
            int bx2 = Mth.m_14107_((double)((px2 += speedPerStep.f_82479_) - 1.0E-4));
            int by = Mth.m_14107_((double)(py += speedPerStep.f_82480_));
            int bz1 = Mth.m_14107_((double)((pz1 += speedPerStep.f_82481_) + 1.0E-4));
            int bz2 = Mth.m_14107_((double)((pz2 += speedPerStep.f_82481_) - 1.0E-4));
            for (BlockPos pos : positions = new BlockPos[]{new BlockPos(bx1, by, bz1), new BlockPos(bx1, by, bz2), new BlockPos(bx2, by, bz2), new BlockPos(bx2, by, bz1)}) {
                if (checked.contains(pos)) continue;
                checked.add(pos);
                long coveredXZ = this.toLong(pos);
                if (covered.contains(coveredXZ)) continue;
                BlockState state = this.mc.f_91073_.m_8055_(pos);
                if (this.isOkToFallOn(state)) {
                    covered.add(coveredXZ);
                    continue;
                }
                VoxelShape shape = state.m_60812_((BlockGetter)this.mc.f_91073_, pos);
                if (shape.m_83281_() || !VoxelShapeUtils.intersects(pos, shape, dimensions.m_20384_(px, py, pz))) continue;
                collisionPos = pos;
                break block0;
            }
        }
        if (collisionPos == null) {
            return;
        }
        ItemStack stack = this.findItemStackToUse(this.mc.f_91073_, config);
        if (stack == null) {
            return;
        }
        if (stack.m_41720_() instanceof BlockItem) {
            BlockUtils.PlaceBlockPlan plan = BlockUtils.getPlacingPlan(collisionPos.m_7494_(), false);
            if (plan == null) {
                return;
            }
            double d2 = plan.destination().m_203193_((Position)this.mc.f_91074_.m_20182_());
            if (d2 < 16.0) {
                BlockUtils.applyPlacingPlan(plan, true);
            }
        } else {
            Vec3 lookAt = new Vec3((double)collisionPos.m_123341_() + 0.5, (double)(collisionPos.m_123342_() + 1), (double)collisionPos.m_123343_() + 0.5);
            Rotation rotation = RotationUtils.getRotation(this.mc.f_91074_.m_146892_(), lookAt);
            float oldXRot = this.mc.f_91074_.m_146909_();
            float oldYRot = this.mc.f_91074_.m_146908_();
            this.mc.f_91074_.m_146926_(rotation.xRot());
            this.mc.f_91074_.m_146922_(rotation.yRot());
            HitResult result = this.mc.f_91074_.m_19907_(config.reachDistance, 1.0f, true);
            if (result instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                if (result.m_6662_() != HitResult.Type.MISS) {
                    this.mc.f_91072_.m_233721_((Player)this.mc.f_91074_, InteractionHand.MAIN_HAND);
                    if (config.autoPickUp) {
                        this.waterPlaced = true;
                        this.waterPlacedTime = System.nanoTime();
                        this.apprWaterPlacedPos = blockHitResult.m_82425_();
                    }
                }
            }
            this.mc.f_91074_.m_146926_(oldXRot);
            this.mc.f_91074_.m_146922_(oldYRot);
        }
    }

    private void onBlockUpdated(BlockUpdateEvent event) {
        if (this.waterPlaced) {
            if (System.nanoTime() - this.waterPlacedTime > 3000000000L) {
                this.waterPlaced = false;
                return;
            }
            if (event.pos().m_123333_((Vec3i)this.apprWaterPlacedPos) > 3) {
                return;
            }
            if (event.state().m_60713_(Blocks.f_49990_) && event.state().m_60819_().m_76170_()) {
                this.waterPlaced = false;
                this.realWaterPlacedPos = event.pos();
                return;
            }
            if (event.state().m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)event.state().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                this.waterPlaced = false;
                this.realWaterPlacedPos = event.pos();
            }
        }
    }

    private ItemStack findItemStackToUse(ClientLevel level, AutoBucketConfig config) {
        int i;
        Inventory inventory = this.mc.f_91074_.m_150109_();
        if (config.useWaterBucket && !level.m_6042_().f_63857_()) {
            for (i = 0; i < 9; ++i) {
                if (inventory.m_8020_(i).m_41720_() != Items.f_42447_) continue;
                inventory.f_35977_ = i;
                return inventory.m_8020_(i);
            }
        }
        if (config.useSlimeBlock) {
            for (i = 0; i < 9; ++i) {
                if (inventory.m_8020_(i).m_41720_() != Items.f_42204_) continue;
                inventory.f_35977_ = i;
                return inventory.m_8020_(i);
            }
        }
        if (config.useCobweb) {
            for (i = 0; i < 9; ++i) {
                if (inventory.m_8020_(i).m_41720_() != Items.f_41863_) continue;
                inventory.f_35977_ = i;
                return inventory.m_8020_(i);
            }
        }
        return null;
    }

    private boolean isOkToFallOn(BlockState state) {
        if (state.m_60734_() == Blocks.f_50374_) {
            return true;
        }
        if (state.m_60734_() == Blocks.f_50033_) {
            return true;
        }
        return state.m_60734_() == Blocks.f_49990_;
    }

    private long toLong(BlockPos pos) {
        return (long)pos.m_123341_() << 32 | (long)pos.m_123343_();
    }
}

