/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.mixins.common;

import com.zergatul.cheatutils.configs.ConfigStore;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SlimeBlock.class})
public abstract class MixinSlimeBlock
extends HalfTransparentBlock {
    public MixinSlimeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(at={@At(value="HEAD")}, method={"fallOn(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;F)V"}, cancellable=true)
    private void onFallOn(Level level, BlockState state, BlockPos pos, Entity entity, float p_154571_, CallbackInfo info) {
        if (this.shouldFallback(entity)) {
            entity.m_142535_(p_154571_, 1.0f, level.m_269111_().m_268989_());
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateEntityAfterFallOn(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;)V"}, cancellable=true)
    private void onUpdateEntityAfterFallOn(BlockGetter p_56406_, Entity entity, CallbackInfo info) {
        if (this.shouldFallback(entity)) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"stepOn(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Entity;)V"}, cancellable=true)
    private void onStepOn(Level level, BlockPos pos, BlockState state, Entity entity, CallbackInfo info) {
        if (this.shouldFallback(entity)) {
            info.cancel();
        }
    }

    public float m_49958_() {
        if (ConfigStore.instance.getConfig().movementHackConfig.disableSlimePhysics) {
            return 0.6f;
        }
        return super.m_49958_();
    }

    private boolean shouldFallback(Entity entity) {
        return entity.m_9236_().f_46443_ && Minecraft.m_91087_().f_91074_ == entity && ConfigStore.instance.getConfig().movementHackConfig.disableSlimePhysics;
    }
}

