/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.mixins.common;

import com.mojang.authlib.GameProfile;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.FlyHackConfig;
import com.zergatul.cheatutils.configs.MovementHackConfig;
import com.zergatul.cheatutils.controllers.PlayerMotionController;
import com.zergatul.cheatutils.helpers.MixinLocalPlayerHelper;
import com.zergatul.cheatutils.modules.hacks.ElytraFly;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class MixinLocalPlayer
extends AbstractClientPlayer {
    private boolean flyHackOverride = false;
    private boolean oldFlying;
    private float oldFlyingSpeed;

    public MixinLocalPlayer(ClientLevel p_234112_, GameProfile p_234113_) {
        super(p_234112_, p_234113_);
    }

    @Inject(at={@At(value="HEAD")}, method={"sendPosition()V"})
    private void onBeforeSendPosition(CallbackInfo info) {
        PlayerMotionController.instance.triggerOnBeforeSendPosition();
    }

    @Inject(at={@At(value="TAIL")}, method={"sendPosition()V"})
    private void onAfterSendPosition(CallbackInfo info) {
        PlayerMotionController.instance.triggerOnAfterSendPosition();
    }

    @Inject(at={@At(value="HEAD")}, method={"aiStep()V"})
    private void onBeforeAiStep(CallbackInfo info) {
        MixinLocalPlayerHelper.insideAiStep = true;
        FlyHackConfig config = ConfigStore.instance.getConfig().flyHackConfig;
        if (config.enabled) {
            LocalPlayer player = (LocalPlayer)this;
            this.oldFlying = player.m_150110_().f_35935_;
            this.oldFlyingSpeed = player.m_150110_().m_35942_();
            player.m_150110_().f_35935_ = true;
            if (config.overrideFlyingSpeed) {
                player.m_150110_().m_35943_(config.flyingSpeed);
            }
            this.flyHackOverride = true;
        }
        ElytraFly.instance.onBeforeAiStep();
    }

    @Inject(at={@At(value="TAIL")}, method={"aiStep()V"})
    private void onAfterAiStep(CallbackInfo info) {
        MixinLocalPlayerHelper.insideAiStep = false;
        if (this.flyHackOverride) {
            LocalPlayer player = (LocalPlayer)this;
            player.m_150110_().f_35935_ = this.oldFlying;
            player.m_150110_().m_35943_(this.oldFlyingSpeed);
            this.flyHackOverride = false;
        }
        ElytraFly.instance.onAfterAiStep();
    }

    @Inject(at={@At(value="HEAD")}, method={"isUsingItem()Z"}, cancellable=true)
    private void onIsUsingItem(CallbackInfoReturnable<Boolean> info) {
        if (MixinLocalPlayerHelper.insideAiStep && ConfigStore.instance.getConfig().movementHackConfig.disableSlowdownOnUseItem) {
            info.setReturnValue((Object)false);
        }
    }

    @ModifyArg(method={"aiStep()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/Input;tick(ZF)V"), index=0)
    private boolean onAiStepInputTick(boolean isMovingSlowly) {
        MovementHackConfig config = ConfigStore.instance.getConfig().movementHackConfig;
        if (config.disableCrouchingSlowdown) {
            return false;
        }
        return isMovingSlowly;
    }

    @ModifyConstant(method={"aiStep()V"}, constant={@Constant(floatValue=3.0f)})
    private float onModifyFlyingHorizontalMultiplier(float value) {
        return ElytraFly.instance.onModifyFlyingHorizontalMultiplier(value);
    }

    public void m_6001_(double dx, double dy, double dz) {
        MovementHackConfig config = ConfigStore.instance.getConfig().movementHackConfig;
        if (config.antiKnockback) {
            return;
        }
        super.m_6001_(dx, dy, dz);
    }

    public void m_5997_(double dx, double dy, double dz) {
        MovementHackConfig config = ConfigStore.instance.getConfig().movementHackConfig;
        if (config.antiPush) {
            return;
        }
        super.m_5997_(dx, dy, dz);
    }

    protected float m_6118_() {
        MovementHackConfig config = ConfigStore.instance.getConfig().movementHackConfig;
        if (config.scaleJumpHeight) {
            return (float)(Math.sqrt(config.jumpHeightFactor) * (double)super.m_6118_());
        }
        return super.m_6118_();
    }

    public void m_6478_(MoverType type, Vec3 delta) {
        delta = ElytraFly.instance.onBeforeMove(type, delta);
        super.m_6478_(type, delta);
    }
}

