/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.mixins.common;

import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ElytraTunnelConfig;
import com.zergatul.cheatutils.configs.EntityTracerConfig;
import com.zergatul.cheatutils.configs.MovementHackConfig;
import com.zergatul.cheatutils.helpers.MixinEntityHelper;
import com.zergatul.cheatutils.modules.esp.FreeCam;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Shadow(aliases={"Lnet/minecraft/world/entity/Entity;calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"})
    protected abstract Vec3 m_20171_(float var1, float var2);

    @Inject(at={@At(value="HEAD")}, method={"getTeamColor()I"}, cancellable=true)
    private void onGetTeamColor(CallbackInfoReturnable<Integer> info) {
        if (!ConfigStore.instance.getConfig().esp) {
            return;
        }
        Entity entity = (Entity)this;
        for (EntityTracerConfig config : ConfigStore.instance.getConfig().entities.configs) {
            if (!config.enabled || !config.isValidEntity(entity) || !config.glow) continue;
            info.setReturnValue((Object)config.glowColor.getRGB());
            info.cancel();
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, cancellable=true)
    private void onGetEyePosition(float p_20300_, CallbackInfoReturnable<Vec3> info) {
        FreeCam freeCam = FreeCam.instance;
        if (freeCam.shouldOverrideCameraEntityPosition((Entity)this)) {
            info.setReturnValue((Object)new Vec3(freeCam.getX(), freeCam.getY(), freeCam.getZ()));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getViewVector(F)Lnet/minecraft/world/phys/Vec3;"}, cancellable=true)
    private void onGetViewVector(float p_20253_, CallbackInfoReturnable<Vec3> info) {
        FreeCam freeCam = FreeCam.instance;
        if (freeCam.shouldOverrideCameraEntityPosition((Entity)this)) {
            info.setReturnValue((Object)this.m_20171_(freeCam.getXRot(), freeCam.getYRot()));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, cancellable=true)
    private void onCollide(Vec3 vec31, CallbackInfoReturnable<Vec3> info) {
        LocalPlayer player;
        Entity entity;
        ElytraTunnelConfig config = ConfigStore.instance.getConfig().elytraTunnelConfig;
        if (config.enabled && (entity = (Entity)this) instanceof LocalPlayer && (player = (LocalPlayer)entity).m_21255_()) {
            Vec3 result = (Vec3)info.getReturnValue();
            AABB aabb = player.m_20191_().m_82369_(result);
            if (aabb.f_82292_ > config.limit) {
                info.setReturnValue((Object)new Vec3(result.f_82479_, result.f_82480_ - (aabb.f_82292_ - config.limit), result.f_82481_));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"moveRelative(FLnet/minecraft/world/phys/Vec3;)V"})
    private void onBeforeMoveRelative(float limit, Vec3 input, CallbackInfo info) {
        Entity entity = (Entity)this;
        if (entity instanceof LocalPlayer) {
            MixinEntityHelper.insideMoveRelativeLocalPlayer = true;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"moveRelative(FLnet/minecraft/world/phys/Vec3;)V"})
    private void onAfterMoveRelative(float limit, Vec3 input, CallbackInfo info) {
        Entity entity = (Entity)this;
        if (entity instanceof LocalPlayer) {
            MixinEntityHelper.insideMoveRelativeLocalPlayer = false;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"getInputVector(Lnet/minecraft/world/phys/Vec3;FF)Lnet/minecraft/world/phys/Vec3;"}, cancellable=true)
    private static void onGetInputVector(Vec3 vec3, float f, float f1, CallbackInfoReturnable<Vec3> info) {
        if (MixinEntityHelper.insideMoveRelativeLocalPlayer) {
            MovementHackConfig config = ConfigStore.instance.getConfig().movementHackConfig;
            if (config.scaleInputVector) {
                Vec3 vec = (Vec3)info.getReturnValue();
                info.setReturnValue((Object)new Vec3(vec.f_82479_ * config.inputVectorFactor, vec.f_82480_, vec.f_82481_ * config.inputVectorFactor));
            }
        }
    }
}

