/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.mixins.common;

import com.zergatul.cheatutils.controllers.EnchantmentScreenController;
import com.zergatul.cheatutils.utils.HumanReadableFormatter;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnchantmentScreen.class})
public abstract class MixinEnchantmentScreen
extends AbstractContainerScreen<EnchantmentMenu> {
    private Button addDataButton;
    private Button scanButton;
    private Button powerButton;
    private Button setLastSeedButton;
    private Button setCurrentSeedButton;
    private Button crackPlayerSeedButton;
    private EditBox threadsEditBox;
    private EditBox lastEnchSeedEditBox;
    private EditBox currEnchSeedEditBox;
    private EditBox playerSeedEditBox;
    private Button findDropsButton;

    private MixinEnchantmentScreen(EnchantmentMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/client/gui/screens/inventory/EnchantmentScreen;init()V"})
    private void onInit(CallbackInfo info) {
        int space = 4;
        int right = this.f_97735_ + this.f_97726_ + space;
        int cursor = this.f_97736_;
        int btnWidth = 100;
        int btnHeight = 20;
    }

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/client/gui/screens/inventory/EnchantmentScreen;containerTick()V"})
    private void onContainerTick(CallbackInfo info) {
        String value;
        EnchantmentScreenController controller = EnchantmentScreenController.instance;
        this.addDataButton.f_93623_ = ((EnchantmentMenu)this.f_97732_).f_39446_[0] != 0;
        this.addDataButton.m_93666_((Component)Component.m_237113_((String)("Add State [" + controller.getDataCount() + "]")));
        boolean bl = this.scanButton.f_93623_ = controller.getDataCount() > 0 && !controller.isFilterInProgress();
        if (controller.isFilterInProgress()) {
            this.scanButton.m_93666_((Component)Component.m_237113_((String)(String.format(Locale.ROOT, "%.3f", 100.0 * controller.getProgress()) + "% [" + HumanReadableFormatter.formatLong(controller.getNewSeedsCount()) + "]")));
        } else {
            this.scanButton.m_93666_((Component)Component.m_237113_((String)("Filter [" + HumanReadableFormatter.formatLong(controller.getSeedsCount()) + "]")));
        }
        this.setLastSeedButton.f_93623_ = controller.getSeedsCount() == 1L;
        this.setCurrentSeedButton.f_93623_ = controller.getSeedsCount() == 1L;
        this.crackPlayerSeedButton.f_93623_ = controller.getLastEnchSeed() != null && controller.getCurrEnchSeed() != null;
        String string = value = controller.getLastEnchSeed() == null ? "" : String.format("%08X", controller.getLastEnchSeed());
        if (!this.lastEnchSeedEditBox.m_94155_().equals(value)) {
            this.lastEnchSeedEditBox.m_94144_(value);
        }
        String string2 = value = controller.getCurrEnchSeed() == null ? "" : String.format("%08X", controller.getCurrEnchSeed());
        if (!this.currEnchSeedEditBox.m_94155_().equals(value)) {
            this.currEnchSeedEditBox.m_94144_(value);
        }
        String string3 = value = controller.getPlayerSeed() == null ? "" : String.format("%12X", controller.getPlayerSeed());
        if (!this.playerSeedEditBox.m_94155_().equals(value)) {
            this.playerSeedEditBox.m_94144_(value);
        }
    }

    private void onResetClick(Button button) {
        EnchantmentScreenController.instance.reset();
    }

    private void onAddDataClick(Button button) {
        Integer enchantPowerBonus = this.getEnchantPowerBonus();
        if (enchantPowerBonus == null) {
            return;
        }
        EnchantmentScreenController.instance.addState(((EnchantmentMenu)this.f_97732_).m_38853_(0).m_7993_(), enchantPowerBonus, ((EnchantmentMenu)this.f_97732_).f_39446_, ((EnchantmentMenu)this.f_97732_).f_39447_, ((EnchantmentMenu)this.f_97732_).f_39448_);
    }

    private void onScanClick(Button button) {
        int threads;
        try {
            threads = Integer.parseInt(this.threadsEditBox.m_94155_());
        }
        catch (Throwable e) {
            threads = 1;
        }
        EnchantmentScreenController.instance.scan(threads);
    }

    private void onSetLastSeedClick(Button button) {
        EnchantmentScreenController.instance.setLastEnchSeed();
    }

    private void onSetCurrentSeedClick(Button button) {
        EnchantmentScreenController.instance.setCurrEnchSeed();
    }

    private void onCrackPlayerSeedClick(Button button) {
        EnchantmentScreenController.instance.crackPlayerSeed();
    }

    private void onPowerClick(Button button) {
        button.m_93666_((Component)Component.m_237113_((String)("Power: " + this.getEnchantPowerBonus())));
    }

    private void onFindDropsClick(Button button) {
        EnchantmentScreenController.instance.findDrops();
    }

    private Integer getEnchantPowerBonus() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return null;
        }
        BlockPos playerPos = mc.f_91074_.m_20183_();
        BlockPos pos = null;
        for (int dx = -5; dx <= 5 && pos == null; ++dx) {
            for (int dy = -5; dy <= 5 && pos == null; ++dy) {
                for (int dz = -5; dz <= 5 && pos == null; ++dz) {
                    if (mc.f_91073_.m_8055_(playerPos.m_7918_(dx, dy, dz)).m_60734_() != Blocks.f_50201_) continue;
                    pos = playerPos.m_7918_(dx, dy, dz);
                }
            }
        }
        if (pos == null) {
            return null;
        }
        float enchantPowerBonus = 0.0f;
        for (BlockPos delta : EnchantmentTableBlock.f_207902_) {
            if (!EnchantmentTableBlock.m_207909_((Level)mc.f_91073_, pos, (BlockPos)delta)) continue;
            throw new IllegalStateException("disabled");
        }
        if (enchantPowerBonus > 15.0f) {
            enchantPowerBonus = 15.0f;
        }
        return (int)enchantPowerBonus;
    }
}

