/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.mixins.common;

import com.zergatul.cheatutils.configs.BoatHackConfig;
import com.zergatul.cheatutils.configs.ConfigStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Boat.class})
public abstract class MixinBoat
extends Entity {
    @Shadow
    private float f_38264_;
    @Shadow
    private boolean f_38275_;
    @Shadow
    private boolean f_38273_;
    @Shadow
    private boolean f_38274_;
    @Shadow
    private boolean f_38276_;

    public MixinBoat(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @ModifyArg(method={"Lnet/minecraft/world/entity/vehicle/Boat;floatBoat()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;setDeltaMovement(DDD)V", ordinal=0), index=0)
    private double onFloatBoatSetDeltaMovementX(double dx) {
        BoatHackConfig config = ConfigStore.instance.getConfig().boatHackConfig;
        if (config.overrideFriction) {
            return dx / (double)this.f_38264_ * (double)config.friction;
        }
        return dx;
    }

    @ModifyArg(method={"Lnet/minecraft/world/entity/vehicle/Boat;floatBoat()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;setDeltaMovement(DDD)V", ordinal=0), index=2)
    private double onFloatBoatSetDeltaMovementZ(double dz) {
        BoatHackConfig config = ConfigStore.instance.getConfig().boatHackConfig;
        if (config.overrideFriction) {
            return dz / (double)this.f_38264_ * (double)config.friction;
        }
        return dz;
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/vehicle/Boat;controlBoat()V"})
    private void onControlBoat(CallbackInfo info) {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        BoatHackConfig config = ConfigStore.instance.getConfig().boatHackConfig;
        if (config.fly) {
            this.f_38275_ = false;
            this.f_38273_ = false;
            this.f_38274_ = false;
            this.f_38276_ = false;
        }
    }

    public void m_6478_(MoverType type, Vec3 speed) {
        if (!this.m_9236_().m_5776_()) {
            super.m_6478_(type, speed);
            return;
        }
        BoatHackConfig config = ConfigStore.instance.getConfig().boatHackConfig;
        if (!config.fly) {
            super.m_6478_(type, speed);
            return;
        }
        Boat boat = (Boat)this;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (boat.m_6688_() != player) {
            super.m_6478_(type, speed);
            return;
        }
        boat.m_146922_(player.m_146908_());
        double angle = (double)boat.m_146908_() * Math.PI / 180.0;
        speed = Vec3.f_82478_;
        boolean up = mc.f_91066_.f_92085_.m_90857_();
        boolean down = mc.f_91066_.f_92087_.m_90857_();
        boolean left = mc.f_91066_.f_92086_.m_90857_();
        boolean right = mc.f_91066_.f_92088_.m_90857_();
        if (up && down) {
            up = false;
            down = false;
        }
        if (left && right) {
            left = false;
            right = false;
        }
        if (up || down || left || right) {
            if (up) {
                if (left) {
                    angle -= 0.7853981633974483;
                } else if (right) {
                    angle += 0.7853981633974483;
                }
            } else {
                angle = down ? (left ? (angle -= 2.356194490192345) : (right ? (angle += 2.356194490192345) : (angle += Math.PI))) : (left ? (angle -= 1.5707963267948966) : (angle += 1.5707963267948966));
            }
            speed = new Vec3(-config.horizontalFlySpeed / 20.0 * Math.sin(angle), 0.0, config.horizontalFlySpeed / 20.0 * Math.cos(angle));
        }
        if (mc.f_91066_.f_92089_.m_90857_()) {
            speed = speed.m_82520_(0.0, config.verticalFlySpeed / 20.0, 0.0);
        }
        if (mc.f_91066_.f_92091_.m_90857_()) {
            speed = speed.m_82520_(0.0, -config.verticalFlySpeed / 20.0, 0.0);
        }
        this.m_20256_(speed);
        super.m_6478_(type, speed);
    }
}

