/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.mixins.common;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.ContainerRenderLabelsEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ContainerButtonsConfig;
import com.zergatul.cheatutils.configs.ContainerSummaryConfig;
import com.zergatul.cheatutils.controllers.ContainerButtonsController;
import com.zergatul.cheatutils.controllers.ContainerSummaryController;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class MixinAbstractContainerScreen<T extends AbstractContainerMenu>
extends Screen {
    @Shadow
    protected int f_97736_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97726_;
    @Shadow
    @Final
    protected T f_97732_;

    protected MixinAbstractContainerScreen(Component component) {
        super(component);
    }

    @Inject(at={@At(value="TAIL")}, method={"init()V"})
    private void onInit(CallbackInfo info) {
        int btnHeight;
        int btnWidth;
        MixinAbstractContainerScreen self = this;
        if (!ContainerButtonsController.instance.isValidScreen(self)) {
            return;
        }
        ContainerButtonsConfig config = ConfigStore.instance.getConfig().containerButtonsConfig;
        int cursor = this.f_97735_ + this.f_97726_;
        int space = 4;
        if (config.showTakeAll) {
            btnWidth = 72;
            btnHeight = 20;
            this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"button.take.all"), this::onTakeAllPress).m_252987_(cursor -= btnWidth, this.f_97736_ - btnHeight, btnWidth, btnHeight).m_253136_());
            cursor -= space;
        }
        if (config.showSmartPut) {
            btnWidth = 72;
            btnHeight = 20;
            this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"button.smart.put"), this::onSmartPutPress).m_252987_(cursor -= btnWidth, this.f_97736_ - btnHeight, btnWidth, btnHeight).m_253136_());
            cursor -= space;
        }
        if (config.showDropAll) {
            btnWidth = 72;
            btnHeight = 20;
            this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"button.drop.all"), this::onDropAllPress).m_252987_(cursor -= btnWidth, this.f_97736_ - btnHeight, btnWidth, btnHeight).m_253136_());
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void onRender(GuiGraphics graphics, int slotIndex, int k, float l1, CallbackInfo info) {
        MixinAbstractContainerScreen screen;
        ContainerSummaryConfig config = ConfigStore.instance.getConfig().containerSummaryConfig;
        if (!config.enabled) {
            return;
        }
        NonNullList slots = ((AbstractContainerMenu)this.f_97732_).f_38839_;
        if (slots.size() == 0) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Container container = ((Slot)slots.get((int)0)).f_40218_;
        if (container instanceof SimpleContainer) {
            SimpleContainer container2 = (SimpleContainer)container;
            for (int i = 0; i < container2.m_6643_(); ++i) {
                ItemStack itemStack = container2.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                items.add(itemStack);
            }
        } else if (config.showForInventory && (screen = this) instanceof InventoryScreen) {
            InventoryScreen inventory = (InventoryScreen)screen;
            for (Slot slot : slots) {
                if (slot.f_40218_ instanceof ResultContainer) continue;
                items.add(slot.m_7993_());
            }
        }
        if (items.size() == 0) {
            return;
        }
        List<ContainerSummaryController.ItemDrawable> list = ContainerSummaryController.instance.groupItems(items);
        RenderSystem.enableDepthTest();
        boolean group = !Screen.m_96639_();
        list.forEach(d -> d.initDraw(this.f_96547_, group));
        List<ContainerSummaryController.ItemsColumn> columns = ContainerSummaryController.instance.split(list);
        columns.forEach(ContainerSummaryController.ItemsColumn::calculateWidth);
        int cursor = this.f_97735_ + this.f_97726_ + 2;
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        for (ContainerSummaryController.ItemsColumn column : columns) {
            cursor += column.draw(graphics, this.f_96547_, renderer, this.f_96541_.f_91074_, cursor, this.f_97736_);
        }
    }

    private void onTakeAllPress(Button button) {
        ContainerButtonsController.instance.takeAll(false);
    }

    private void onSmartPutPress(Button button) {
        ContainerButtonsController.instance.smartPut();
    }

    private void onDropAllPress(Button button) {
        ContainerButtonsController.instance.dropAll(false);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V", shift=At.Shift.AFTER)}, method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"})
    private void onRenderLabels(GuiGraphics graphics, int x, int y, float partialTicks, CallbackInfo info) {
        Events.ContainerRenderLabels.trigger(new ContainerRenderLabelsEvent(graphics, (AbstractContainerScreen)this, x, y));
    }
}

