/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.font;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zergatul.cheatutils.font.Glyph;
import com.zergatul.cheatutils.font.TextBounds;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;

public class GlyphFontRenderer {
    private final Font font;
    private final boolean antiAliasing;
    private final Map<Character, Glyph> glyphs;

    public GlyphFontRenderer(Font font, boolean antiAliasing) {
        this.font = font;
        this.antiAliasing = antiAliasing;
        this.glyphs = new HashMap<Character, Glyph>();
    }

    public TextBounds getTextSize(String string) {
        if (string == null) {
            return new TextBounds(0, 0, 0, 0);
        }
        this.ensureGlyphs(string);
        int width = 0;
        int height = 0;
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MAX_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            Glyph glyph = this.glyphs.get(Character.valueOf(string.charAt(i)));
            width += glyph.getWidth();
            if (glyph.getHeight() > height) {
                height = glyph.getHeight();
            }
            if (glyph.getTop() < top) {
                top = glyph.getTop();
            }
            if (glyph.getBottom() >= bottom) continue;
            bottom = glyph.getBottom();
        }
        return new TextBounds(width, height, top, bottom);
    }

    public void drawText(PoseStack stack, String string, float x, float y, double invScale) {
        if (string == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
        GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
        this.ensureGlyphs(string);
        for (int i = 0; i < string.length(); ++i) {
            Glyph glyph = this.glyphs.get(Character.valueOf(string.charAt(i)));
            glyph.bindTexture();
            float width = (float)((double)glyph.getWidth() * invScale);
            float height = (float)((double)glyph.getHeight() * invScale);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.setShader(GameRenderer::m_172814_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferBuilder.m_252986_(stack.m_85850_().m_252922_(), x, y + height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(stack.m_85850_().m_252922_(), x + width, y + height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(stack.m_85850_().m_252922_(), x + width, y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(stack.m_85850_().m_252922_(), x, y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            x += width;
        }
    }

    public void dispose() {
        for (Glyph glyph : this.glyphs.values()) {
            glyph.dispose();
        }
    }

    private void ensureGlyphs(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (this.glyphs.containsKey(Character.valueOf(ch))) continue;
            this.glyphs.put(Character.valueOf(ch), new Glyph(this.font, ch, this.antiAliasing));
        }
    }
}

