/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.font;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import org.lwjgl.BufferUtils;

public class Glyph {
    private final int width;
    private final int height;
    private final int baseline;
    private final int top;
    private final int bottom;
    private DynamicTexture texture;

    public Glyph(Font font, char ch, boolean antiAliasing) {
        int y;
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affineTransform, antiAliasing, false);
        String charStr = Character.toString(ch);
        Rectangle2D bounds = font.getStringBounds(charStr, frc);
        this.height = Mth.m_14165_((double)bounds.getHeight());
        this.width = Mth.m_14165_((double)bounds.getWidth());
        this.baseline = Mth.m_14165_((double)Math.abs(bounds.getMinY()));
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        Graphics2D g = image.createGraphics();
        g.setFont(font);
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(new Color(255, 255, 255, 255));
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAliasing ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antiAliasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.drawString(charStr, 0, this.baseline);
        g.dispose();
        int shift = -1;
        for (y = 0; y < this.height; ++y) {
            if (!this.hasPixels(image, y)) continue;
            shift = y;
            break;
        }
        if (shift == -1) {
            this.top = this.baseline;
            this.bottom = this.height - this.baseline;
        } else {
            this.top = shift;
            shift = -1;
            for (y = this.height - 1; y >= 0; --y) {
                if (!this.hasPixels(image, y)) continue;
                shift = y;
                break;
            }
            this.bottom = this.height - 1 - shift;
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", stream);
            byte[] bytes = stream.toByteArray();
            ByteBuffer data = BufferUtils.createByteBuffer((int)bytes.length).put(bytes);
            data.flip();
            this.texture = new DynamicTexture(NativeImage.m_85062_((ByteBuffer)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public void bindTexture() {
        RenderSystem.setShaderTexture((int)0, (int)this.texture.m_117963_());
    }

    public void dispose() {
        this.texture.close();
    }

    private boolean hasPixels(BufferedImage image, int y) {
        for (int x = 0; x < this.width; ++x) {
            if ((image.getRGB(x, y) & 0xFF000000) == 0) continue;
            return true;
        }
        return false;
    }
}

