/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.interfaces.LevelChunkMixinInterface;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldScannerController {
    public static WorldScannerController instance = new WorldScannerController();
    private static final long waitTime = 250000000L;
    private final Logger logger = LogManager.getLogger(WorldScannerController.class);
    private final Object loopWaitEvent = new Object();
    private Thread eventLoop;
    private Queue<InterruptibleRunnable> queue = new ConcurrentLinkedQueue<InterruptibleRunnable>();

    private WorldScannerController() {
        Events.SmartChunkLoaded.add(this::onChunkLoaded);
        Events.SmartChunkUnloaded.add(this::onChunkUnLoaded);
        Events.BlockUpdated.add(this::onBlockChanged);
        this.restartBackgroundThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartBackgroundThread() {
        if (this.eventLoop != null) {
            this.queue.clear();
            Object object = this.loopWaitEvent;
            synchronized (object) {
                this.loopWaitEvent.notify();
            }
            this.eventLoop.interrupt();
        }
        this.eventLoop = null;
        this.eventLoop = new Thread(() -> {
            try {
                block6: while (true) {
                    Object object = this.loopWaitEvent;
                    synchronized (object) {
                        this.loopWaitEvent.wait();
                    }
                    while (true) {
                        if (this.queue.size() <= 0) continue block6;
                        InterruptibleRunnable process = this.queue.remove();
                        process.run();
                        Thread.yield();
                    }
                    break;
                }
            }
            catch (InterruptedException process) {
            }
            catch (Throwable e) {
                this.logger.error("WorldScanner thread crash.", e);
            }
        }, "WorldScannerThread");
        this.eventLoop.start();
    }

    private void onChunkLoaded(LevelChunk chunk) {
        LevelChunkMixinInterface mixinChunk = (LevelChunkMixinInterface)chunk;
        mixinChunk.onLoad();
        this.addToQueue(() -> this.processChunkLoad(chunk));
    }

    private void onChunkUnLoaded(LevelChunk chunk) {
        LevelChunkMixinInterface mixinChunk = (LevelChunkMixinInterface)chunk;
        mixinChunk.onUnload();
        this.addToQueue(() -> this.processChunkUnload(chunk));
    }

    private void onBlockChanged(BlockUpdateEvent event) {
        this.addToQueue(() -> this.processBlockChanged(event));
    }

    private void processChunkLoad(LevelChunk chunk) throws InterruptedException {
        this.waitForChunk(chunk, () -> this.addToQueue(() -> this.processChunkLoad(chunk)));
        Events.ScannerChunkLoaded.trigger(chunk);
    }

    private void processChunkUnload(LevelChunk chunk) {
        Events.ScannerChunkUnloaded.trigger(chunk);
    }

    private void processBlockChanged(BlockUpdateEvent event) throws InterruptedException {
        this.waitForChunk(event.chunk(), () -> this.addToQueue(() -> this.processBlockChanged(event)));
        Events.ScannerBlockUpdated.trigger(event);
    }

    private void waitForChunk(LevelChunk chunk, Runnable whenNotFull) throws InterruptedException {
        LevelChunkMixinInterface mixinChunk = (LevelChunkMixinInterface)chunk;
        if (chunk.m_6415_() != ChunkStatus.f_62326_) {
            if (!mixinChunk.isUnloaded()) {
                whenNotFull.run();
            }
            return;
        }
        if (mixinChunk.isUnloaded()) {
            return;
        }
        long delta = System.nanoTime() - mixinChunk.getLoadTime();
        if (delta > 0L && delta < 250000000L) {
            Thread.sleep((250000000L - delta) / 1000000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(InterruptibleRunnable runnable) {
        this.queue.add(runnable);
        Object object = this.loopWaitEvent;
        synchronized (object) {
            this.loopWaitEvent.notify();
        }
    }

    @FunctionalInterface
    private static interface InterruptibleRunnable {
        public void run() throws InterruptedException;
    }
}

