/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.RenderGuiEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.WorldMarkersConfig;
import com.zergatul.cheatutils.font.GlyphFontRenderer;
import com.zergatul.cheatutils.font.TextBounds;
import com.zergatul.cheatutils.render.ColorRender;
import com.zergatul.cheatutils.render.Primitives;
import com.zergatul.cheatutils.utils.ColorUtils;
import java.awt.Font;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;

public class WorldMarkersController {
    public static final WorldMarkersController instance = new WorldMarkersController();
    private final Minecraft mc = Minecraft.m_91087_();
    private GlyphFontRenderer fontRenderer;

    private WorldMarkersController() {
        Events.PreRenderGui.add(this::onPreRenderGui);
    }

    public void onFontChange(WorldMarkersConfig config) {
        RenderSystem.recordRenderCall(() -> {
            if (this.fontRenderer != null) {
                this.fontRenderer.dispose();
            }
            this.fontRenderer = new GlyphFontRenderer(new Font("Consolas", 0, config.fontSize), config.antiAliasing);
        });
    }

    private void onPreRenderGui(RenderGuiEvent event) {
        if (!ConfigStore.instance.getConfig().esp) {
            return;
        }
        WorldMarkersConfig config = ConfigStore.instance.getConfig().worldMarkersConfig;
        if (!config.enabled) {
            return;
        }
        if (this.mc.f_91073_ == null) {
            return;
        }
        Camera camera = event.getCamera();
        Vec3 view = camera.m_90583_();
        double scale = this.mc.m_91268_().m_85449_();
        double invScale = 1.0 / scale;
        double scaledHalfWidth = (double)this.mc.m_91268_().m_85441_() * invScale / 2.0;
        double scaledHalfHeight = (double)this.mc.m_91268_().m_85442_() * invScale / 2.0;
        PoseStack poseStack = event.getGuiGraphics().m_280168_();
        poseStack.m_85836_();
        poseStack.m_85850_().m_252922_().translate((float)scaledHalfWidth, (float)scaledHalfHeight, 0.0f);
        String dimension = this.mc.f_91073_.m_46472_().m_135782_().toString();
        for (WorldMarkersConfig.Entry entry : config.entries) {
            double z;
            double y;
            double x;
            if (!entry.enabled || !dimension.equals(entry.dimension) || (x = entry.x - view.f_82479_) * x + (y = entry.y - view.f_82480_) * y + (z = entry.z - view.f_82481_) * z < entry.minDistance * entry.minDistance) continue;
            Vector4f v1 = event.getWorldPoseMatrix().transform(new Vector4f((float)x, (float)y, (float)z, 1.0f));
            Vector4f v2 = event.getWorldProjectionMatrix().transform(v1);
            if (v2.z <= 0.0f) continue;
            double xc = (double)(v2.x / v2.w) * scaledHalfWidth;
            double yc = (double)(-v2.y / v2.w) * scaledHalfHeight;
            TextBounds bounds = this.fontRenderer.getTextSize(entry.name);
            double width = (double)bounds.width() * invScale;
            double height = (double)bounds.height() * invScale;
            double xp = xc - width / 2.0;
            double yp = yc -= 2.0 * height;
            int color = entry.color.getRGB();
            int inverse = ColorUtils.inverse(color);
            double horizontalPadding = scale;
            double verticalPadding = scale;
            double rx1 = xp - horizontalPadding * invScale;
            double rx2 = xp + width + horizontalPadding * invScale;
            double ry1 = yp + ((double)bounds.top() - verticalPadding) * invScale;
            double ry2 = yp + height - ((double)bounds.bottom() - verticalPadding) * invScale;
            Primitives.fill(poseStack, rx1, ry1, rx2, ry2, inverse & 0x40FFFFFF);
            ColorRender.setShaderColor(color);
            this.fontRenderer.drawText(poseStack, entry.name, (float)xp, (float)yp, invScale);
            double bw = (double)config.borderWidth * invScale;
            Primitives.fill(poseStack, rx1 - bw, ry1 - bw, rx2 + bw, ry1, color);
            Primitives.fill(poseStack, rx1 - bw, ry2, rx2 + bw, ry2 + bw, color);
            Primitives.fill(poseStack, rx1 - bw, ry1 - bw, rx1, ry2 + bw, color);
            Primitives.fill(poseStack, rx2, ry1 - bw, rx2 + bw, ry2 + bw, color);
            Primitives.fill(poseStack, xc - bw / 2.0, ry2, xc + bw / 2.0, ry2 + height, color);
        }
        poseStack.m_85849_();
    }
}

