/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zergatul.cheatutils.chunkoverlays.WorldDownloadChunkOverlay;
import com.zergatul.cheatutils.controllers.ChunkOverlayController;
import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import com.zergatul.cheatutils.utils.Dimension;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldDownloadController {
    public static final WorldDownloadController instance = new WorldDownloadController();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Logger logger = LogManager.getLogger(WorldDownloadController.class);
    private final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.m_238371_((IdMap)Block.f_49791_, (Codec)BlockState.f_61039_, (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188137_, (Object)Blocks.f_50016_.m_49966_());
    private volatile Map<ResourceKey<Level>, ChunkStorage> chunkStorages;
    private LevelStorageSource.LevelStorageAccess access;
    private final Object loopWaitEvent = new Object();
    private volatile boolean stopRequested;
    private volatile Thread thread;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();

    public WorldDownloadController() {
        NetworkPacketsController.instance.addServerPacketHandler(this::onServerPacket);
    }

    public boolean isActive() {
        return this.chunkStorages != null;
    }

    public void start(String name) throws Exception {
        this.stop();
        File file = new File("./saves/" + name + "/level.dat");
        if (!file.exists()) {
            throw new IllegalStateException("World [" + name + "] doesn't exist in [saves] directory.");
        }
        try {
            this.stopRequested = false;
            this.access = this.mc.m_91392_().m_78260_(name);
            this.thread = new Thread(this::threadFunc, "WorldDownloadChunkSaveThread");
            this.thread.start();
            this.chunkStorages = new HashMap<ResourceKey<Level>, ChunkStorage>();
            ChunkOverlayController.instance.ofType(WorldDownloadChunkOverlay.class).onEnabledChanged();
        }
        catch (Throwable e) {
            this.stop();
            throw e;
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.stopRequested = true;
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        this.queue.clear();
        if (this.chunkStorages != null) {
            for (ChunkStorage storage : this.chunkStorages.values()) {
                try {
                    storage.m_63514_();
                    storage.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.mc.f_91074_ != null && this.access != null) {
            PlayerDataStorage playerDataStorage = this.access.m_78301_();
            playerDataStorage.m_78433_((Player)this.mc.f_91074_);
        }
        this.chunkStorages = null;
        this.closeAccess();
        ChunkOverlayController.instance.ofType(WorldDownloadChunkOverlay.class).onEnabledChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadFunc() {
        try {
            while (!this.stopRequested) {
                Object object = this.loopWaitEvent;
                synchronized (object) {
                    this.loopWaitEvent.wait();
                }
                while (this.queue.size() > 0) {
                    this.queue.poll().run();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.stop();
        }
    }

    private void onServerPacket(NetworkPacketsController.ServerPacketArgs args) {
        if (!this.isActive()) {
            return;
        }
        Packet<?> packet = args.packet;
        if (packet instanceof ClientboundLevelChunkWithLightPacket) {
            ClientboundLevelChunkWithLightPacket packet2 = (ClientboundLevelChunkWithLightPacket)packet;
            this.processChunkPacket(packet2.m_195717_(), packet2.m_195718_(), packet2.m_195719_());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunkPacket(int x, int z, ClientboundLevelChunkPacketData packet) {
        this.queue.add(() -> {
            ChunkStorage storage;
            ClientLevel level = this.mc.f_91073_;
            if (level == null) {
                return;
            }
            Map<ResourceKey<Level>, ChunkStorage> storages = this.chunkStorages;
            if (storages == null) {
                return;
            }
            Dimension dimension = Dimension.get(level);
            ResourceKey levelDimension = level.m_46472_();
            if (storages.containsKey(levelDimension)) {
                storage = storages.get(levelDimension);
            } else {
                storage = new ChunkStorage(this.access.m_197394_(levelDimension).resolve("region"), null, true);
                storages.put((ResourceKey<Level>)levelDimension, storage);
            }
            LevelChunk chunk = new LevelChunk((Level)level, new ChunkPos(x, z));
            chunk.m_187971_(packet.m_195656_(), packet.m_195678_(), packet.m_195657_(x, z));
            CompoundTag compoundtag = this.write(this.mc.f_91073_, (ChunkAccess)chunk);
            storage.m_63502_(chunk.m_7697_(), compoundtag);
            ChunkOverlayController.instance.ofType(WorldDownloadChunkOverlay.class).notifyChunkSaved(dimension, x, z);
        });
        Object object = this.loopWaitEvent;
        synchronized (object) {
            this.loopWaitEvent.notify();
        }
    }

    private CompoundTag write(ClientLevel level, ChunkAccess chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128405_("DataVersion", SharedConstants.m_183709_().m_183476_().m_193006_());
        compoundtag.m_128405_("xPos", chunkpos.f_45578_);
        compoundtag.m_128405_("yPos", chunk.m_151560_());
        compoundtag.m_128405_("zPos", chunkpos.f_45579_);
        compoundtag.m_128356_("LastUpdate", level.m_46467_());
        compoundtag.m_128356_("InhabitedTime", chunk.m_6319_());
        compoundtag.m_128359_("Status", BuiltInRegistries.f_256940_.m_7981_((Object)chunk.m_6415_()).toString());
        LevelChunkSection[] alevelchunksection = chunk.m_7103_();
        ListTag listtag = new ListTag();
        LevelLightEngine levellightengine = level.m_7726_().m_7827_();
        Registry registry = level.m_9598_().m_175515_(Registries.f_256952_);
        Codec<PalettedContainerRO<Holder<Biome>>> codec = this.makeBiomeCodec((Registry<Biome>)registry);
        boolean flag = chunk.m_6332_();
        for (int i = levellightengine.m_164447_(); i < levellightengine.m_164448_(); ++i) {
            int j = chunk.m_151566_(i);
            boolean flag1 = j >= 0 && j < alevelchunksection.length;
            DataLayer datalayer = levellightengine.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)i));
            DataLayer datalayer1 = levellightengine.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)i));
            if (!flag1 && datalayer == null && datalayer1 == null) continue;
            CompoundTag compoundtag1 = new CompoundTag();
            if (flag1) {
                LevelChunkSection levelchunksection = alevelchunksection[j];
                compoundtag1.m_128365_("block_states", (Tag)this.BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)levelchunksection.m_63019_()).getOrThrow(false, arg_0 -> ((Logger)this.logger).error(arg_0)));
                compoundtag1.m_128365_("biomes", (Tag)codec.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)levelchunksection.m_187996_()).getOrThrow(false, arg_0 -> ((Logger)this.logger).error(arg_0)));
            }
            if (datalayer != null && !datalayer.m_62575_()) {
                compoundtag1.m_128382_("BlockLight", datalayer.m_7877_());
            }
            if (datalayer1 != null && !datalayer1.m_62575_()) {
                compoundtag1.m_128382_("SkyLight", datalayer1.m_7877_());
            }
            if (compoundtag1.m_128456_()) continue;
            compoundtag1.m_128344_("Y", (byte)i);
            listtag.add((Object)compoundtag1);
        }
        compoundtag.m_128365_("sections", (Tag)listtag);
        if (flag) {
            compoundtag.m_128379_("isLightOn", true);
        }
        ListTag listtag1 = new ListTag();
        for (BlockPos blockpos : chunk.m_5928_()) {
            CompoundTag compoundtag3 = chunk.m_8051_(blockpos);
            if (compoundtag3 == null) continue;
            listtag1.add((Object)compoundtag3);
        }
        compoundtag.m_128365_("block_entities", (Tag)listtag1);
        if (chunk.m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)chunk;
            ListTag listtag2 = new ListTag();
            listtag2.addAll((Collection)protochunk.m_63293_());
            compoundtag.m_128365_("entities", (Tag)listtag2);
            CompoundTag compoundtag4 = new CompoundTag();
            for (GenerationStep.Carving generationstep$carving : GenerationStep.Carving.values()) {
                CarvingMask carvingmask = protochunk.m_183612_(generationstep$carving);
                if (carvingmask == null) continue;
                compoundtag4.m_128388_(generationstep$carving.toString(), carvingmask.m_187584_());
            }
            compoundtag.m_128365_("CarvingMasks", (Tag)compoundtag4);
        }
        WorldDownloadController.saveTicks(level, compoundtag, chunk.m_183568_());
        compoundtag.m_128365_("PostProcessing", (Tag)ChunkSerializer.m_63490_((ShortList[])chunk.m_6720_()));
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry entry : chunk.m_6890_()) {
            if (!chunk.m_6415_().m_62500_().contains(entry.getKey())) continue;
            compoundtag2.m_128365_(((Heightmap.Types)entry.getKey()).m_64294_(), (Tag)new LongArrayTag(((Heightmap)entry.getValue()).m_64239_()));
        }
        compoundtag.m_128365_("Heightmaps", (Tag)compoundtag2);
        compoundtag.m_128365_("structures", (Tag)WorldDownloadController.packStructureData());
        return compoundtag;
    }

    private Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> p_188261_) {
        return PalettedContainer.m_238418_((IdMap)p_188261_.m_206115_(), (Codec)p_188261_.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)p_188261_.m_246971_(Biomes.f_48202_));
    }

    private void closeAccess() {
        if (this.access != null) {
            try {
                this.access.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.access = null;
        }
    }

    private static void saveTicks(ClientLevel p_188236_, CompoundTag p_188237_, ChunkAccess.TicksToSave p_188238_) {
        long i = p_188236_.m_6106_().m_6793_();
        p_188237_.m_128365_("block_ticks", p_188238_.f_187680_().m_183237_(i, p_258987_ -> BuiltInRegistries.f_256975_.m_7981_(p_258987_).toString()));
        p_188237_.m_128365_("fluid_ticks", p_188238_.f_187681_().m_183237_(i, p_258989_ -> BuiltInRegistries.f_257020_.m_7981_(p_258989_).toString()));
    }

    private static CompoundTag packStructureData() {
        CompoundTag compoundtag = new CompoundTag();
        CompoundTag compoundtag1 = new CompoundTag();
        compoundtag.m_128365_("starts", (Tag)compoundtag1);
        CompoundTag compoundtag2 = new CompoundTag();
        compoundtag.m_128365_("References", (Tag)compoundtag2);
        return compoundtag;
    }
}

