/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;

public class TpsCounterController {
    public static final TpsCounterController instance = new TpsCounterController();
    private static final int SIZE = 20;
    private final long[] localTime = new long[20];
    private final long[] gameTime = new long[20];
    private int counter;

    private TpsCounterController() {
        Events.ClientPlayerLoggingIn.add(this::onLoggingIn);
        Events.ClientPlayerLoggingOut.add(this::onLoggingOut);
        Events.DimensionChange.add(this::onDimensionChange);
        NetworkPacketsController.instance.addServerPacketHandler(this::onServerPacket);
    }

    public double getTps() {
        if (this.counter < 2) {
            return 0.0;
        }
        int from = this.counter < 20 ? 0 : this.counter % 20;
        int to = this.counter < 20 ? this.counter - 1 : (this.counter - 1) % 20;
        long ns = this.localTime[to] - this.localTime[from];
        long ticks = this.gameTime[to] - this.gameTime[from];
        return (double)ticks / ((double)ns / 1.0E9);
    }

    private void onLoggingIn(Connection connection) {
        this.counter = 0;
    }

    private void onLoggingOut() {
        this.counter = 0;
    }

    private void onDimensionChange() {
        this.counter = 0;
    }

    private void onServerPacket(NetworkPacketsController.ServerPacketArgs args) {
        Packet<?> packet = args.packet;
        if (packet instanceof ClientboundSetTimePacket) {
            ClientboundSetTimePacket packet2 = (ClientboundSetTimePacket)packet;
            this.localTime[this.counter % 20] = System.nanoTime();
            this.gameTime[this.counter % 20] = packet2.m_133358_();
            ++this.counter;
        }
    }
}

