/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.common.Events;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;

public class SpeedCounterController {
    public static final SpeedCounterController instance = new SpeedCounterController();
    private static long INTERVAL = 500000000L;
    private final Minecraft mc = Minecraft.m_91087_();
    private final LinkedList<Entry> list = new LinkedList();

    private SpeedCounterController() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
    }

    public double getHorizontalSpeed() {
        if (this.list.size() >= 2) {
            Entry first = this.list.getFirst();
            Entry last = this.list.getLast();
            double distance = -first.horizontalDistance;
            for (Entry entry : this.list) {
                distance += entry.horizontalDistance;
            }
            return 1.0E9 * distance / (double)(last.time - first.time);
        }
        return 0.0;
    }

    public double getSpeed() {
        if (this.list.size() >= 2) {
            Entry first = this.list.getFirst();
            Entry last = this.list.getLast();
            double distance = -first.distance;
            for (Entry entry : this.list) {
                distance += entry.distance;
            }
            return 1.0E9 * distance / (double)(last.time - first.time);
        }
        return 0.0;
    }

    public void onClientTickEnd() {
        if (this.mc.f_91074_ == null) {
            this.list.clear();
            return;
        }
        long now = System.nanoTime();
        Entry entry = new Entry();
        entry.time = now;
        entry.x = this.mc.f_91074_.m_20185_();
        entry.y = this.mc.f_91074_.m_20186_();
        entry.z = this.mc.f_91074_.m_20189_();
        if (this.list.size() > 0) {
            Entry last = this.list.getLast();
            entry.distance = entry.getDistanceTo(last);
            entry.horizontalDistance = entry.getHorizontalDistanceTo(last);
        }
        this.list.addLast(entry);
        while (now - this.list.getFirst().time > INTERVAL) {
            this.list.removeFirst();
        }
    }

    private static class Entry {
        public long time;
        public double x;
        public double y;
        public double z;
        public double horizontalDistance;
        public double distance;

        private Entry() {
        }

        public double getDistanceTo(Entry other) {
            double dx = other.x - this.x;
            double dy = other.y - this.y;
            double dz = other.z - this.z;
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }

        public double getHorizontalDistanceTo(Entry other) {
            double dx = other.x - this.x;
            double dz = other.z - this.z;
            return Math.sqrt(dx * dx + dz * dz);
        }
    }
}

