/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.ContainerRenderLabelsEvent;
import com.zergatul.cheatutils.common.events.PreRenderTooltipEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.mixins.common.accessors.AbstractContainerScreenAccessor;
import com.zergatul.cheatutils.render.ItemRenderHelper;
import com.zergatul.cheatutils.utils.ItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class ShulkerTooltipController {
    public static ShulkerTooltipController instance = new ShulkerTooltipController();
    private static final ResourceLocation CONTAINER_TEXTURE = new ResourceLocation("textures/gui/container/shulker_box.png");
    private static final int ImageWidth = 176;
    private static final int ImageHeight = 166;
    private static final int TranslateZ = 250;
    private boolean locked = false;
    private boolean allowTooltip = false;
    private ItemStack lockedStack;
    private Matrix4f lockedPose;
    private int lockedX;
    private int lockedY;

    private ShulkerTooltipController() {
        Events.PreRenderTooltip.add(this::onPreRenderTooltip);
        Events.ContainerRenderLabels.add(this::onContainerRenderLabels);
    }

    private void onPreRenderTooltip(PreRenderTooltipEvent event) {
        if (this.locked && !this.allowTooltip) {
            event.cancel();
            return;
        }
        if (this.allowTooltip) {
            this.allowTooltip = false;
            return;
        }
        if (!ConfigStore.instance.getConfig().shulkerTooltipConfig.enabled) {
            this.clearLocked();
            return;
        }
        if (!ItemUtils.isShulkerBox(event.getItemStack())) {
            this.clearLocked();
            return;
        }
        event.cancel();
        PoseStack poseStack = event.getGraphics().m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 250.0f);
        RenderSystem.applyModelViewMatrix();
        int x = event.getX() - 176 - 16;
        int y = event.getY() - 4;
        if (Screen.m_96637_()) {
            this.locked = true;
            this.lockedPose = poseStack.m_85850_().m_252922_();
            this.lockedStack = event.getItemStack();
            this.lockedX = x;
            this.lockedY = y;
        }
        this.renderShulkerInventory(event.getGraphics(), event.getItemStack(), poseStack.m_85850_().m_252922_(), x, y);
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private void onContainerRenderLabels(ContainerRenderLabelsEvent event) {
        if (this.locked) {
            if (Screen.m_96637_()) {
                PoseStack poseStack = event.getGuiGraphics().m_280168_();
                poseStack.m_85836_();
                poseStack.m_166856_();
                poseStack.m_252931_(this.lockedPose);
                RenderSystem.applyModelViewMatrix();
                int x = this.lockedX;
                int y = this.lockedY;
                PoseStack.Pose pose = poseStack.m_85850_();
                this.renderShulkerInventory(event.getGuiGraphics(), this.lockedStack, pose.m_252922_(), x, y);
                int mx = event.getMouseX();
                int my = event.getMouseY();
                this.renderTooltip(event.getGuiGraphics(), x, y, mx, my);
                poseStack.m_85849_();
                RenderSystem.applyModelViewMatrix();
            } else {
                this.clearLocked();
            }
        }
    }

    private int globalToScreenX(int x, AbstractContainerScreen<?> screen) {
        return x - Minecraft.m_91087_().m_91268_().m_85445_() / 2 + ((AbstractContainerScreenAccessor)screen).getWidth_CU() / 2;
    }

    private int globalToScreenY(int y, AbstractContainerScreen<?> screen) {
        return y - Minecraft.m_91087_().m_91268_().m_85446_() / 2 + ((AbstractContainerScreenAccessor)screen).getHeight_CU() / 2;
    }

    private void renderShulkerInventory(GuiGraphics graphics, ItemStack itemStack, Matrix4f matrix, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONTAINER_TEXTURE);
        this.drawTexture(matrix, x, y, 176, 6, 100, 0, 0, 176, 6, 256, 256);
        this.drawTexture(matrix, x, y + 6, 176, 60, 100, 0, 14, 176, 60, 256, 256);
        this.drawTexture(matrix, x, y + 66, 176, 6, 100, 0, 160, 176, 6, 256, 256);
        NonNullList<ItemStack> content = ItemUtils.getShulkerContent(itemStack);
        for (int i = 0; i < content.size(); ++i) {
            ItemStack slot = (ItemStack)content.get(i);
            int slotX = i % 9;
            int slotY = i / 9;
            if (slot.m_41619_()) continue;
            this.renderSlot(graphics, slot, x + 8 + 18 * slotX, y + 10 + 18 * slotY);
        }
    }

    private void renderTooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        CompoundTag compound = this.lockedStack.m_41737_("BlockEntityTag");
        if (compound != null && compound.m_128425_("Items", 9)) {
            NonNullList list = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)list);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack slot = (ItemStack)list.get(i);
                int slotX = i % 9;
                int slotY = i / 9;
                if (slot.m_41619_() || x + 8 + 18 * slotX > mouseX || mouseX >= x + 8 + 18 * slotX + 16 || y + 10 + 18 * slotY > mouseY || mouseY >= y + 10 + 18 * slotY + 16) continue;
                this.allowTooltip = true;
                graphics.m_280153_(Minecraft.m_91087_().f_91062_, slot, mouseX, mouseY);
            }
        }
    }

    private void drawTexture(Matrix4f matrix, int x, int y, int width, int height, int z, int texX, int texY, int texWidth, int texHeight, int texSizeX, int texSizeY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableDepthTest();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, (float)x, (float)y, (float)z).m_7421_(1.0f * (float)texX / (float)texSizeX, 1.0f * (float)texY / (float)texSizeY).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)x, (float)(y + height), (float)z).m_7421_(1.0f * (float)texX / (float)texSizeX, 1.0f * (float)(texY + texHeight) / (float)texSizeY).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)(y + height), (float)z).m_7421_(1.0f * (float)(texX + texWidth) / (float)texSizeX, 1.0f * (float)(texY + texHeight) / (float)texSizeY).m_5752_();
        bufferbuilder.m_252986_(matrix, (float)(x + width), (float)y, (float)z).m_7421_(1.0f * (float)(texX + texWidth) / (float)texSizeX, 1.0f * (float)texY / (float)texSizeY).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private void renderSlot(GuiGraphics graphics, ItemStack itemStack, int x, int y) {
        RenderSystem.enableDepthTest();
        ItemRenderHelper.renderItem(graphics, itemStack, x, y);
    }

    private void clearLocked() {
        this.locked = false;
        this.lockedPose = null;
        this.lockedStack = null;
    }
}

