/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ScriptedBlockPlacerConfig;
import com.zergatul.cheatutils.controllers.CurrentBlockController;
import com.zergatul.cheatutils.modules.utilities.RenderUtilities;
import com.zergatul.cheatutils.render.LineRenderer;
import com.zergatul.cheatutils.utils.BlockPlacingMethod;
import com.zergatul.cheatutils.utils.BlockUtils;
import com.zergatul.cheatutils.utils.NearbyBlockEnumerator;
import com.zergatul.cheatutils.utils.SlotSelector;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ScriptedBlockPlacerController {
    public static final ScriptedBlockPlacerController instance = new ScriptedBlockPlacerController();
    private final Minecraft mc = Minecraft.m_91087_();
    private final SlotSelector slotSelector = new SlotSelector();
    private Runnable script;
    private String blockId;
    private BlockPlacingMethod method;
    private BlockUtils.PlaceBlockPlan debugPlan;
    private volatile boolean debugStep;

    private ScriptedBlockPlacerController() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
        Events.RenderWorldLast.add(this::onRenderWorldLast);
    }

    public void setScript(Runnable script) {
        this.script = script;
    }

    public void setBlock(String blockId, BlockPlacingMethod method) {
        this.blockId = blockId;
        this.method = method;
    }

    public void placeOne() {
        this.debugStep = true;
    }

    private void onClientTickEnd() {
        ScriptedBlockPlacerConfig config = ConfigStore.instance.getConfig().scriptedBlockPlacerConfig;
        if (!config.enabled) {
            return;
        }
        if (this.mc.f_91074_ == null || this.mc.f_91073_ == null) {
            return;
        }
        if (this.script == null) {
            return;
        }
        Vec3 eyePos = this.mc.f_91074_.m_20299_(1.0f);
        for (BlockPos pos : NearbyBlockEnumerator.getPositions(eyePos, config.maxRange)) {
            BlockUtils.PlaceBlockPlan plan;
            int slot;
            Block block;
            BlockState state = this.mc.f_91073_.m_8055_(pos);
            if (!state.m_247087_()) continue;
            this.blockId = null;
            CurrentBlockController.instance.set(pos, state);
            this.script.run();
            CurrentBlockController.instance.clear();
            if (this.blockId == null || (block = Registries.BLOCKS.getValue(new ResourceLocation(this.blockId))) == Blocks.f_50016_ || (slot = this.slotSelector.selectBlock(config, block)) < 0 || (plan = BlockUtils.getPlacingPlan(pos, config.attachToAir, this.method)) == null) continue;
            if (config.debugMode && !this.debugStep) {
                this.debugPlan = plan;
            } else {
                this.debugPlan = null;
                this.debugStep = false;
                this.mc.f_91074_.m_150109_().f_35977_ = slot;
                BlockUtils.applyPlacingPlan(plan, config.useShift);
            }
            return;
        }
    }

    private void onRenderWorldLast(RenderWorldLastEvent event) {
        ScriptedBlockPlacerConfig config = ConfigStore.instance.getConfig().scriptedBlockPlacerConfig;
        if (config.enabled && config.debugMode && this.debugPlan != null) {
            LineRenderer renderer = RenderUtilities.instance.getLineRenderer();
            renderer.begin(event, false);
            double x1 = this.debugPlan.neighbour().m_123341_();
            double y1 = this.debugPlan.neighbour().m_123342_();
            double z1 = this.debugPlan.neighbour().m_123343_();
            double x2 = x1 + 1.0;
            double y2 = y1 + 1.0;
            double z2 = z1 + 1.0;
            renderer.cuboid(x1, y1, z1, x2, y2, z2, 1.0f, 1.0f, 1.0f, 1.0f);
            renderer.end();
            renderer.begin(event, false);
            RenderSystem.setShaderColor((float)0.7f, (float)1.0f, (float)0.7f, (float)1.0f);
            x1 = (double)this.debugPlan.destination().m_123341_() + 0.05;
            y1 = (double)this.debugPlan.destination().m_123342_() + 0.05;
            z1 = (double)this.debugPlan.destination().m_123343_() + 0.05;
            x2 = x1 + 0.9;
            y2 = y1 + 0.9;
            z2 = z1 + 0.9;
            renderer.cuboid(x1, y1, z1, x2, y2, z2, 1.0f, 1.0f, 1.0f, 1.0f);
            renderer.end();
            renderer.begin(event, false);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.7f, (float)1.0f);
            for (Direction direction : Direction.values()) {
                Vec3 p1 = this.debugPlan.target().m_231075_(direction, 0.1);
                Vec3 p2 = this.debugPlan.target().m_231075_(direction, -0.1);
                renderer.line(p1.f_82479_, p1.f_82480_, p1.f_82481_, p2.f_82479_, p2.f_82480_, p2.f_82481_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            renderer.end();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

