/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.common.events.RenderWorldLayerEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.SchematicaConfig;
import com.zergatul.cheatutils.controllers.ChunkController;
import com.zergatul.cheatutils.render.Primitives;
import com.zergatul.cheatutils.schematics.PlacingConverter;
import com.zergatul.cheatutils.schematics.PlacingSettings;
import com.zergatul.cheatutils.schematics.SchemaFile;
import com.zergatul.cheatutils.utils.BlockUtils;
import com.zergatul.cheatutils.utils.JavaRandom;
import com.zergatul.cheatutils.utils.NearbyBlockEnumerator;
import com.zergatul.cheatutils.utils.SharedVertexBuffer;
import com.zergatul.cheatutils.utils.SlotSelector;
import com.zergatul.cheatutils.wrappers.BakedModelWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.phys.Vec3;

public class SchematicaController {
    public static final SchematicaController instance = new SchematicaController();
    private final Minecraft mc = Minecraft.m_91087_();
    private final List<Entry> entries = new ArrayList<Entry>();
    private final RandomSource random = new JavaRandom(0L);
    private final SlotSelector slotSelector = new SlotSelector();

    private SchematicaController() {
        Events.ScannerChunkLoaded.add(this::onChunkLoaded);
        Events.ScannerBlockUpdated.add(this::onBlockUpdated);
        Events.ClientTickEnd.add(this::onClientTickEnd);
        Events.RenderSolidLayer.add(this::onRenderSolidLayer);
        Events.RenderWorldLast.add(this::onRender);
    }

    public synchronized void clear() {
        this.entries.clear();
    }

    public synchronized void place(SchemaFile file, PlacingSettings placing) {
        Entry entry = new Entry(file, placing);
        this.entries.add(entry);
        ChunkController.instance.getLoadedChunks().forEach(p -> entry.onChunkLoaded((LevelChunk)p.getSecond()));
    }

    private synchronized void onClientTickEnd() {
        Block blockInHand;
        SchematicaConfig config = ConfigStore.instance.getConfig().schematicaConfig;
        if (!config.enabled || !config.autoBuild) {
            return;
        }
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null) {
            return;
        }
        Vec3 eyePos = this.mc.f_91074_.m_146892_();
        ItemStack itemInHand = this.mc.f_91074_.m_21205_();
        Item item = itemInHand.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockInHand = blockItem.m_40614_();
        } else {
            blockInHand = null;
        }
        BlockUtils.PlaceBlockPlan plan = null;
        BlockState state = null;
        for (BlockPos pos : NearbyBlockEnumerator.getPositions(eyePos, config.maxRange)) {
            Entry entry;
            Iterator<Entry> iterator = this.entries.iterator();
            while (iterator.hasNext() && ((state = (entry = iterator.next()).getBlockState(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_60795_() || (plan = BlockUtils.getPlacingPlan(pos, config.attachToAir)) == null)) {
            }
            if (plan == null) continue;
            break;
        }
        if (plan == null) {
            return;
        }
        int slot = this.slotSelector.selectBlock(config, state.m_60734_());
        if (slot >= 0) {
            this.mc.f_91074_.m_150109_().f_35977_ = slot;
            blockInHand = state.m_60734_();
        }
        if (blockInHand == state.m_60734_()) {
            BlockUtils.applyPlacingPlan(plan, config.useShift);
        }
    }

    private synchronized void onRenderSolidLayer(RenderWorldLayerEvent event) {
        SchematicaConfig config = ConfigStore.instance.getConfig().schematicaConfig;
        if (!config.enabled) {
            return;
        }
        if (this.mc.f_91073_ == null) {
            return;
        }
        Vec3 view = event.getCamera().m_90583_();
        if (config.showMissingBlockGhosts) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            HashMap ghosts = new HashMap();
            for (Entry entry : this.entries) {
                entry.forEachMissingState(view, config.missingBlockGhostsMaxDistance, ghosts::put);
            }
            BlockPos.MutableBlockPos neighPos = new BlockPos.MutableBlockPos();
            for (Map.Entry mapEntry : ghosts.entrySet()) {
                BlockPos pos = (BlockPos)mapEntry.getKey();
                BlockState state = (BlockState)mapEntry.getValue();
                BakedModel model = this.mc.m_91289_().m_110910_(state);
                for (Direction direction : Direction.values()) {
                    List<BakedQuad> quads;
                    neighPos.m_142451_(pos.m_123341_() + direction.m_122429_());
                    neighPos.m_142448_(pos.m_123342_() + direction.m_122430_());
                    neighPos.m_142443_(pos.m_123343_() + direction.m_122431_());
                    if (ghosts.containsKey(neighPos) || (quads = BakedModelWrapper.getQuads(model, direction, this.random)).size() <= 0) continue;
                    BakedQuad quad = quads.get(0);
                    TextureAtlasSprite sprite = quad.m_173410_();
                    BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
                    FaceInfo face = FaceInfo.m_108984_((Direction)direction);
                    FaceInfo.VertexInfo info = face.m_108982_(0);
                    bufferBuilder.m_5483_((double)(info.f_108998_ == FaceInfo.Constants.f_108996_ ? pos.m_123341_() : pos.m_123341_() + 1) - view.f_82479_, (double)(info.f_108999_ == FaceInfo.Constants.f_108995_ ? pos.m_123342_() : pos.m_123342_() + 1) - view.f_82480_, (double)(info.f_109000_ == FaceInfo.Constants.f_108994_ ? pos.m_123343_() : pos.m_123343_() + 1) - view.f_82481_).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
                    info = face.m_108982_(1);
                    bufferBuilder.m_5483_((double)(info.f_108998_ == FaceInfo.Constants.f_108996_ ? pos.m_123341_() : pos.m_123341_() + 1) - view.f_82479_, (double)(info.f_108999_ == FaceInfo.Constants.f_108995_ ? pos.m_123342_() : pos.m_123342_() + 1) - view.f_82480_, (double)(info.f_109000_ == FaceInfo.Constants.f_108994_ ? pos.m_123343_() : pos.m_123343_() + 1) - view.f_82481_).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
                    info = face.m_108982_(2);
                    bufferBuilder.m_5483_((double)(info.f_108998_ == FaceInfo.Constants.f_108996_ ? pos.m_123341_() : pos.m_123341_() + 1) - view.f_82479_, (double)(info.f_108999_ == FaceInfo.Constants.f_108995_ ? pos.m_123342_() : pos.m_123342_() + 1) - view.f_82480_, (double)(info.f_109000_ == FaceInfo.Constants.f_108994_ ? pos.m_123343_() : pos.m_123343_() + 1) - view.f_82481_).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
                    info = face.m_108982_(3);
                    bufferBuilder.m_5483_((double)(info.f_108998_ == FaceInfo.Constants.f_108996_ ? pos.m_123341_() : pos.m_123341_() + 1) - view.f_82479_, (double)(info.f_108999_ == FaceInfo.Constants.f_108995_ ? pos.m_123342_() : pos.m_123342_() + 1) - view.f_82480_, (double)(info.f_109000_ == FaceInfo.Constants.f_108994_ ? pos.m_123343_() : pos.m_123343_() + 1) - view.f_82481_).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
                    SharedVertexBuffer.instance.m_85921_();
                    SharedVertexBuffer.instance.m_231221_(bufferBuilder.m_231175_());
                    SharedVertexBuffer.instance.m_253207_(event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix(), GameRenderer.m_172817_());
                    VertexBuffer.m_85931_();
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private synchronized void onRender(RenderWorldLastEvent event) {
        BufferBuilder bufferBuilder;
        BufferBuilder bufferBuilder2;
        double tracerZ;
        double tracerY;
        double tracerX;
        Vec3 tracerCenter;
        SchematicaConfig config = ConfigStore.instance.getConfig().schematicaConfig;
        if (!config.enabled) {
            return;
        }
        if (this.mc.f_91073_ == null) {
            return;
        }
        Vec3 view = event.getCamera().m_90583_();
        if (config.showMissingBlockTracers) {
            tracerCenter = event.getTracerCenter();
            tracerX = tracerCenter.f_82479_;
            tracerY = tracerCenter.f_82480_;
            tracerZ = tracerCenter.f_82481_;
            bufferBuilder2 = Tesselator.m_85913_().m_85915_();
            bufferBuilder2.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            RenderSystem.setShaderColor((float)0.2f, (float)1.0f, (float)0.2f, (float)0.8f);
            for (Entry entry : this.entries) {
                entry.forEachMissing(view, config.missingBlockTracersMaxDistance, pos -> {
                    bufferBuilder2.m_5483_(tracerX - view.f_82479_, tracerY - view.f_82480_, tracerZ - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
                    bufferBuilder2.m_5483_((double)pos.m_123341_() + 0.5 - view.f_82479_, (double)pos.m_123342_() + 0.5 - view.f_82480_, (double)pos.m_123343_() + 0.5 - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
                });
            }
            Primitives.renderLines(bufferBuilder2, event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix());
        }
        if (config.showMissingBlockCubes) {
            bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            RenderSystem.setShaderColor((float)0.2f, (float)1.0f, (float)0.2f, (float)0.8f);
            for (Entry entry : this.entries) {
                entry.forEachMissing(view, config.missingBlockCubesMaxDistance, pos -> {
                    double x1 = (double)pos.m_123341_() + 0.25 - view.f_82479_;
                    double y1 = (double)pos.m_123342_() + 0.25 - view.f_82480_;
                    double z1 = (double)pos.m_123343_() + 0.25 - view.f_82481_;
                    double x2 = x1 + 0.5;
                    double y2 = y1 + 0.5;
                    double z2 = z1 + 0.5;
                    Primitives.drawCube(bufferBuilder, x1, y1, z1, x2, y2, z2);
                });
            }
            Primitives.renderLines(bufferBuilder, event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix());
        }
        if (config.showWrongBlockTracers) {
            tracerCenter = event.getTracerCenter();
            tracerX = tracerCenter.f_82479_;
            tracerY = tracerCenter.f_82480_;
            tracerZ = tracerCenter.f_82481_;
            bufferBuilder2 = Tesselator.m_85913_().m_85915_();
            bufferBuilder2.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            for (Entry entry : this.entries) {
                entry.forEachWrong(view, config.wrongBlockTracersMaxDistance, pos -> {
                    bufferBuilder2.m_5483_(tracerX - view.f_82479_, tracerY - view.f_82480_, tracerZ - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
                    bufferBuilder2.m_5483_((double)pos.m_123341_() + 0.5 - view.f_82479_, (double)pos.m_123342_() + 0.5 - view.f_82480_, (double)pos.m_123343_() + 0.5 - view.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
                });
            }
            Primitives.renderLines(bufferBuilder2, event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix());
        }
        if (config.showWrongBlockCubes) {
            bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            for (Entry entry : this.entries) {
                entry.forEachWrong(view, config.wrongBlockCubesMaxDistance, pos -> {
                    double x1 = (double)pos.m_123341_() + 0.25 - view.f_82479_;
                    double y1 = (double)pos.m_123342_() + 0.25 - view.f_82480_;
                    double z1 = (double)pos.m_123343_() + 0.25 - view.f_82481_;
                    double x2 = x1 + 0.5;
                    double y2 = y1 + 0.5;
                    double z2 = z1 + 0.5;
                    Primitives.drawCube(bufferBuilder, x1, y1, z1, x2, y2, z2);
                });
            }
            Primitives.renderLines(bufferBuilder, event.getMatrixStack().m_85850_().m_252922_(), event.getProjectionMatrix());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private synchronized void onChunkLoaded(LevelChunk chunk) {
        for (Entry entry : this.entries) {
            entry.onChunkLoaded(chunk);
        }
    }

    private synchronized void onBlockUpdated(BlockUpdateEvent event) {
        for (Entry entry : this.entries) {
            entry.onBlockUpdated(event);
        }
    }

    private static class Entry {
        public final int x1;
        public final int x2;
        public final int y1;
        public final int y2;
        public final int z1;
        public final int z2;
        public final Map<Long, Chunk> chunks;

        public Entry(SchemaFile file, PlacingSettings placing) {
            PlacingConverter converter = new PlacingConverter(placing, file.getWidth(), file.getHeight(), file.getLength());
            this.x1 = placing.x;
            this.x2 = this.x1 + converter.getWidth();
            this.y1 = placing.y;
            this.y2 = this.y1 + converter.getHeight();
            this.z1 = placing.z;
            this.z2 = this.z1 + converter.getLength();
            this.chunks = new HashMap<Long, Chunk>();
            for (int x = 0; x < file.getWidth(); ++x) {
                for (int y = 0; y < file.getHeight(); ++y) {
                    for (int z = 0; z < file.getLength(); ++z) {
                        BlockState state = file.getBlockState(x, y, z);
                        if (state.m_60795_()) continue;
                        PlacingConverter.Vec3iMutable vec = converter.convert(x, y, z);
                        int wx = this.x1 + vec.x;
                        int wy = this.y1 + vec.y;
                        int wz = this.z1 + vec.z;
                        long chunkIndex = this.blockToChunkIndex(wx, wz);
                        Chunk chunk = this.chunks.get(chunkIndex);
                        if (chunk == null) {
                            chunk = new Chunk(wx & 0xFFFFFFF0, wz & 0xFFFFFFF0);
                            this.chunks.put(chunkIndex, chunk);
                        }
                        chunk.setBlockState(wx & 0xF, wy, wz & 0xF, state);
                    }
                }
            }
        }

        public void forEachMissing(Vec3 view, double distance, Consumer<BlockPos> consumer) {
            double chunkDistance2 = (distance + 23.0) * (distance + 23.0);
            double distance2 = distance * distance;
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.getDistanceSqrTo(view) > chunkDistance2) continue;
                for (ChunkSection section : chunk.sections) {
                    if (section == null || section.getDistanceSqrTo(view) > chunkDistance2) continue;
                    for (BlockPos pos : section.missing) {
                        if (!(pos.m_203193_((Position)view) < distance2)) continue;
                        consumer.accept(pos);
                    }
                }
            }
        }

        public void forEachMissingState(Vec3 view, double distance, BiConsumer<BlockPos, BlockState> consumer) {
            double chunkDistance2 = (distance + 23.0) * (distance + 23.0);
            double distance2 = distance * distance;
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.getDistanceSqrTo(view) > chunkDistance2) continue;
                for (ChunkSection section : chunk.sections) {
                    if (section == null || section.getDistanceSqrTo(view) > chunkDistance2) continue;
                    for (BlockPos pos : section.missing) {
                        if (!(pos.m_203193_((Position)view) < distance2)) continue;
                        consumer.accept(pos, section.getBlockState(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF));
                    }
                }
            }
        }

        public void forEachWrong(Vec3 view, double distance, Consumer<BlockPos> consumer) {
            double chunkDistance2 = (distance + 23.0) * (distance + 23.0);
            double distance2 = distance * distance;
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.getDistanceSqrTo(view) > chunkDistance2) continue;
                for (ChunkSection section : chunk.sections) {
                    if (section == null || section.getDistanceSqrTo(view) > chunkDistance2) continue;
                    for (BlockPos pos : section.wrong) {
                        if (!(pos.m_203193_((Position)view) < distance2)) continue;
                        consumer.accept(pos);
                    }
                }
            }
        }

        public void forEachSection(Vec3 view, double distance, Consumer<ChunkSection> consumer) {
            double chunkDistance2 = (distance + 23.0) * (distance + 23.0);
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.getDistanceSqrTo(view) > chunkDistance2) continue;
                for (ChunkSection section : chunk.sections) {
                    if (section == null || section.getDistanceSqrTo(view) > chunkDistance2) continue;
                    consumer.accept(section);
                }
            }
        }

        public BlockState getBlockState(int x, int y, int z) {
            long chunkIndex = this.blockToChunkIndex(x, z);
            Chunk chunk = this.chunks.get(chunkIndex);
            if (chunk == null) {
                return Blocks.f_50016_.m_49966_();
            }
            return chunk.getBlockState(x & 0xF, y, z & 0xF);
        }

        public void onChunkLoaded(LevelChunk levelChunk) {
            long chunkIndex = this.chunkToChunkIndex(levelChunk);
            Chunk chunk = this.chunks.get(chunkIndex);
            if (chunk != null) {
                chunk.onChunkLoaded(this, levelChunk);
            }
        }

        public void onBlockUpdated(BlockUpdateEvent event) {
            long chunkIndex = this.blockToChunkIndex(event.pos().m_123341_(), event.pos().m_123343_());
            Chunk chunk = this.chunks.get(chunkIndex);
            if (chunk != null) {
                chunk.onBlockUpdated(event);
            }
        }

        private long blockToChunkIndex(int x, int z) {
            x = SectionPos.m_123171_((int)x);
            z = SectionPos.m_123171_((int)z);
            return ChunkPos.m_45589_((int)x, (int)z);
        }

        private long chunkToChunkIndex(LevelChunk chunk) {
            return ChunkPos.m_45589_((int)chunk.m_7697_().f_45578_, (int)chunk.m_7697_().f_45579_);
        }
    }

    private static class ChunkSection {
        private final int minX;
        private final int minY;
        private final int minZ;
        private final PalettedContainer<BlockState> states;
        private final List<BlockPos> missing = new ArrayList<BlockPos>();
        private final List<BlockPos> wrong = new ArrayList<BlockPos>();

        public ChunkSection(int x, int y, int z) {
            this.minX = x;
            this.minY = y;
            this.minZ = z;
            this.states = new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
        }

        public BlockState getBlockState(int x, int y, int z) {
            return (BlockState)this.states.m_63087_(x, y, z);
        }

        public double getDistanceSqrTo(Vec3 point) {
            double dx = point.f_82479_ - (double)(this.minX + 8);
            double dy = point.f_82480_ - (double)(this.minY + 8);
            double dz = point.f_82481_ - (double)(this.minZ + 8);
            return dx * dx + dy * dy + dz * dz;
        }

        public void onChunkLoaded(Entry entry, LevelChunk chunk) {
            this.missing.clear();
            this.wrong.clear();
            SchematicaConfig config = ConfigStore.instance.getConfig().schematicaConfig;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = 0; x < 16; ++x) {
                int worldX = this.minX | x;
                if (worldX < entry.x1 || worldX >= entry.x2) continue;
                pos.m_142451_(x);
                for (int y = 0; y < 16; ++y) {
                    int worldY = this.minY | y;
                    if (worldY < entry.y1 || worldY >= entry.y2) continue;
                    pos.m_142448_(worldY);
                    for (int z = 0; z < 16; ++z) {
                        int worldZ = this.minZ | z;
                        if (worldZ < entry.z1 || worldZ >= entry.z2) continue;
                        pos.m_142443_(z);
                        BlockState chunkState = chunk.m_8055_((BlockPos)pos);
                        BlockState finalState = (BlockState)this.states.m_63087_(x, y, z);
                        if (this.isMissing(chunkState, finalState)) {
                            this.missing.add(new BlockPos(worldX, worldY, worldZ));
                            continue;
                        }
                        if (!this.isWrong(chunkState, finalState, config)) continue;
                        this.wrong.add(new BlockPos(worldX, worldY, worldZ));
                    }
                }
            }
        }

        public void onBlockUpdated(BlockUpdateEvent event) {
            BlockPos pos = event.pos();
            this.missing.removeIf(p -> p.equals((Object)pos));
            this.wrong.removeIf(p -> p.equals((Object)pos));
            BlockState chunkState = event.state();
            BlockState finalState = (BlockState)this.states.m_63087_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF);
            if (this.isMissing(chunkState, finalState)) {
                this.missing.add(pos.m_7949_());
            } else if (this.isWrong(chunkState, finalState, ConfigStore.instance.getConfig().schematicaConfig)) {
                this.wrong.add(pos.m_7949_());
            }
        }

        public void setBlockState(int x, int y, int z, BlockState state) {
            this.states.m_156470_(x, y, z, (Object)state);
        }

        private boolean isMissing(BlockState chunkState, BlockState finalState) {
            return chunkState.m_247087_() && !finalState.m_60795_();
        }

        private boolean isWrong(BlockState chunkState, BlockState finalState, SchematicaConfig config) {
            if (config.airAlwaysValid && finalState.m_60795_()) {
                return false;
            }
            if (config.replaceableAsAir) {
                return !chunkState.m_247087_() && chunkState != finalState;
            }
            return !chunkState.m_60795_() && chunkState != finalState;
        }

        private boolean contains(BlockPos pos) {
            if (pos.m_123341_() < this.minX) {
                return false;
            }
            if (pos.m_123341_() >= this.minX + 16) {
                return false;
            }
            if (pos.m_123342_() < this.minY) {
                return false;
            }
            if (pos.m_123342_() >= this.minY + 16) {
                return false;
            }
            if (pos.m_123343_() < this.minZ) {
                return false;
            }
            return pos.m_123343_() < this.minZ + 16;
        }
    }

    private static class Chunk {
        private static final int MIN_Y = -64;
        private static final int MAX_Y = 320;
        private static final int MIN_SECTION_Y = -4;
        private static final int MAX_SECTION_Y = 20;
        private final int minX;
        private final int minZ;
        public final ChunkSection[] sections;

        public Chunk(int x, int z) {
            this.minX = x;
            this.minZ = z;
            this.sections = new ChunkSection[24];
        }

        public BlockState getBlockState(int x, int y, int z) {
            int sectionIndex = y - -64 >> 4;
            if (sectionIndex >= this.sections.length) {
                return Blocks.f_50016_.m_49966_();
            }
            ChunkSection section = this.sections[sectionIndex];
            if (section == null) {
                return Blocks.f_50016_.m_49966_();
            }
            return section.getBlockState(x, y & 0xF, z);
        }

        public double getDistanceSqrTo(Vec3 point) {
            double dx = point.f_82479_ - (double)(this.minX + 8);
            double dz = point.f_82481_ - (double)(this.minZ + 8);
            return dx * dx + dz * dz;
        }

        public void onChunkLoaded(Entry entry, LevelChunk chunk) {
            for (int i = 0; i < this.sections.length; ++i) {
                if (this.sections[i] == null) continue;
                this.sections[i].onChunkLoaded(entry, chunk);
            }
        }

        public void onBlockUpdated(BlockUpdateEvent event) {
            if (event.pos().m_123342_() >= 320) {
                return;
            }
            int sectionIndex = event.pos().m_123342_() - -64 >> 4;
            ChunkSection section = this.sections[sectionIndex];
            if (section != null) {
                section.onBlockUpdated(event);
            }
        }

        public void setBlockState(int x, int y, int z, BlockState state) {
            int sectionIndex = y - -64 >> 4;
            if (this.sections[sectionIndex] == null) {
                this.sections[sectionIndex] = new ChunkSection(this.minX, -64 + (sectionIndex << 4), this.minZ);
            }
            this.sections[sectionIndex].setBlockState(x, y & 0xF, z, state);
        }
    }
}

