/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.mixins.common.accessors.ConnectionAccessor;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;

public class NetworkPacketsController {
    public static final NetworkPacketsController instance = new NetworkPacketsController();
    private final List<Consumer<ServerPacketArgs>> serverPacketHandlers = new ArrayList<Consumer<ServerPacketArgs>>();
    private final List<Consumer<ClientPacketArgs>> clientPacketHandlers = new ArrayList<Consumer<ClientPacketArgs>>();
    private Connection connection;
    private boolean handlersStopped;

    private NetworkPacketsController() {
        Events.ClientPlayerLoggingIn.add(this::onClientPlayerLoggingIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerPacketHandler(Consumer<ServerPacketArgs> handler) {
        List<Consumer<ServerPacketArgs>> list = this.serverPacketHandlers;
        synchronized (list) {
            this.serverPacketHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientPacketHandler(Consumer<ClientPacketArgs> handler) {
        List<Consumer<ClientPacketArgs>> list = this.clientPacketHandlers;
        synchronized (list) {
            this.clientPacketHandlers.add(handler);
        }
    }

    public void sendPacket(Packet<?> packet) {
        this.connection.m_129512_(packet);
    }

    public void receivePacket(Packet<?> packet) {
        ((ConnectionAccessor)this.connection).getChannel_CU().pipeline().fireChannelRead(packet);
    }

    public void stopHandlers() {
        this.handlersStopped = true;
    }

    public void resumeHandlers() {
        this.handlersStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClientPlayerLoggingIn(Connection connection) {
        ChannelPipeline pipeline;
        this.connection = connection;
        ChannelPipeline channelPipeline = pipeline = ((ConnectionAccessor)connection).getChannel_CU().pipeline();
        synchronized (channelPipeline) {
            if (pipeline.get("PacketReader") == null) {
                pipeline.addBefore("packet_handler", "PacketReader", (ChannelHandler)new SimpleChannelInboundHandler<Packet<?>>(){

                    protected void channelRead0(ChannelHandlerContext ctx, Packet<?> msg) throws Exception {
                        if (!NetworkPacketsController.this.handlersStopped) {
                            ServerPacketArgs args = new ServerPacketArgs();
                            args.packet = msg;
                            for (Consumer<ServerPacketArgs> handler : NetworkPacketsController.this.serverPacketHandlers) {
                                handler.accept(args);
                                if (!args.skip) continue;
                                return;
                            }
                        }
                        ctx.fireChannelRead(msg);
                    }
                });
            }
            if (pipeline.get("PacketWriter") == null) {
                pipeline.addBefore("packet_handler", "PacketWriter", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

                    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                        if (!NetworkPacketsController.this.handlersStopped) {
                            ClientPacketArgs args = new ClientPacketArgs();
                            args.packet = (Packet)msg;
                            for (Consumer<ClientPacketArgs> handler : NetworkPacketsController.this.clientPacketHandlers) {
                                handler.accept(args);
                                if (!args.skip) continue;
                                promise.setSuccess();
                                return;
                            }
                            ctx.write(args.packet, promise);
                        } else {
                            ctx.write(msg, promise);
                        }
                    }
                });
            }
        }
    }

    public static class ClientPacketArgs {
        public Packet<?> packet;
        public boolean skip;
    }

    public static class ServerPacketArgs {
        public Packet<?> packet;
        public boolean skip;
    }
}

