/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.common.events.RenderGuiEvent;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.EntityTitleConfig;
import com.zergatul.cheatutils.configs.EntityTracerConfig;
import com.zergatul.cheatutils.font.GlyphFontRenderer;
import com.zergatul.cheatutils.font.TextBounds;
import com.zergatul.cheatutils.mixins.common.accessors.ProjectileAccessor;
import com.zergatul.cheatutils.render.GlStates;
import com.zergatul.cheatutils.render.ItemRenderHelper;
import com.zergatul.cheatutils.render.Primitives;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;

public class EntityTitleController {
    public static final EntityTitleController instance = new EntityTitleController();
    private final Minecraft mc = Minecraft.m_91087_();
    private final LoadingCache<UUID, Optional<String>> usernameCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<UUID, Optional<String>>(){

        public Optional<String> load(UUID uuid) {
            CompletableFuture.runAsync(() -> {
                GameProfile playerProfile = new GameProfile(uuid, null);
                playerProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(playerProfile, false);
                if (playerProfile.getName() == null) {
                    EntityTitleController.this.usernameCache.put((Object)uuid, Optional.of(uuid.toString()));
                } else {
                    EntityTitleController.this.usernameCache.put((Object)uuid, Optional.of(playerProfile.getName()));
                }
            });
            return Optional.of("loading...");
        }
    });
    private final List<EntityEntry> entities = new ArrayList<EntityEntry>();
    private GlyphFontRenderer fontRenderer;
    private GlyphFontRenderer enchFontRenderer;

    private EntityTitleController() {
        Events.RenderWorldLast.add(this::onRenderWorld);
        Events.PreRenderGui.add(this::onRenderGui);
    }

    public void onFontChange(EntityTitleConfig config) {
        RenderSystem.recordRenderCall(() -> {
            if (this.fontRenderer != null) {
                this.fontRenderer.dispose();
            }
            this.fontRenderer = new GlyphFontRenderer(new Font("Consolas", 0, config.fontSize), config.antiAliasing);
        });
    }

    public void onEnchantmentFontChange(EntityTitleConfig config) {
        RenderSystem.recordRenderCall(() -> {
            if (this.enchFontRenderer != null) {
                this.enchFontRenderer.dispose();
            }
            this.enchFontRenderer = new GlyphFontRenderer(new Font("Consolas", 0, config.enchFontSize), config.enchAntiAliasing);
        });
    }

    private void onRenderWorld(RenderWorldLastEvent event) {
        this.entities.clear();
        if (this.mc.f_91073_ == null) {
            return;
        }
        if (!ConfigStore.instance.getConfig().esp) {
            return;
        }
        ImmutableList<EntityTracerConfig> entityConfigs = ConfigStore.instance.getConfig().entities.configs;
        Vec3 view = event.getCamera().m_90583_();
        for (Entity entity : this.mc.f_91073_.m_104735_()) {
            if (entity == this.mc.f_91074_ && this.mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) continue;
            Vec3 pos = entity.m_20318_(event.getTickDelta());
            double distanceSqr = pos.m_82557_(view);
            boolean drawTitles = false;
            boolean showDefaultNames = false;
            boolean showHp = false;
            boolean showEquippedItems = false;
            boolean showOwner = false;
            for (EntityTracerConfig entityConfig : entityConfigs) {
                if (!entityConfig.enabled || !entityConfig.drawTitles || !entityConfig.isValidEntity(entity) || !(distanceSqr < entityConfig.maxDistance * entityConfig.maxDistance)) continue;
                drawTitles = true;
                showDefaultNames |= entityConfig.showDefaultNames;
                showHp |= entityConfig.showHp;
                showEquippedItems |= entityConfig.showEquippedItems;
                showOwner |= entityConfig.showOwner;
            }
            if (!drawTitles) continue;
            pos = pos.m_82520_(-view.f_82479_, -view.f_82480_ + (double)entity.m_20206_(), -view.f_82481_);
            this.entities.add(new EntityEntry(entity, pos, distanceSqr, showDefaultNames, showHp, showEquippedItems, showOwner));
        }
        this.entities.sort((e1, e2) -> -Double.compare(e1.distanceSqr, e2.distanceSqr));
    }

    public void onRenderGui(RenderGuiEvent event) {
        if (this.fontRenderer == null) {
            return;
        }
        if (!ConfigStore.instance.getConfig().esp) {
            return;
        }
        double scale = this.mc.m_91268_().m_85449_();
        double invScale = 1.0 / scale;
        double scaledHalfWidth = (double)this.mc.m_91268_().m_85441_() * invScale / 2.0;
        double scaledHalfHeight = (double)this.mc.m_91268_().m_85442_() * invScale / 2.0;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<List<EnchantmentEntry>> enchantments = new ArrayList<List<EnchantmentEntry>>();
        ArrayList<TextBounds[]> enchantmentBounds = new ArrayList<TextBounds[]>();
        ArrayList<Integer> enchantmentWidths = new ArrayList<Integer>();
        ArrayList<Integer> enchantmentTextWidths = new ArrayList<Integer>();
        PoseStack poseStack = event.getGuiGraphics().m_280168_();
        poseStack.m_85836_();
        poseStack.m_85850_().m_252922_().translate((float)scaledHalfWidth, (float)scaledHalfHeight, 0.0f);
        for (EntityEntry entry : this.entities) {
            int i;
            Entity nameOpt2;
            Optional nameOpt2;
            UUID owner;
            Vector4f v1 = event.getWorldPoseMatrix().transform(new Vector4f((float)entry.position.f_82479_, (float)entry.position.f_82480_, (float)entry.position.f_82481_, 1.0f));
            Vector4f v2 = event.getWorldProjectionMatrix().transform(v1);
            if (v2.z <= 0.0f) continue;
            double xc = (double)(v2.x / v2.w) * scaledHalfWidth;
            double yc = (double)(-v2.y / v2.w) * scaledHalfHeight;
            String text = this.getEntityText(entry);
            if (text != null) {
                TextBounds bounds = this.fontRenderer.getTextSize(text);
                double width = (double)bounds.width() * invScale;
                double height = (double)bounds.height() * invScale;
                double xp = xc - width / 2.0;
                double yp = yc -= height;
                double horizontalPadding = scale;
                double verticalPadding = scale;
                double rx1 = xp - horizontalPadding * invScale;
                double rx2 = xp + width + horizontalPadding * invScale;
                double ry1 = yp + ((double)bounds.top() - verticalPadding) * invScale;
                double ry2 = yp + height - ((double)bounds.bottom() - verticalPadding) * invScale;
                Primitives.fill(poseStack, rx1, ry1, rx2, ry2, Color.BLACK.getRGB() & 0x40000000);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.fontRenderer.drawText(poseStack, text, (float)xp, (float)yp, invScale);
            }
            if (entry.showOwner && (owner = this.getOwner(entry.entity)) != null && (nameOpt2 = (Optional)this.usernameCache.getUnchecked((Object)owner)).isPresent()) {
                String ownerText = "Owner: " + (String)nameOpt2.get();
                TextBounds bounds = this.fontRenderer.getTextSize(ownerText);
                double width = (double)bounds.width() * invScale;
                double height = (double)bounds.height() * invScale;
                double xp = xc - width / 2.0;
                double yp = yc -= height;
                double horizontalPadding = scale;
                double verticalPadding = scale;
                double rx1 = xp - horizontalPadding * invScale;
                double rx2 = xp + width + horizontalPadding * invScale;
                double ry1 = yp + ((double)bounds.top() - verticalPadding) * invScale;
                double ry2 = yp + height - ((double)bounds.bottom() - verticalPadding) * invScale;
                Primitives.fill(poseStack, rx1, ry1, rx2, ry2, Color.BLACK.getRGB() & 0x40000000);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.fontRenderer.drawText(poseStack, ownerText, (float)xp, (float)yp, invScale);
            }
            if (!entry.showEquippedItems || this.enchFontRenderer == null || !((nameOpt2 = entry.entity) instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)nameOpt2;
            ItemStack mainHand = livingEntity.m_6844_(EquipmentSlot.MAINHAND);
            ItemStack head = livingEntity.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = livingEntity.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = livingEntity.m_6844_(EquipmentSlot.LEGS);
            ItemStack feet = livingEntity.m_6844_(EquipmentSlot.FEET);
            ItemStack offhand = livingEntity.m_6844_(EquipmentSlot.OFFHAND);
            items.clear();
            if (!mainHand.m_41619_()) {
                items.add(mainHand);
            }
            if (!head.m_41619_()) {
                items.add(head);
            }
            if (!chest.m_41619_()) {
                items.add(chest);
            }
            if (!legs.m_41619_()) {
                items.add(legs);
            }
            if (!feet.m_41619_()) {
                items.add(feet);
            }
            if (!offhand.m_41619_()) {
                items.add(offhand);
            }
            if (items.size() <= 0) continue;
            enchantments.clear();
            enchantmentWidths.clear();
            enchantmentTextWidths.clear();
            enchantmentBounds.clear();
            for (ItemStack item : items) {
                List<EnchantmentEntry> entries = this.getEnchantments(item);
                enchantments.add(entries);
                TextBounds[] bounds = new TextBounds[entries.size()];
                int maxWidth = 16;
                int maxTextWidth = 0;
                for (int i2 = 0; i2 < bounds.length; ++i2) {
                    EnchantmentEntry ee = entries.get(i2);
                    bounds[i2] = this.enchFontRenderer.getTextSize(ee.text + ee.level);
                    int width = Mth.m_14165_((double)((double)bounds[i2].width() * invScale));
                    if (width > maxWidth) {
                        maxWidth = width;
                    }
                    if (width <= maxTextWidth) continue;
                    maxTextWidth = width;
                }
                enchantmentWidths.add(maxWidth);
                enchantmentTextWidths.add(maxTextWidth);
                enchantmentBounds.add(bounds);
            }
            double width = 0.0;
            Iterator entries = enchantmentWidths.iterator();
            while (entries.hasNext()) {
                int ew = (Integer)entries.next();
                width += (double)ew;
            }
            double height = 16.0;
            double xp = xc - width / 2.0 + scaledHalfWidth;
            double yp = (yc -= height) + scaledHalfHeight;
            GlStates.setupOverlayRenderState(true, false);
            double xpl = xp;
            for (i = 0; i < items.size(); ++i) {
                double xCenterOffset = (Integer)enchantmentTextWidths.get(i) > 16 ? (double)((Integer)enchantmentTextWidths.get(i) - 16) / 2.0 : 0.0;
                ItemRenderHelper.renderItem(livingEntity, (ItemStack)items.get(i), xpl + xCenterOffset, yp, 0.0);
                xpl += (double)((Integer)enchantmentWidths.get(i)).intValue();
            }
            xpl = xp - scaledHalfWidth;
            for (i = 0; i < items.size(); ++i) {
                List entries2 = (List)enchantments.get(i);
                TextBounds[] bounds = (TextBounds[])enchantmentBounds.get(i);
                double ypl = yp - scaledHalfHeight;
                double xCenterOffset = (Integer)enchantmentTextWidths.get(i) < 16 ? (double)(16 - (Integer)enchantmentTextWidths.get(i)) / 2.0 : 0.0;
                for (int j = entries2.size() - 1; j >= 0; --j) {
                    EnchantmentEntry e = (EnchantmentEntry)entries2.get(j);
                    TextBounds bound = this.enchFontRenderer.getTextSize(e.text);
                    RenderSystem.setShaderColor((float)((float)e.color.getRed() / 255.0f), (float)((float)e.color.getGreen() / 255.0f), (float)((float)e.color.getBlue() / 255.0f), (float)((float)e.color.getAlpha() / 255.0f));
                    this.enchFontRenderer.drawText(poseStack, e.text, (float)(xpl + xCenterOffset), (float)(ypl -= (double)bounds[j].height() * invScale), invScale);
                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.enchFontRenderer.drawText(poseStack, Integer.toString(e.level), (float)(xpl + (double)bound.width() * invScale + xCenterOffset), (float)ypl, invScale);
                }
                xpl += (double)((Integer)enchantmentWidths.get(i)).intValue();
            }
        }
        poseStack.m_85849_();
    }

    private String getEntityText(EntityEntry entry) {
        Entity entity;
        Object result;
        if (entry.showDefaultNames) {
            result = entry.entity.m_5446_().getString();
        } else {
            Object object = result = entry.entity.m_8077_() || entry.entity instanceof Player ? entry.entity.m_5446_().getString() : "";
        }
        if (entry.showHp && (entity = entry.entity) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            result = (String)result + "\u2665" + (int)living.m_21223_();
        }
        return ((String)result).length() == 0 ? null : result;
    }

    private List<EnchantmentEntry> getEnchantments(ItemStack itemStack) {
        if (!itemStack.m_41793_()) {
            return List.of();
        }
        ArrayList<EnchantmentEntry> enchantments = new ArrayList<EnchantmentEntry>();
        ListTag list = itemStack.m_41785_();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compound = list.m_128728_(i);
            ResourceLocation id = EnchantmentHelper.m_182446_((CompoundTag)compound);
            int level = EnchantmentHelper.m_182438_((CompoundTag)compound);
            enchantments.add(new EnchantmentEntry(id, level));
        }
        enchantments.sort(Comparator.comparingInt(e -> e.priority));
        return enchantments;
    }

    private UUID getOwner(Entity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)entity;
            return animal.m_21805_();
        }
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            return horse.m_21805_();
        }
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            ProjectileAccessor projectileMixin = (ProjectileAccessor)projectile;
            return projectileMixin.getOwnerUUID_CU();
        }
        return null;
    }

    private record EntityEntry(Entity entity, Vec3 position, double distanceSqr, boolean showDefaultNames, boolean showHp, boolean showEquippedItems, boolean showOwner) {
    }

    private static class EnchantmentEntry {
        private static final Map<Enchantment, EnchantmentDisplayEntry> displayMap = Map.ofEntries(Map.entry(Enchantments.f_44965_, new EnchantmentDisplayEntry("Pr")), Map.entry(Enchantments.f_44966_, new EnchantmentDisplayEntry("FP")), Map.entry(Enchantments.f_44968_, new EnchantmentDisplayEntry("BP")), Map.entry(Enchantments.f_44969_, new EnchantmentDisplayEntry("PP")), Map.entry(Enchantments.f_44972_, new EnchantmentDisplayEntry("Th")), Map.entry(Enchantments.f_44967_, new EnchantmentDisplayEntry("Fe")), Map.entry(Enchantments.f_44970_, new EnchantmentDisplayEntry("Re")), Map.entry(Enchantments.f_44971_, new EnchantmentDisplayEntry("Aq")), Map.entry(Enchantments.f_44973_, new EnchantmentDisplayEntry("De")), Map.entry(Enchantments.f_44974_, new EnchantmentDisplayEntry("Fr")), Map.entry(Enchantments.f_44976_, new EnchantmentDisplayEntry("So")), Map.entry(Enchantments.f_220304_, new EnchantmentDisplayEntry("Sn")), Map.entry(Enchantments.f_44977_, new EnchantmentDisplayEntry("Sh")), Map.entry(Enchantments.f_44978_, new EnchantmentDisplayEntry("Sm")), Map.entry(Enchantments.f_44979_, new EnchantmentDisplayEntry("Ar")), Map.entry(Enchantments.f_44981_, new EnchantmentDisplayEntry("Fi")), Map.entry(Enchantments.f_44980_, new EnchantmentDisplayEntry("Kn")), Map.entry(Enchantments.f_44982_, new EnchantmentDisplayEntry("Lo")), Map.entry(Enchantments.f_44983_, new EnchantmentDisplayEntry("Sw")), Map.entry(Enchantments.f_44985_, new EnchantmentDisplayEntry("Si")), Map.entry(Enchantments.f_44987_, new EnchantmentDisplayEntry("Fo")), Map.entry(Enchantments.f_44984_, new EnchantmentDisplayEntry("Ef")), Map.entry(Enchantments.f_44988_, new EnchantmentDisplayEntry("Po")), Map.entry(Enchantments.f_44989_, new EnchantmentDisplayEntry("Pu")), Map.entry(Enchantments.f_44952_, new EnchantmentDisplayEntry("In")), Map.entry(Enchantments.f_44990_, new EnchantmentDisplayEntry("Fl")), Map.entry(Enchantments.f_44953_, new EnchantmentDisplayEntry("Lc")), Map.entry(Enchantments.f_44954_, new EnchantmentDisplayEntry("Lr")), Map.entry(Enchantments.f_44955_, new EnchantmentDisplayEntry("Lo")), Map.entry(Enchantments.f_44956_, new EnchantmentDisplayEntry("Im")), Map.entry(Enchantments.f_44957_, new EnchantmentDisplayEntry("Ri")), Map.entry(Enchantments.f_44958_, new EnchantmentDisplayEntry("Ch")), Map.entry(Enchantments.f_44959_, new EnchantmentDisplayEntry("Mu")), Map.entry(Enchantments.f_44960_, new EnchantmentDisplayEntry("Qu")), Map.entry(Enchantments.f_44961_, new EnchantmentDisplayEntry("Pi")), Map.entry(Enchantments.f_44986_, new EnchantmentDisplayEntry("Un")), Map.entry(Enchantments.f_44962_, new EnchantmentDisplayEntry("Me")), Map.entry(Enchantments.f_44963_, new EnchantmentDisplayEntry("Va", Color.RED)), Map.entry(Enchantments.f_44975_, new EnchantmentDisplayEntry("Bi", Color.RED)));
        public final String text;
        public final int level;
        public final Color color;
        public final int priority;

        public EnchantmentEntry(ResourceLocation id, int level) {
            Enchantment enchantment = Registries.ENCHANTMENTS.getValue(id);
            if (enchantment != null) {
                EnchantmentDisplayEntry entry = displayMap.get(enchantment);
                if (entry != null) {
                    this.text = entry.text;
                    this.color = entry.color;
                    this.priority = entry.priority;
                } else {
                    this.text = id.toString();
                    this.color = Color.YELLOW;
                    this.priority = 100;
                }
            } else {
                this.text = id.toString() + level;
                this.color = Color.YELLOW;
                this.priority = 200;
            }
            this.level = level;
        }
    }

    private record EnchantmentDisplayEntry(String text, Color color, int priority) {
        private static int index;

        public EnchantmentDisplayEntry(String text, Color color) {
            this(text, color, ++index);
        }

        public EnchantmentDisplayEntry(String text) {
            this(text, Color.WHITE, ++index);
        }
    }
}

