/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.EntityTracerConfig;
import com.zergatul.cheatutils.configs.TracerConfigBase;
import com.zergatul.cheatutils.modules.utilities.RenderUtilities;
import com.zergatul.cheatutils.render.LineRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityEspController {
    public static final EntityEspController instance = new EntityEspController();
    private final Minecraft mc = Minecraft.m_91087_();

    private EntityEspController() {
        Events.RenderWorldLast.add(this::render);
    }

    private void render(RenderWorldLastEvent event) {
        if (!ConfigStore.instance.getConfig().esp) {
            return;
        }
        float partialTicks = event.getTickDelta();
        Vec3 view = event.getCamera().m_90583_();
        Vec3 playerPos = event.getPlayerPos();
        double playerX = playerPos.f_82479_;
        double playerY = playerPos.f_82480_;
        double playerZ = playerPos.f_82481_;
        Vec3 tracerCenter = event.getTracerCenter();
        double tracerX = tracerCenter.f_82479_;
        double tracerY = tracerCenter.f_82480_;
        double tracerZ = tracerCenter.f_82481_;
        LineRenderer renderer = RenderUtilities.instance.getLineRenderer();
        renderer.begin(event, false);
        ImmutableList<EntityTracerConfig> list = ConfigStore.instance.getConfig().entities.configs;
        for (Entity entity : this.mc.f_91074_.f_108545_.m_104735_()) {
            if (entity instanceof LocalPlayer || entity.m_213877_()) continue;
            double dx = entity.m_20185_() - playerX;
            double dy = entity.m_20186_() - playerY;
            double dz = entity.m_20189_() - playerZ;
            double distanceSqr = dx * dx + dy * dy + dz * dz;
            EntityTracerConfig config = list.stream().filter(c -> c.enabled && c.drawOutline && c.isValidEntity(entity) && distanceSqr < c.getOutlineMaxDistanceSqr()).findFirst().orElse(null);
            if (config != null) {
                EntityEspController.renderEntityBounding(renderer, partialTicks, entity, config);
            }
            if ((config = (EntityTracerConfig)list.stream().filter(c -> c.enabled && c.drawTracers && c.clazz.isInstance(entity) && distanceSqr < c.getTracerMaxDistanceSqr()).findFirst().orElse(null)) == null) continue;
            EntityEspController.drawTracer(renderer, tracerX, tracerY, tracerZ, entity.m_20318_(event.getTickDelta()), config);
        }
        renderer.end();
    }

    private static void renderEntityBounding(LineRenderer renderer, float partialTicks, Entity entity, EntityTracerConfig config) {
        double rotationYaw = Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
        double sin = Math.sin(rotationYaw / 180.0 * Math.PI);
        double cos = Math.cos(rotationYaw / 180.0 * Math.PI);
        double width = entity.m_20205_() / 2.0f;
        double height = entity.m_20206_();
        Vec3 pos = entity.m_20318_(partialTicks);
        double posX = pos.f_82479_;
        double posY = pos.f_82480_;
        double posZ = pos.f_82481_;
        double p1x = posX + width * (cos - sin);
        double p1z = posZ + width * (sin + cos);
        double p2x = posX + width * (cos + sin);
        double p2z = posZ + width * (sin - cos);
        double p3x = posX + width * (-cos + sin);
        double p3z = posZ - width * (sin + cos);
        double p4x = posX - width * (cos + sin);
        double p4z = posZ + width * (-sin + cos);
        double posY1 = posY;
        double posY2 = posY + height;
        float r = (float)config.outlineColor.getRed() / 255.0f;
        float g = (float)config.outlineColor.getGreen() / 255.0f;
        float b = (float)config.outlineColor.getBlue() / 255.0f;
        renderer.line(p1x, posY1, p1z, p2x, posY1, p2z, r, g, b, 1.0f);
        renderer.line(p2x, posY1, p2z, p3x, posY1, p3z, r, g, b, 1.0f);
        renderer.line(p3x, posY1, p3z, p4x, posY1, p4z, r, g, b, 1.0f);
        renderer.line(p4x, posY1, p4z, p1x, posY1, p1z, r, g, b, 1.0f);
        renderer.line(p1x, posY1, p1z, p1x, posY2, p1z, r, g, b, 1.0f);
        renderer.line(p2x, posY1, p2z, p2x, posY2, p2z, r, g, b, 1.0f);
        renderer.line(p3x, posY1, p3z, p3x, posY2, p3z, r, g, b, 1.0f);
        renderer.line(p4x, posY1, p4z, p4x, posY2, p4z, r, g, b, 1.0f);
        renderer.line(p1x, posY2, p1z, p2x, posY2, p2z, r, g, b, 1.0f);
        renderer.line(p2x, posY2, p2z, p3x, posY2, p3z, r, g, b, 1.0f);
        renderer.line(p3x, posY2, p3z, p4x, posY2, p4z, r, g, b, 1.0f);
        renderer.line(p4x, posY2, p4z, p1x, posY2, p1z, r, g, b, 1.0f);
    }

    private static void drawTracer(LineRenderer renderer, double tx, double ty, double tz, Vec3 pos, TracerConfigBase config) {
        float r = (float)config.tracerColor.getRed() / 255.0f;
        float g = (float)config.tracerColor.getGreen() / 255.0f;
        float b = (float)config.tracerColor.getBlue() / 255.0f;
        renderer.line(tx, ty, tz, pos.f_82479_, pos.f_82480_, pos.f_82481_, r, g, b, 1.0f);
    }
}

