/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.datafixers.util.Pair;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.scripting.api.Root;
import com.zergatul.cheatutils.utils.IntList;
import com.zergatul.cheatutils.utils.JavaRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;

public class EnchantmentScreenController {
    public static final EnchantmentScreenController instance = new EnchantmentScreenController();
    private static final int SCAN_CHUNK_SIZE = 100000;
    private final List<EnchantingState> enchantingStates = new ArrayList<EnchantingState>();
    private final List<EnchantingState> scanningEnchantingStates = new ArrayList<EnchantingState>();
    private Thread[] threads;
    private volatile AtomicLong progress = new AtomicLong();
    private IntList seeds;
    private Integer lastEnchSeed;
    private Integer currEnchSeed;
    private Long playerSeed;
    private volatile boolean cancel;
    private volatile long scanFrom;
    private volatile long scanTo;
    private IntList[] threadSeeds;
    private int lastUsedThreads = 2;

    private EnchantmentScreenController() {
    }

    public void addState(ItemStack itemStack, int enchantPowerBonus, int[] costs, int[] enchantments, int[] levels) {
        EnchantingState state = new EnchantingState();
        state.itemStack = itemStack.m_41777_();
        state.enchantPowerBonus = enchantPowerBonus;
        state.costs = (int[])costs.clone();
        state.enchantments = (int[])enchantments.clone();
        state.levels = (int[])levels.clone();
        this.enchantingStates.add(state);
    }

    public void reset() {
        if (this.threads != null) {
            this.cancel = true;
            for (Thread thread : this.threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.threads = null;
            this.threadSeeds = null;
            this.cancel = false;
        }
        this.enchantingStates.clear();
        this.seeds = null;
        this.lastEnchSeed = null;
        this.currEnchSeed = null;
        this.playerSeed = null;
    }

    public int getDataCount() {
        return this.enchantingStates.size();
    }

    public long getSeedsCount() {
        if (this.seeds == null) {
            return 0x100000000L;
        }
        return this.seeds.count();
    }

    public boolean isFilterInProgress() {
        return this.threads != null;
    }

    public double getProgress() {
        return 1.0 * (double)this.progress.get() / (double)this.getSeedsCount();
    }

    public long getNewSeedsCount() {
        if (this.threadSeeds == null) {
            return 0L;
        }
        IntList[] copy = this.threadSeeds;
        long count = 0L;
        for (int i = 0; i < copy.length; ++i) {
            if (copy[i] == null) continue;
            count += (long)copy[i].count();
        }
        return count;
    }

    public void scan(int threads) {
        this.lastUsedThreads = threads;
        if (this.threads != null) {
            return;
        }
        this.scanningEnchantingStates.clear();
        this.scanningEnchantingStates.addAll(this.enchantingStates);
        this.enchantingStates.clear();
        if (this.seeds == null) {
            this.scanFrom = 0L;
            this.scanTo = 0x100000000L;
        } else {
            this.scanFrom = 0L;
            this.scanTo = this.seeds.count();
        }
        if ((this.scanTo + 100000L - 1L) / 100000L < (long)threads && (threads = (int)((this.scanTo + 100000L - 1L) / 100000L)) == 0) {
            threads = 1;
        }
        this.threads = new Thread[threads];
        this.threadSeeds = new IntList[threads];
        this.progress.set(0L);
        for (int i = 0; i < threads; ++i) {
            int index = i;
            this.threads[i] = new Thread(() -> this.scanEnchantingSeeds(index));
            this.threads[i].start();
        }
    }

    public String getSingleSeed() {
        if (this.seeds != null && this.seeds.count() == 1) {
            return Integer.toHexString(this.seeds.get(0));
        }
        return null;
    }

    public void setLastEnchSeed() {
        if (this.seeds != null && this.seeds.count() == 1) {
            this.lastEnchSeed = this.seeds.get(0);
            this.seeds = null;
            this.enchantingStates.clear();
        }
    }

    public void setCurrEnchSeed() {
        if (this.seeds != null && this.seeds.count() == 1) {
            this.currEnchSeed = this.seeds.get(0);
            this.seeds = null;
            this.enchantingStates.clear();
        }
    }

    public Integer getLastEnchSeed() {
        return this.lastEnchSeed;
    }

    public Integer getCurrEnchSeed() {
        return this.currEnchSeed;
    }

    public void crackPlayerSeed() {
        if (this.lastEnchSeed == null || this.currEnchSeed == null) {
            return;
        }
        this.playerSeed = null;
        long seed1High = (long)this.lastEnchSeed.intValue() << 16 & 0xFFFFFFFF0000L;
        long seed2High = (long)this.currEnchSeed.intValue() << 16 & 0xFFFFFFFF0000L;
        for (int seed1Low = 0; seed1Low < 65536; ++seed1Low) {
            if (((seed1High | (long)seed1Low) * 25214903917L + 11L & 0xFFFFFFFF0000L) != seed2High) continue;
            this.playerSeed = (seed1High | (long)seed1Low) * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            break;
        }
    }

    public Long getPlayerSeed() {
        return this.playerSeed;
    }

    public int getLastUsedThreads() {
        return this.lastUsedThreads;
    }

    public void findDrops() {
        if (this.playerSeed == null) {
            return;
        }
        JavaRandom random = new JavaRandom(this.playerSeed);
        for (int drops = 0; drops < 1; ++drops) {
            random.m_64707_(32);
            random.m_64707_(32);
            random.m_64707_(32);
            random.m_64707_(32);
        }
        int seed = random.m_64707_(32);
        this.isSeedGood(seed);
    }

    private int isSeedGood(int seed) {
        List<EnchantmentInstance> list;
        int cost2;
        int cost1;
        RandomSource mcRandom = RandomSource.m_216327_();
        mcRandom.m_188584_((long)seed);
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42388_, 1);
        int enchantPowerBonus = 15;
        int cost0 = EnchantmentHelper.m_220287_((RandomSource)mcRandom, (int)0, (int)enchantPowerBonus, (ItemStack)itemStack);
        if (cost0 < 1) {
            cost0 = 0;
        }
        if ((cost1 = EnchantmentHelper.m_220287_((RandomSource)mcRandom, (int)1, (int)enchantPowerBonus, (ItemStack)itemStack)) < 2) {
            cost1 = 0;
        }
        if ((cost2 = EnchantmentHelper.m_220287_((RandomSource)mcRandom, (int)2, (int)enchantPowerBonus, (ItemStack)itemStack)) < 3) {
            cost2 = 0;
        }
        if (cost0 > 0) {
            list = this.getEnchantmentList(mcRandom, seed, itemStack, 0, cost0);
        }
        if (cost1 > 0) {
            list = this.getEnchantmentList(mcRandom, seed, itemStack, 1, cost1);
        }
        if (cost2 > 0) {
            List<EnchantmentInstance> list2 = this.getEnchantmentList(mcRandom, seed, itemStack, 2, cost2);
            for (EnchantmentInstance ei : list2) {
                ResourceLocation id = Registries.ENCHANTMENTS.getKey(ei.f_44947_);
                Root.main.systemMessage(id.toString() + " - " + ei.f_44948_);
            }
            return list2.size();
        }
        return 0;
    }

    private synchronized Pair<Long, Long> getNextScanChunk() {
        if (this.scanFrom < this.scanTo) {
            long from = this.scanFrom;
            long to = from + 100000L;
            if (to > this.scanTo) {
                to = this.scanTo;
            }
            this.scanFrom = to;
            return new Pair((Object)from, (Object)to);
        }
        return null;
    }

    private void scanEnchantingSeeds(int index) {
        Pair<Long, Long> chunk;
        IntList newSeeds;
        this.threadSeeds[index] = newSeeds = new IntList(256);
        RandomSource random = RandomSource.m_216327_();
        while ((chunk = this.getNextScanChunk()) != null) {
            int seed;
            long i;
            long from = (Long)chunk.getFirst();
            long to = (Long)chunk.getSecond();
            long lastProgress = from;
            if (this.seeds == null) {
                for (i = from; i < to; ++i) {
                    if (i % 1000L == 0L) {
                        this.progress.addAndGet(i - lastProgress);
                        lastProgress = i;
                        if (this.cancel) {
                            return;
                        }
                    }
                    if (!this.checkSeed(random, seed = (int)(Integer.MIN_VALUE + i))) continue;
                    newSeeds.add(seed);
                }
                continue;
            }
            for (i = from; i < to; ++i) {
                if (i % 1000L == 0L) {
                    this.progress.addAndGet(i - lastProgress);
                    lastProgress = i;
                    if (this.cancel) {
                        return;
                    }
                }
                if (!this.checkSeed(random, seed = this.seeds.get((int)i))) continue;
                newSeeds.add(seed);
            }
        }
        this.threads[index] = null;
        this.mergeThreads();
    }

    private synchronized void mergeThreads() {
        for (Thread thread : this.threads) {
            if (thread == null) continue;
            return;
        }
        this.seeds = new IntList(256);
        for (IntList list : this.threadSeeds) {
            for (int i = 0; i < list.count(); ++i) {
                this.seeds.add(list.get(i));
            }
        }
        this.threads = null;
        this.threadSeeds = null;
    }

    private boolean checkSeed(RandomSource random, int seed) {
        return true;
    }

    private List<EnchantmentInstance> getEnchantmentList(RandomSource random, int seed, ItemStack itemStack, int index, int cost) {
        random.m_188584_((long)(seed + index));
        List list = EnchantmentHelper.m_220297_((RandomSource)random, (ItemStack)itemStack, (int)cost, (boolean)false);
        if (itemStack.m_150930_(Items.f_42517_) && list.size() > 1) {
            list.remove(random.m_188503_(list.size()));
        }
        return list;
    }

    private static class EnchantingState {
        public ItemStack itemStack;
        public int enchantPowerBonus;
        public int[] costs;
        public int[] enchantments;
        public int[] levels;

        private EnchantingState() {
        }
    }
}

