/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.configs.ConfigStore;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.ArrayUtils;

public class CoordinatesLeakProtectionController {
    public static final CoordinatesLeakProtectionController instance = new CoordinatesLeakProtectionController();
    private final Random random = new Random();

    private CoordinatesLeakProtectionController() {
    }

    public void processChunk(LevelChunk chunk) {
        if (ConfigStore.instance.getConfig().coordinateLeakProtectionConfig.enabled) {
            this.messUpBedrock(chunk);
        }
    }

    private void messUpBedrock(LevelChunk chunk) {
        int y;
        BlockState[] col;
        int z;
        int x;
        BlockState[][] cols = new BlockState[256][];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (x = 0; x < 16; ++x) {
            pos.m_142451_(x);
            for (z = 0; z < 16; ++z) {
                pos.m_142443_(z);
                col = new BlockState[5];
                cols[x << 4 | z] = col;
                for (y = -64; y <= -60; ++y) {
                    pos.m_142448_(y);
                    col[y + 64] = chunk.m_8055_((BlockPos)pos);
                }
            }
        }
        ArrayUtils.shuffle((Object[])cols, (Random)this.random);
        for (x = 0; x < 16; ++x) {
            pos.m_142451_(x);
            for (z = 0; z < 16; ++z) {
                pos.m_142443_(z);
                col = cols[x << 4 | z];
                for (y = -64; y <= -60; ++y) {
                    pos.m_142448_(y);
                    chunk.m_6978_((BlockPos)pos, col[y + 64], false);
                }
            }
        }
    }
}

