/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.render.ItemRenderHelper;
import com.zergatul.cheatutils.render.Primitives;
import com.zergatul.cheatutils.utils.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ContainerSummaryController {
    public static final ContainerSummaryController instance = new ContainerSummaryController();

    private ContainerSummaryController() {
    }

    public List<ItemDrawable> groupItems(List<ItemStack> items) {
        HashMap<Item, ItemDrawable> map = new HashMap<Item, ItemDrawable>();
        for (ItemStack itemStack : items) {
            this.addItem(map, itemStack);
            if (!ItemUtils.isShulkerBox(itemStack)) continue;
            for (ItemStack slot : ItemUtils.getShulkerContent(itemStack)) {
                if (slot.m_41619_()) continue;
                this.addItem(map, slot);
            }
        }
        return map.values().stream().sorted((i1, i2) -> {
            int compare = -Integer.compare(i1.count, i2.count);
            if (compare != 0) {
                return compare;
            }
            String id1 = Registries.ITEMS.getKey(i1.item).toString();
            String id2 = Registries.ITEMS.getKey(i2.item).toString();
            return id1.compareTo(id2);
        }).collect(Collectors.toList());
    }

    public List<ItemsColumn> split(List<ItemDrawable> items) {
        ArrayList<ItemsColumn> columns = new ArrayList<ItemsColumn>();
        for (int i = 0; i < items.size(); ++i) {
            if (columns.size() == 0 || ((ItemsColumn)columns.get((int)(columns.size() - 1))).list.size() == 10) {
                columns.add(new ItemsColumn());
            }
            ((ItemsColumn)columns.get((int)(columns.size() - 1))).list.add(items.get(i));
        }
        return columns;
    }

    private void addItem(Map<Item, ItemDrawable> map, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        int count = itemStack.m_41613_();
        ItemDrawable drawable = map.get(item);
        if (drawable == null) {
            drawable = new ItemDrawable(item);
        }
        drawable.count += count;
        map.put(item, drawable);
    }

    public static class ItemsColumn {
        private static final int MAX_ROWS = 10;
        private static final int H_PADDING = 2;
        private static final ResourceLocation CONTAINER_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
        public List<ItemDrawable> list = new ArrayList<ItemDrawable>();
        public int width;

        public void calculateWidth() {
            this.width = 0;
            for (ItemDrawable drawable : this.list) {
                if (drawable.width <= this.width) continue;
                this.width = drawable.width;
            }
        }

        public int draw(GuiGraphics graphics, Font font, ItemRenderer itemRenderer, LocalPlayer player, int x, int y) {
            int yo = y;
            int fullWidth = this.width + 4;
            Primitives.fill(graphics.m_280168_(), x, y, x + fullWidth, y + 19 * this.list.size(), -1873784752);
            for (ItemDrawable drawable : this.list) {
                y += drawable.draw(graphics, font, itemRenderer, player, x + (this.width - drawable.width) / 2 + 2, y + 2);
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONTAINER_TEXTURE);
            Primitives.drawTexture(graphics.m_280168_().m_85850_().m_252922_(), x, yo, 1.0f, 19 * this.list.size() + 1, 124.0f, 3, 3, 1, 1, 256, 256);
            Primitives.drawTexture(graphics.m_280168_().m_85850_().m_252922_(), x + fullWidth, yo, 1.0f, 19 * this.list.size() + 1, 124.0f, 3, 3, 1, 1, 256, 256);
            for (int i = 0; i <= this.list.size(); ++i) {
                Primitives.drawTexture(graphics.m_280168_().m_85850_().m_252922_(), x, yo + 19 * i, fullWidth, 1.0f, 124.0f, 3, 3, 1, 1, 256, 256);
            }
            return fullWidth;
        }
    }

    public static class ItemDrawable {
        private static final int ITEM_PADDING = 4;
        private static final int HEIGHT = 19;
        public Item item;
        public int count;
        public int width;
        private int stackSize;
        private int stacksCount;
        private int remCount;

        public ItemDrawable(Item item) {
            this.item = item;
            this.count = 0;
        }

        public ItemDrawable add(int value) {
            this.count += value;
            return this;
        }

        public void initDraw(Font font, boolean group) {
            this.stackSize = group ? ItemUtils.getStackSize(this.item) : 1;
            this.stacksCount = this.count / this.stackSize;
            this.remCount = this.count % this.stackSize;
            this.width = 0;
            if (this.stacksCount > 0) {
                if (this.stacksCount > 1) {
                    this.width += font.m_92895_(this.stacksCount + "x");
                }
                this.width += 16;
                if (this.remCount > 0) {
                    this.width += 4;
                }
            }
            if (this.remCount > 0) {
                if (this.stacksCount > 0) {
                    this.width += font.m_92895_("+");
                }
                this.width += 16;
            }
        }

        public int draw(GuiGraphics graphics, Font font, ItemRenderer itemRenderer, LocalPlayer player, int x, int y) {
            ItemStack stack;
            Objects.requireNonNull(font);
            int fy = y + 19 - 9 - 2;
            if (this.stacksCount > 0) {
                if (this.stacksCount > 1) {
                    graphics.m_280488_(font, this.stacksCount + "x", x, fy, 0xFFFFFF);
                    x += font.m_92895_(this.stacksCount + "x");
                }
                stack = new ItemStack((ItemLike)this.item, this.stackSize);
                ItemRenderHelper.renderItem(graphics, stack, x, y);
                x += 20;
                if (this.remCount > 0) {
                    graphics.m_280488_(font, "+", x, fy, 0xFFFFFF);
                    x += font.m_92895_("+");
                }
            }
            if (this.remCount > 0) {
                stack = new ItemStack((ItemLike)this.item, this.remCount);
                ItemRenderHelper.renderItem(graphics, stack, x, y);
            }
            return 19;
        }
    }
}

