/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ContainerButtonsConfig;
import com.zergatul.cheatutils.utils.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ContainerButtonsController {
    public static ContainerButtonsController instance = new ContainerButtonsController();
    private final Minecraft mc = Minecraft.m_91087_();

    private ContainerButtonsController() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
    }

    public boolean isValidScreen(Screen screen) {
        if (screen == null) {
            return false;
        }
        if (!(screen instanceof AbstractContainerScreen)) {
            return false;
        }
        if (screen instanceof EnchantmentScreen) {
            return false;
        }
        if (screen instanceof InventoryScreen) {
            return false;
        }
        return !(screen instanceof CreativeModeInventoryScreen);
    }

    public void dropAll(boolean autoClose) {
        if (!this.isValidScreen(this.mc.f_91080_)) {
            return;
        }
        Screen screen = this.mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            ContainerButtonsConfig config = this.getConfig();
            NonNullList slots = screen2.m_6262_().f_38839_;
            if (slots.size() > 0) {
                if (this.mc.f_91072_ == null || this.mc.f_91074_ == null) {
                    return;
                }
                Container container = ((Slot)slots.get((int)0)).f_40218_;
                for (int i = 0; i < slots.size(); ++i) {
                    Slot slot = (Slot)slots.get(i);
                    if (slot.f_40218_ != container) break;
                    if (slot.m_7993_().m_41619_() || config.useFilter && !config.items.contains(slot.m_7993_().m_41720_())) continue;
                    this.mc.f_91072_.m_171799_(screen2.m_6262_().f_38840_, i, 1, ClickType.THROW, (Player)this.mc.f_91074_);
                }
                if (autoClose) {
                    screen2.m_7379_();
                }
            }
        }
    }

    public void takeAll(boolean autoClose) {
        if (!this.isValidScreen(this.mc.f_91080_)) {
            return;
        }
        Screen screen = this.mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            ContainerButtonsConfig config = this.getConfig();
            NonNullList slots = screen2.m_6262_().f_38839_;
            if (slots.size() > 0) {
                if (this.mc.f_91072_ == null || this.mc.f_91074_ == null) {
                    return;
                }
                Container container = ((Slot)slots.get((int)0)).f_40218_;
                for (int i = 0; i < slots.size(); ++i) {
                    Slot slot = (Slot)slots.get(i);
                    if (slot.f_40218_ != container) break;
                    if (slot.m_7993_().m_41619_() || config.useFilter && !config.items.contains(slot.m_7993_().m_41720_())) continue;
                    this.mc.f_91072_.m_171799_(screen2.m_6262_().f_38840_, i, 0, ClickType.QUICK_MOVE, (Player)this.mc.f_91074_);
                }
                if (autoClose) {
                    screen2.m_7379_();
                }
            }
        }
    }

    public void smartPut() {
        if (!this.isValidScreen(this.mc.f_91080_)) {
            return;
        }
        Screen screen = this.mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            boolean checkShulkerContent = ConfigStore.instance.getConfig().containerButtonsConfig.checkShulkerContent;
            NonNullList slots = screen2.m_6262_().f_38839_;
            if (slots.size() > 0) {
                if (this.mc.f_91072_ == null || this.mc.f_91074_ == null) {
                    return;
                }
                Container container = ((Slot)slots.get((int)0)).f_40218_;
                ArrayList<Item> containerItems = new ArrayList<Item>();
                HashMap shulkers = new HashMap();
                for (int i = 0; i < slots.size(); ++i) {
                    Slot slot = (Slot)slots.get(i);
                    if (slot.m_7993_().m_41619_()) continue;
                    ItemStack itemStack = slot.m_7993_();
                    Item item = itemStack.m_41720_();
                    if (slot.f_40218_ == container) {
                        if (checkShulkerContent && ItemUtils.isShulkerBox(itemStack)) {
                            if (!shulkers.containsKey(item)) {
                                shulkers.put(item, new ArrayList());
                            }
                            ((List)shulkers.get(item)).add(ItemUtils.getShulkerContent(itemStack));
                            continue;
                        }
                        if (containerItems.contains(item)) continue;
                        containerItems.add(item);
                        continue;
                    }
                    if (checkShulkerContent && ItemUtils.isShulkerBox(itemStack)) {
                        if (!shulkers.containsKey(item)) continue;
                        NonNullList<ItemStack> current = ItemUtils.getShulkerContent(itemStack);
                        boolean sameShulker = false;
                        for (NonNullList existing : (List)shulkers.get(item)) {
                            if (existing.size() != current.size()) continue;
                            boolean sameItems = true;
                            for (int j = 0; j < current.size(); ++j) {
                                ItemStack itemStack1 = (ItemStack)existing.get(j);
                                ItemStack itemStack2 = (ItemStack)current.get(j);
                                if (itemStack1.m_41619_() && itemStack2.m_41619_()) continue;
                                if (!ItemStack.m_150942_((ItemStack)itemStack1, (ItemStack)itemStack2)) {
                                    sameItems = false;
                                    break;
                                }
                                if (itemStack1.m_41613_() == itemStack2.m_41613_()) continue;
                                sameItems = false;
                                break;
                            }
                            if (!sameItems) continue;
                            sameShulker = true;
                            break;
                        }
                        if (!sameShulker) continue;
                        this.mc.f_91072_.m_171799_(screen2.m_6262_().f_38840_, i, 0, ClickType.QUICK_MOVE, (Player)this.mc.f_91074_);
                        continue;
                    }
                    if (!containerItems.contains(item)) continue;
                    this.mc.f_91072_.m_171799_(screen2.m_6262_().f_38840_, i, 0, ClickType.QUICK_MOVE, (Player)this.mc.f_91074_);
                }
            }
        }
    }

    private void onClientTickEnd() {
        ContainerButtonsConfig config = this.getConfig();
        if (config.autoTakeAll || config.autoDropAll) {
            if (!this.isValidScreen(this.mc.f_91080_)) {
                return;
            }
            if (config.autoTakeAll) {
                this.takeAll(config.autoClose);
            } else if (config.autoDropAll) {
                this.dropAll(config.autoClose);
            }
        }
    }

    private ContainerButtonsConfig getConfig() {
        return ConfigStore.instance.getConfig().containerButtonsConfig;
    }
}

