/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.common.Events;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;

public class ClientTickController {
    public static final ClientTickController instance = new ClientTickController();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();

    private ClientTickController() {
        Events.ClientTickEnd.add(this::onClientTickEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getResult(Supplier<T> supplier, int timeout) {
        if (this.mc.f_91073_ == null) {
            return null;
        }
        SupplierQueueItem item = new SupplierQueueItem(supplier);
        this.queue.add(item);
        try {
            SupplierQueueItem supplierQueueItem = item;
            synchronized (supplierQueueItem) {
                item.wait(timeout);
            }
            return item.getResult();
        }
        catch (InterruptedException e) {
            this.queue.removeIf(i -> i == item);
            return null;
        }
    }

    public void run(Runnable runnable) {
        this.queue.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClientTickEnd() {
        while (this.queue.size() > 0) {
            Runnable item = this.queue.poll();
            item.run();
            Runnable runnable = item;
            synchronized (runnable) {
                item.notify();
            }
        }
    }

    private static class SupplierQueueItem<T>
    implements Runnable {
        private final Supplier<T> supplier;
        private volatile boolean finished;
        private volatile T result;

        public SupplierQueueItem(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public T getResult() {
            return this.result;
        }

        @Override
        public void run() {
            this.result = this.supplier.get();
            this.finished = true;
        }
    }
}

