/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zergatul.cheatutils.chunkoverlays.AbstractChunkOverlay;
import com.zergatul.cheatutils.chunkoverlays.ExplorationMiniMapChunkOverlay;
import com.zergatul.cheatutils.chunkoverlays.NewChunksOverlay;
import com.zergatul.cheatutils.chunkoverlays.WorldDownloadChunkOverlay;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.common.events.MouseScrollEvent;
import com.zergatul.cheatutils.common.events.PreRenderGuiOverlayEvent;
import com.zergatul.cheatutils.common.events.RenderGuiEvent;
import com.zergatul.cheatutils.interfaces.LevelChunkMixinInterface;
import com.zergatul.cheatutils.render.Primitives;
import com.zergatul.cheatutils.utils.Dimension;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.LevelChunk;
import org.joml.Quaternionf;

public class ChunkOverlayController {
    public static final ChunkOverlayController instance = new ChunkOverlayController();
    private static final int SegmentSize = 16;
    private static final long UpdateDelay = 250000000L;
    private static final int TranslateZ = 250;
    private static final float MinScale = 16.0f;
    private static final float MaxScale = 512.0f;
    private static final float ScaleStep = 1.3f;
    private final Minecraft mc = Minecraft.m_91087_();
    private final List<AbstractChunkOverlay> overlays = new ArrayList<AbstractChunkOverlay>();
    private float scale = 256.0f;

    private ChunkOverlayController() {
        this.register(new ExplorationMiniMapChunkOverlay(16, 250000000L));
        this.register(new NewChunksOverlay(16, 250000000L));
        this.register(new WorldDownloadChunkOverlay(16, 250000000L));
        Events.ScannerChunkLoaded.add(this::onChunkLoaded);
        Events.ScannerBlockUpdated.add(this::onBlockChanged);
        Events.ClientTickEnd.add(this::onClientTickEnd);
        Events.PostRenderGui.add(this::render);
        Events.PreRenderGuiOverlay.add(this::onPreRenderGameOverlay);
        Events.MouseScroll.add(this::onMouseScroll);
    }

    public <T extends AbstractChunkOverlay> T ofType(Class<T> clazz) {
        return (T)((AbstractChunkOverlay)this.overlays.stream().filter(o -> o.getClass() == clazz).findFirst().orElse(null));
    }

    private void render(RenderGuiEvent event) {
        if (!this.isSomeOverlayEnabled()) {
            return;
        }
        for (AbstractChunkOverlay overlay : this.overlays) {
            overlay.onPreRender();
        }
        if (!this.mc.f_91066_.f_92099_.m_90857_()) {
            return;
        }
        if (Screen.m_96639_()) {
            return;
        }
        if (this.mc.f_91074_ == null || this.mc.f_91073_ == null) {
            return;
        }
        float frameTime = event.getTickDelta();
        float xp = (float)Mth.m_14139_((double)frameTime, (double)this.mc.f_91074_.f_19854_, (double)this.mc.f_91074_.m_20185_());
        float zp = (float)Mth.m_14139_((double)frameTime, (double)this.mc.f_91074_.f_19856_, (double)this.mc.f_91074_.m_20189_());
        float xc = (float)this.mc.f_91063_.m_109153_().m_90583_().f_82479_;
        float zc = (float)this.mc.f_91063_.m_109153_().m_90583_().f_82481_;
        float yRot = this.mc.f_91063_.m_109153_().m_90590_();
        PoseStack poseStack = event.getGuiGraphics().m_280168_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        poseStack.m_85837_(1.0 * (double)this.mc.m_91268_().m_85445_() / 2.0, 1.0 * (double)this.mc.m_91268_().m_85446_() / 2.0, 250.0);
        Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quaternion.rotationYXZ((float)(-Math.PI), (float)(-Math.PI), -yRot * ((float)Math.PI / 180));
        poseStack.m_252781_(quaternion);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float multiplier = 0.00390625f * this.scale;
        Dimension dimension = Dimension.get(this.mc.f_91073_);
        for (AbstractChunkOverlay overlay : this.overlays) {
            int z = overlay.getTranslateZ();
            for (AbstractChunkOverlay.Segment segment : overlay.getSegments(dimension)) {
                if (segment.texture == null) continue;
                RenderSystem.setShaderTexture((int)0, (int)segment.texture.m_117963_());
                float x = ((float)(segment.pos.x * 16 * 16) - xc) * multiplier;
                float y = ((float)(segment.pos.z * 16 * 16) - zc) * multiplier;
                Primitives.drawTexture(poseStack.m_85850_().m_252922_(), x, y, this.scale, this.scale, z, 0, 0, 256, 256, 256, 256);
            }
        }
        for (AbstractChunkOverlay overlay : this.overlays) {
            overlay.onPostDrawSegments(dimension, poseStack, xp, zp, xc, zc, multiplier);
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private void onPreRenderGameOverlay(PreRenderGuiOverlayEvent event) {
        if (event.getGuiOverlayType() == PreRenderGuiOverlayEvent.GuiOverlayType.PLAYER_LIST) {
            if (!this.isSomeOverlayEnabled()) {
                return;
            }
            if (Screen.m_96639_()) {
                return;
            }
            event.cancel();
        }
    }

    private void onMouseScroll(MouseScrollEvent event) {
        if (!this.isSomeOverlayEnabled()) {
            return;
        }
        if (!this.mc.f_91066_.f_92099_.m_90857_()) {
            return;
        }
        event.cancel();
        if (event.getScrollDelta() >= 1.0 && this.scale < 512.0f) {
            this.scale *= 1.3f;
        }
        if (event.getScrollDelta() <= -1.0 && this.scale > 16.0f) {
            this.scale /= 1.3f;
        }
    }

    private void register(AbstractChunkOverlay overlay) {
        this.overlays.add(overlay);
    }

    private void onChunkLoaded(LevelChunk chunk) {
        Dimension dimension = ((LevelChunkMixinInterface)chunk).getDimension();
        for (AbstractChunkOverlay overlay : this.overlays) {
            overlay.onChunkLoaded(dimension, chunk);
        }
    }

    private void onBlockChanged(BlockUpdateEvent event) {
        Dimension dimension = ((LevelChunkMixinInterface)event.chunk()).getDimension();
        for (AbstractChunkOverlay overlay : this.overlays) {
            overlay.onBlockChanged(dimension, event.pos(), event.state());
        }
    }

    private void onClientTickEnd() {
        for (AbstractChunkOverlay overlay : this.overlays) {
            overlay.onClientTickEnd();
        }
    }

    private boolean isSomeOverlayEnabled() {
        return this.overlays.stream().anyMatch(AbstractChunkOverlay::isEnabled);
    }
}

