/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.datafixers.util.Pair;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.configs.ChunksConfig;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import com.zergatul.cheatutils.mixins.common.accessors.ClientPacketListenerAccessor;
import com.zergatul.cheatutils.utils.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkController {
    public static final ChunkController instance = new ChunkController();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Logger logger = LogManager.getLogger(ChunkController.class);
    private final Map<Long, Pair<Dimension, LevelChunk>> loadedChunks = new HashMap<Long, Pair<Dimension, LevelChunk>>();
    private final Map<Long, ChunkEntry> chunksMap = new HashMap<Long, ChunkEntry>();
    private final List<ChunkPos> serverUnloadedChunks = new ArrayList<ChunkPos>();

    private ChunkController() {
        Events.ChunkLoaded.add(this::onChunkLoaded);
        Events.ChunkUnloaded.add(this::onChunkUnloaded);
        Events.ClientTickStart.add(this::onClientTickStart);
        Events.ClientPlayerLoggingOut.add(this::onPlayerLoggingOut);
        NetworkPacketsController.instance.addServerPacketHandler(this::onServerPacket);
    }

    public synchronized List<Pair<Dimension, LevelChunk>> getLoadedChunks() {
        return new ArrayList<Pair<Dimension, LevelChunk>>(this.loadedChunks.values());
    }

    public synchronized int getLoadedChunksCount() {
        return this.loadedChunks.size();
    }

    public synchronized void clear() {
        this.loadedChunks.clear();
    }

    private synchronized void onChunkLoaded() {
        this.syncChunks();
    }

    private synchronized void onChunkUnloaded() {
        this.syncChunks();
    }

    private synchronized void onClientTickStart() {
        if (this.mc.f_91073_ == null) {
            return;
        }
        ClientChunkCache cache = this.mc.f_91073_.m_7726_();
        if (this.mc.f_91074_ == null) {
            this.serverUnloadedChunks.forEach(p -> cache.m_104455_(p.f_45578_, p.f_45579_));
            this.serverUnloadedChunks.clear();
            return;
        }
        ChunkPos playerPos = this.mc.f_91074_.m_146902_();
        long renderDistance2 = this.mc.f_91066_.m_193772_();
        renderDistance2 *= renderDistance2;
        for (int i = 0; i < this.serverUnloadedChunks.size(); ++i) {
            ChunkPos chunkPos = this.serverUnloadedChunks.get(i);
            long dx = chunkPos.f_45578_ - playerPos.f_45578_;
            long dz = chunkPos.f_45579_ - playerPos.f_45579_;
            long d2 = dx * dx + dz * dz;
            if (d2 <= renderDistance2) continue;
            this.serverUnloadedChunks.remove(i);
            --i;
            ((ClientPacketListener)this.mc.f_91074_.f_108617_.m_104910_().m_129538_()).m_5729_(new ClientboundForgetLevelChunkPacket(chunkPos.f_45578_, chunkPos.f_45579_));
        }
    }

    private synchronized void onPlayerLoggingOut() {
        this.clear();
    }

    public synchronized void syncChunks() {
        if (this.mc.f_91073_ == null) {
            this.clear();
            return;
        }
        LocalPlayer player = this.mc.f_91074_;
        if (player == null) {
            this.clear();
            return;
        }
        Dimension dimension = Dimension.get(this.mc.f_91073_);
        this.chunksMap.clear();
        for (Pair<Dimension, LevelChunk> pair : this.loadedChunks.values()) {
            LevelChunk chunk = (LevelChunk)pair.getSecond();
            this.chunksMap.put(chunk.m_7697_().m_45588_(), new ChunkEntry(chunk));
        }
        this.loadedChunks.clear();
        ClientPacketListenerAccessor listener = (ClientPacketListenerAccessor)player.f_108617_;
        int storageRange = Math.max(2, listener.getServerChunkRadius_CU()) + 3;
        ChunkPos chunkPos = player.m_146902_();
        for (int dx = -storageRange; dx <= storageRange; ++dx) {
            for (int dz = -storageRange; dz <= storageRange; ++dz) {
                LevelChunk chunk = this.mc.f_91073_.m_7726_().m_62227_(chunkPos.f_45578_ + dx, chunkPos.f_45579_ + dz, false);
                if (chunk == null) continue;
                long pos = chunk.m_7697_().m_45588_();
                ChunkEntry entry = this.chunksMap.get(pos);
                if (entry != null) {
                    if (entry.chunk == chunk) {
                        entry.exists = true;
                        this.loadedChunks.put(pos, (Pair<Dimension, LevelChunk>)new Pair((Object)dimension, (Object)chunk));
                        continue;
                    }
                    Events.SmartChunkUnloaded.trigger(entry.chunk);
                    this.loadedChunks.put(pos, (Pair<Dimension, LevelChunk>)new Pair((Object)dimension, (Object)chunk));
                    Events.SmartChunkLoaded.trigger(chunk);
                    continue;
                }
                this.loadedChunks.put(pos, (Pair<Dimension, LevelChunk>)new Pair((Object)dimension, (Object)chunk));
                Events.SmartChunkLoaded.trigger(chunk);
            }
        }
        for (ChunkEntry entry : this.chunksMap.values()) {
            if (entry.exists) continue;
            Events.SmartChunkUnloaded.trigger(entry.chunk);
        }
    }

    private void onServerPacket(NetworkPacketsController.ServerPacketArgs args) {
        ClientboundBlockUpdatePacket packet;
        Packet<?> packet2 = args.packet;
        if (packet2 instanceof ClientboundBlockUpdatePacket) {
            packet = (ClientboundBlockUpdatePacket)packet2;
            this.processBlockUpdatePacket(packet);
        }
        if ((packet2 = args.packet) instanceof ClientboundSectionBlocksUpdatePacket) {
            packet = (ClientboundSectionBlocksUpdatePacket)packet2;
            this.processSectionBlocksUpdatePacket((ClientboundSectionBlocksUpdatePacket)packet);
        }
        if ((packet2 = args.packet) instanceof ClientboundForgetLevelChunkPacket && this.processForgetLevelChunkPacket((ClientboundForgetLevelChunkPacket)(packet = (ClientboundForgetLevelChunkPacket)packet2))) {
            args.skip = true;
        }
    }

    private synchronized void processBlockUpdatePacket(ClientboundBlockUpdatePacket packet) {
        LevelChunk chunk = this.getChunkByPos(packet.m_131749_());
        if (chunk != null) {
            Events.BlockUpdated.trigger(new BlockUpdateEvent(chunk, packet.m_131749_(), packet.m_131746_()));
        }
    }

    private synchronized void processSectionBlocksUpdatePacket(ClientboundSectionBlocksUpdatePacket packet) {
        packet.m_132992_((pos$mutable, state) -> {
            LevelChunk chunk = this.getChunkByPos((BlockPos)pos$mutable);
            if (chunk != null) {
                BlockPos pos = new BlockPos(pos$mutable.m_123341_(), pos$mutable.m_123342_(), pos$mutable.m_123343_());
                Events.BlockUpdated.trigger(new BlockUpdateEvent(chunk, pos, (BlockState)state));
            }
        });
    }

    private synchronized boolean processForgetLevelChunkPacket(ClientboundForgetLevelChunkPacket packet) {
        ChunksConfig config = ConfigStore.instance.getConfig().chunksConfig;
        if (config.dontUnloadChunks) {
            this.serverUnloadedChunks.add(new ChunkPos(packet.m_132149_(), packet.m_132152_()));
            return true;
        }
        return false;
    }

    private LevelChunk getChunkByPos(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ClientLevel level = this.mc.f_91073_;
        if (level == null) {
            return null;
        }
        return level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
    }

    private static class ChunkEntry {
        public LevelChunk chunk;
        public boolean exists;

        public ChunkEntry(LevelChunk chunk) {
            this.chunk = chunk;
            this.exists = false;
        }
    }
}

