/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.mojang.datafixers.util.Pair;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.BlockUpdateEvent;
import com.zergatul.cheatutils.configs.BlockTracerConfig;
import com.zergatul.cheatutils.controllers.ChunkController;
import com.zergatul.cheatutils.interfaces.LevelChunkMixinInterface;
import com.zergatul.cheatutils.utils.Dimension;
import com.zergatul.cheatutils.utils.ThreadLoadCounter;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockFinderController {
    public static final BlockFinderController instance = new BlockFinderController();
    public final Map<Block, Set<BlockPos>> blocks = new ConcurrentHashMap<Block, Set<BlockPos>>();
    private final Logger logger = LogManager.getLogger(BlockFinderController.class);
    private final Object loopWaitEvent = new Object();
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final ThreadLoadCounter counter = new ThreadLoadCounter();
    private Thread eventLoop;

    private BlockFinderController() {
        Events.ScannerChunkLoaded.add(this::scanChunk);
        Events.ScannerChunkUnloaded.add(this::unloadChunk);
        Events.ScannerBlockUpdated.add(this::handleBlockUpdate);
        this.restartBackgroundThread(null);
    }

    public void restart() {
        this.restartBackgroundThread(() -> {
            this.clear();
            for (Pair<Dimension, LevelChunk> pair : ChunkController.instance.getLoadedChunks()) {
                this.scanChunk((LevelChunk)pair.getSecond());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartBackgroundThread(Runnable beforeThreadStart) {
        if (this.eventLoop != null) {
            this.queue.clear();
            Object object = this.loopWaitEvent;
            synchronized (object) {
                this.loopWaitEvent.notify();
            }
            this.eventLoop.interrupt();
        }
        this.eventLoop = null;
        this.eventLoop = new Thread(() -> {
            boolean first = true;
            try {
                block10: while (true) {
                    this.counter.startWait();
                    if (first) {
                        first = false;
                    } else {
                        Object object = this.loopWaitEvent;
                        synchronized (object) {
                            this.loopWaitEvent.wait();
                        }
                    }
                    this.counter.startLoad();
                    while (true) {
                        if (this.queue.size() <= 0) continue block10;
                        Runnable process = this.queue.remove();
                        process.run();
                        Thread.yield();
                    }
                    break;
                }
            }
            catch (InterruptedException process) {
                this.counter.dispose();
            }
            catch (Throwable e) {
                try {
                    this.logger.error("BlockFinder scan thread crash.", e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.counter.dispose();
                }
            }
        }, "BlockFinderScanThread");
        if (beforeThreadStart != null) {
            beforeThreadStart.run();
        }
        this.eventLoop.start();
    }

    public void clear() {
        this.addToQueue(() -> {
            for (Block block : this.blocks.keySet()) {
                this.blocks.put(block, ConcurrentHashMap.newKeySet());
            }
        });
    }

    public void addConfig(BlockTracerConfig config) {
        this.addToQueue(() -> {
            this.blocks.put(config.block, ConcurrentHashMap.newKeySet());
            this.scan(config.block);
        });
    }

    public void removeConfig(BlockTracerConfig config) {
        this.addToQueue(() -> this.blocks.remove(config.block));
    }

    public void removeAllConfigs() {
        this.addToQueue(this.blocks::clear);
    }

    public String getThreadState() {
        Thread thread = this.eventLoop;
        if (thread != null) {
            return this.eventLoop.getState().toString();
        }
        return null;
    }

    public double getScanningThreadLoadPercent() {
        return 100.0 * this.counter.getLoad(1);
    }

    public int getScanningQueueCount() {
        return this.queue.size();
    }

    private void scanChunk(LevelChunk chunk) {
        this.addToQueue(() -> {
            LevelChunkMixinInterface mixinChunk = (LevelChunkMixinInterface)chunk;
            int minY = mixinChunk.getDimension().getMinY();
            int xc = chunk.m_7697_().f_45578_ << 4;
            int zc = chunk.m_7697_().f_45579_ << 4;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = 0; x < 16; ++x) {
                pos.m_142451_(xc | x);
                for (int z = 0; z < 16; ++z) {
                    pos.m_142443_(zc | z);
                    int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z);
                    for (int y = minY; y <= height; ++y) {
                        pos.m_142448_(y);
                        BlockState state = chunk.m_8055_((BlockPos)pos);
                        this.checkBlock(state, (BlockPos)pos);
                    }
                }
            }
        });
    }

    private void unloadChunk(LevelChunk chunk) {
        this.addToQueue(() -> {
            int cx = chunk.m_7697_().f_45578_;
            int cz = chunk.m_7697_().f_45579_;
            for (Set<BlockPos> set : this.blocks.values()) {
                set.removeIf(pos -> pos.m_123341_() >> 4 == cx && pos.m_123343_() >> 4 == cz);
            }
        });
    }

    private void handleBlockUpdate(BlockUpdateEvent event) {
        this.addToQueue(() -> {
            for (Set<BlockPos> set : this.blocks.values()) {
                set.remove(event.pos());
            }
            this.checkBlock(event.state(), event.pos());
        });
    }

    private void scan(Block block) {
        for (Pair<Dimension, LevelChunk> pair : ChunkController.instance.getLoadedChunks()) {
            this.scanChunkForBlock((Dimension)pair.getFirst(), (ChunkAccess)pair.getSecond(), block);
        }
    }

    private void scanChunkForBlock(Dimension dimension, ChunkAccess chunk, Block block) {
        Set<BlockPos> set = this.blocks.get(block);
        int minY = dimension.getMinY();
        int xc = chunk.m_7697_().f_45578_ << 4;
        int zc = chunk.m_7697_().f_45579_ << 4;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            pos.m_142451_(xc | x);
            for (int z = 0; z < 16; ++z) {
                pos.m_142443_(zc | z);
                int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z);
                for (int y = minY; y <= height; ++y) {
                    pos.m_142448_(y);
                    BlockState state = chunk.m_8055_((BlockPos)pos);
                    if (state.m_60734_() != block) continue;
                    set.add(pos.m_7949_());
                }
            }
        }
    }

    private void checkBlock(BlockState state, BlockPos pos) {
        if (state.m_60795_()) {
            return;
        }
        Set<BlockPos> set = this.blocks.get(state.m_60734_());
        if (set != null) {
            set.add(pos.m_7949_());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(Runnable runnable) {
        this.queue.add(runnable);
        Object object = this.loopWaitEvent;
        synchronized (object) {
            this.loopWaitEvent.notify();
        }
    }
}

