/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.controllers;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import com.zergatul.cheatutils.configs.BlockTracerConfig;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.TracerConfigBase;
import com.zergatul.cheatutils.controllers.BlockFinderController;
import com.zergatul.cheatutils.modules.utilities.RenderUtilities;
import com.zergatul.cheatutils.render.LineRenderer;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;

public class BlockEspController {
    public static final BlockEspController instance = new BlockEspController();

    private BlockEspController() {
        Events.RenderWorldLast.add(this::render);
    }

    private void render(RenderWorldLastEvent event) {
        if (!ConfigStore.instance.getConfig().esp) {
            return;
        }
        Vec3 playerPos = event.getPlayerPos();
        double playerX = playerPos.f_82479_;
        double playerY = playerPos.f_82480_;
        double playerZ = playerPos.f_82481_;
        Vec3 tracerCenter = event.getTracerCenter();
        double tracerX = tracerCenter.f_82479_;
        double tracerY = tracerCenter.f_82480_;
        double tracerZ = tracerCenter.f_82481_;
        LineRenderer renderer = RenderUtilities.instance.getLineRenderer();
        renderer.begin(event, false);
        for (BlockTracerConfig config : ConfigStore.instance.getConfig().blocks.configs) {
            Set<BlockPos> set;
            if (!config.enabled || (set = BlockFinderController.instance.blocks.get(config.block)) == null) continue;
            double tracerMaxDistanceSqr = config.getTracerMaxDistanceSqr();
            double outlineMaxDistanceSqr = config.getOutlineMaxDistanceSqr();
            for (BlockPos pos : set) {
                double dx = (double)pos.m_123341_() - playerX;
                double dy = (double)pos.m_123342_() - playerY;
                double dz = (double)pos.m_123343_() - playerZ;
                double distanceSqr = dx * dx + dy * dy + dz * dz;
                if (config.drawOutline && distanceSqr < outlineMaxDistanceSqr) {
                    this.renderBlockBounding(renderer, pos, config);
                }
                if (!config.drawTracers || !(distanceSqr < tracerMaxDistanceSqr)) continue;
                this.drawTracer(renderer, tracerX, tracerY, tracerZ, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, config);
            }
        }
        renderer.end();
    }

    private void renderBlockBounding(LineRenderer renderer, BlockPos pos, BlockTracerConfig config) {
        int x1 = pos.m_123341_();
        int y1 = pos.m_123342_();
        int z1 = pos.m_123343_();
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int z2 = z1 + 1;
        float r = (float)config.outlineColor.getRed() / 255.0f;
        float g = (float)config.outlineColor.getGreen() / 255.0f;
        float b = (float)config.outlineColor.getBlue() / 255.0f;
        renderer.cuboid(x1, y1, z1, x2, y2, z2, r, g, b, 1.0f);
    }

    private void drawTracer(LineRenderer renderer, double tx, double ty, double tz, double x, double y, double z, TracerConfigBase config) {
        float r = (float)config.tracerColor.getRed() / 255.0f;
        float g = (float)config.tracerColor.getGreen() / 255.0f;
        float b = (float)config.tracerColor.getBlue() / 255.0f;
        renderer.line(tx, ty, tz, x, y, z, r, g, b, 1.0f);
    }
}

