/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.configs.adapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.zergatul.cheatutils.collections.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ImmutableListSerializer
implements JsonSerializer<ImmutableList<?>>,
JsonDeserializer<ImmutableList<?>> {
    public JsonElement serialize(ImmutableList<?> list, Type typeOfSrc, JsonSerializationContext context) {
        if (list == null) {
            return JsonNull.INSTANCE;
        }
        JsonArray array = new JsonArray();
        for (Object value : list) {
            array.add(context.serialize(value));
        }
        return array;
    }

    public ImmutableList<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ImmutableList<Object> list;
        Constructor constructor;
        if (json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonArray()) {
            throw new JsonParseException("Array expected.");
        }
        JsonArray array = (JsonArray)json;
        Type elementType = ((ParameterizedType)typeOfT).getActualTypeArguments()[0];
        try {
            constructor = ImmutableList.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new JsonParseException("Cannot find constructor of ImmutableList.");
        }
        try {
            list = (ImmutableList<Object>)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JsonParseException("Cannot invoke constructor of ImmutableList.");
        }
        for (JsonElement element : array) {
            list = list.add(context.deserialize(element, elementType));
        }
        return list;
    }
}

