/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.configs;

import com.zergatul.cheatutils.configs.ModuleConfig;
import com.zergatul.cheatutils.configs.ValidatableConfig;
import com.zergatul.cheatutils.utils.MathUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class WorldMarkersConfig
extends ModuleConfig
implements ValidatableConfig {
    public List<Entry> entries = new ArrayList<Entry>();
    public int fontSize = 12;
    public boolean antiAliasing;
    public int borderWidth = 1;

    @Override
    public void validate() {
        this.fontSize = MathUtils.clamp(this.fontSize, 8, 100);
        this.borderWidth = MathUtils.clamp(this.borderWidth, 1, 10);
        for (Entry entry : this.entries) {
            entry.validate();
        }
    }

    public static class Entry {
        public double x;
        public double y;
        public double z;
        public double minDistance;
        public String dimension;
        public Color color;
        public String name;
        public boolean enabled;

        public void validate() {
            this.minDistance = MathUtils.clamp(this.minDistance, 0.0, 1000000.0);
        }
    }
}

