/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.configs;

import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.configs.ModuleConfig;
import com.zergatul.cheatutils.configs.ValidatableConfig;
import com.zergatul.cheatutils.utils.MathUtils;
import com.zergatul.cheatutils.wrappers.ClassRemapper;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.ShulkerBullet;

public class KillAuraConfig
extends ModuleConfig
implements ValidatableConfig {
    public static final String ConstDelay = "ConstDelay";
    public static final String Cooldown = "Cooldown";
    public boolean overrideAttackRange = true;
    public double maxRange = 6.0;
    public String delayMode = "ConstDelay";
    public int attackTickInterval = 5;
    public double extraTicks;
    public Double maxHorizontalAngle;
    public Double maxVerticalAngle;
    public ImmutableList<PriorityEntry> priorities = new ImmutableList<PredefinedPriorityEntry>().add(PredefinedPriorityEntry.fromName("Enemies")).add(PredefinedPriorityEntry.fromName("Shulker Bullets")).add(PredefinedPriorityEntry.fromName("Fireballs"));
    public ImmutableList<CustomPriorityEntry> customEntries = new ImmutableList();
    public boolean attackAll;

    @Override
    public void validate() {
        this.maxRange = MathUtils.clamp(this.maxRange, 1.0, 100.0);
        this.attackTickInterval = MathUtils.clamp(this.attackTickInterval, 1, 100);
        this.extraTicks = MathUtils.clamp(this.extraTicks, -10.0, 10.0);
        if (this.maxHorizontalAngle != null) {
            this.maxHorizontalAngle = MathUtils.clamp(this.maxHorizontalAngle, 1.0, 180.0);
        }
        if (this.maxVerticalAngle != null) {
            this.maxVerticalAngle = MathUtils.clamp(this.maxVerticalAngle, 1.0, 180.0);
        }
        this.priorities = this.priorities.removeIf(Objects::isNull);
        this.customEntries = this.customEntries.removeIf(Objects::isNull);
    }

    public static class PredefinedPriorityEntry
    extends PriorityEntry {
        public static final String ENEMIES = "Enemies";
        public static final String ENEMIES_WO_PIGLINS = "Enemies w/o Piglins";
        public static final String PLAYERS = "Players";
        public static final String SHULKER_BULLETS = "Shulker Bullets";
        public static final String FIREBALLS = "Fireballs";
        public static final Map<String, PredefinedPriorityEntry> entries = Map.ofEntries(Map.entry("Enemies", new PredefinedPriorityEntry("Enemies", "Includes Monsters, Slimes, Magma Cubes, Hoglin. Excludes Neutral Mobs (Enderman, ZombifiedPiglin). Endermen can be targeted only in creepy state.", entity -> {
            if (entity instanceof EnderMan) {
                return ((EnderMan)entity).m_32531_();
            }
            return entity instanceof Enemy && !(entity instanceof NeutralMob);
        })), Map.entry("Enemies w/o Piglins", new PredefinedPriorityEntry("Enemies w/o Piglins", "Same as Enemies, but without Piglins.", entity -> {
            if (entity instanceof EnderMan) {
                return ((EnderMan)entity).m_32531_();
            }
            if (entity instanceof AbstractPiglin) {
                return false;
            }
            return entity instanceof Enemy && !(entity instanceof NeutralMob);
        })), Map.entry("Players", new PredefinedPriorityEntry("Players", null, entity -> entity instanceof RemotePlayer)), Map.entry("Shulker Bullets", new PredefinedPriorityEntry("Shulker Bullets", null, entity -> entity instanceof ShulkerBullet)), Map.entry("Fireballs", new PredefinedPriorityEntry("Fireballs", "Ghast projectiles.", entity -> entity instanceof Fireball)));

        private PredefinedPriorityEntry(String name, String description, Predicate<Entity> predicate) {
            super(name, description, predicate);
        }

        public static PredefinedPriorityEntry fromName(String name) {
            return entries.get(name);
        }
    }

    public static class CustomPriorityEntry
    extends PriorityEntry {
        public final String className;

        private CustomPriorityEntry(String name, String description, Predicate<Entity> predicate, String className) {
            super(name, description, predicate);
            this.className = className;
        }

        public static CustomPriorityEntry create(String name, String description, String className) {
            Class<?> clazz;
            try {
                clazz = Class.forName(ClassRemapper.toObf(className));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            return new CustomPriorityEntry(name, description, entity -> clazz.isInstance(entity), className);
        }
    }

    public static class PriorityEntry {
        public final String name;
        public final String description;
        public final Predicate<Entity> predicate;
        public boolean enabled;

        public PriorityEntry(String name, String description, Predicate<Entity> predicate) {
            this.name = name;
            this.description = description;
            this.predicate = predicate;
            this.enabled = true;
        }
    }
}

