/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.configs;

import com.zergatul.cheatutils.configs.TracerConfigBase;
import java.awt.Color;
import net.minecraft.world.entity.Entity;

public class EntityTracerConfig
extends TracerConfigBase {
    public Class clazz;
    public boolean glow;
    public Color glowColor;
    public Double glowMaxDistance;
    public boolean drawTitles;
    public boolean showDefaultNames;
    public boolean showHp;
    public boolean showEquippedItems;
    public boolean showOwner;

    public boolean isValidEntity(Entity entity) {
        return this.clazz.isInstance(entity);
    }

    public double getGlowMaxDistanceSqr() {
        if (this.glowMaxDistance != null) {
            return this.glowMaxDistance * this.glowMaxDistance;
        }
        return this.maxDistance * this.maxDistance;
    }

    public void copyFrom(EntityTracerConfig jsonConfig) {
        this.copyFromJsonTracerConfigBase(jsonConfig);
        this.glow = jsonConfig.glow;
        this.glowColor = jsonConfig.glowColor;
        this.glowMaxDistance = jsonConfig.glowMaxDistance;
        this.drawTitles = jsonConfig.drawTitles;
        this.showDefaultNames = jsonConfig.showDefaultNames;
        this.showHp = jsonConfig.showHp;
        this.showEquippedItems = jsonConfig.showEquippedItems;
        this.showOwner = jsonConfig.showOwner;
    }

    public static EntityTracerConfig createDefault(Class clazz) {
        EntityTracerConfig config = new EntityTracerConfig();
        config.clazz = clazz;
        config.enabled = false;
        config.drawTracers = true;
        config.tracerColor = Color.WHITE;
        config.drawOutline = true;
        config.outlineColor = Color.WHITE;
        config.maxDistance = 1000.0;
        config.glow = true;
        config.glowColor = Color.WHITE;
        return config;
    }
}

