/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.configs;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.mojang.blaze3d.platform.InputConstants;
import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.configs.Config;
import com.zergatul.cheatutils.configs.ScriptsConfig;
import com.zergatul.cheatutils.configs.adapters.BlockStateTypeAdapter;
import com.zergatul.cheatutils.configs.adapters.BlockTypeAdapterFactory;
import com.zergatul.cheatutils.configs.adapters.ClassTypeAdapter;
import com.zergatul.cheatutils.configs.adapters.ColorTypeAdapter;
import com.zergatul.cheatutils.configs.adapters.GsonSkipExcludeStrategy;
import com.zergatul.cheatutils.configs.adapters.ImmutableListSerializer;
import com.zergatul.cheatutils.configs.adapters.ItemTypeAdapterFactory;
import com.zergatul.cheatutils.configs.adapters.KillAuraConfig$PriorityEntryTypeAdapterFactory;
import com.zergatul.cheatutils.controllers.EntityTitleController;
import com.zergatul.cheatutils.controllers.GameTickScriptingController;
import com.zergatul.cheatutils.controllers.KeyBindingsController;
import com.zergatul.cheatutils.controllers.ScriptController;
import com.zergatul.cheatutils.controllers.ScriptedBlockPlacerController;
import com.zergatul.cheatutils.controllers.WorldMarkersController;
import com.zergatul.cheatutils.modules.automation.AutoDisconnect;
import com.zergatul.cheatutils.modules.automation.VillagerRoller;
import com.zergatul.cheatutils.modules.esp.LightLevel;
import com.zergatul.cheatutils.modules.scripting.StatusOverlay;
import com.zergatul.cheatutils.scripting.compiler.ScriptCompileException;
import com.zergatul.cheatutils.scripting.generated.ParseException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigStore {
    public static final ConfigStore instance = new ConfigStore();
    private static final String FILE = "zergatulcheatutils.json";
    private static long WRITE_FILE_DELAY = 15000000000L;
    public final Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new GsonSkipExcludeStrategy()}).registerTypeAdapterFactory((TypeAdapterFactory)new BlockTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new ItemTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new KillAuraConfig$PriorityEntryTypeAdapterFactory()).registerTypeAdapter(BlockState.class, (Object)new BlockStateTypeAdapter()).registerTypeAdapter(Class.class, (Object)new ClassTypeAdapter()).registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).registerTypeAdapter(ImmutableList.class, (Object)new ImmutableListSerializer()).setPrettyPrinting().create();
    private Config config;
    private final Logger logger = LogManager.getLogger(ConfigStore.class);
    private final Thread thread;
    private final Object writeEvent = new Object();
    private volatile long lastWriteRequest = 0L;

    private ConfigStore() {
        this.config = new Config();
        this.thread = new Thread(this::delayedWriteThreadFunc);
        this.thread.start();
    }

    public Config getConfig() {
        return this.config;
    }

    public void read() {
        File file = this.getFile();
        if (file.exists()) {
            Config readCfg = null;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                readCfg = (Config)this.gson.fromJson((Reader)reader, Config.class);
                reader.close();
            }
            catch (Exception e) {
                this.logger.warn("Cannot read config");
                e.printStackTrace();
            }
            if (readCfg != null) {
                this.config = readCfg;
            }
        }
        this.onConfigLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWrite() {
        this.lastWriteRequest = System.nanoTime();
        Object object = this.writeEvent;
        synchronized (object) {
            this.writeEvent.notify();
        }
    }

    public void onClose() {
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedWriteThreadFunc() {
        boolean writeQeued = false;
        try {
            while (true) {
                writeQeued = false;
                Object object = this.writeEvent;
                synchronized (object) {
                    this.writeEvent.wait();
                }
                writeQeued = true;
                long lastValue = this.lastWriteRequest;
                Thread.sleep(WRITE_FILE_DELAY / 1000000L);
                while (this.lastWriteRequest != lastValue) {
                    lastValue = this.lastWriteRequest;
                    long waitNs = this.lastWriteRequest + WRITE_FILE_DELAY - System.nanoTime();
                    Thread.sleep(waitNs / 1000000L);
                }
                this.write();
            }
        }
        catch (InterruptedException e) {
            if (writeQeued) {
                this.write();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        this.logger.debug("Saving config to file");
        File file = this.getFile();
        try {
            ConfigStore configStore = this;
            synchronized (configStore) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                this.gson.toJson((Object)this.config, (Appendable)writer);
                writer.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("Cannot write config");
            e.printStackTrace();
        }
    }

    private File getFile() {
        File configDir = new File(Minecraft.m_91087_().f_91069_, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        return new File(configDir.getPath(), FILE);
    }

    private void onConfigLoaded() {
        Runnable script;
        LightLevel.instance.onChanged();
        this.config.blocks.apply();
        this.config.entities.configs = this.config.entities.configs.removeIf(c -> c.clazz == null);
        this.config.killAuraConfig.validate();
        this.config.movementHackConfig.validate();
        this.config.fastBreakConfig.validate();
        this.config.elytraHackConfig.validate();
        this.config.freeCamConfig.validate();
        this.config.flyHackConfig.validate();
        this.config.boatHackConfig.validate();
        this.config.explorationMiniMapConfig.validate();
        this.config.reachConfig.validate();
        this.config.lightLevelConfig.validate();
        this.config.schematicaConfig.validate();
        this.config.autoBucketConfig.validate();
        this.config.performanceConfig.validate();
        this.config.entityTitleConfig.validate();
        this.config.keyBindingsConfig.validate();
        this.config.worldMarkersConfig.validate();
        this.config.autoAttackConfig.validate();
        this.config.projectilePathConfig.validate();
        this.config.chatUtilitiesConfig.validate();
        this.config.areaMineConfig.validate();
        this.config.hitboxSizeConfig.validate();
        EntityTitleController.instance.onFontChange(this.config.entityTitleConfig);
        EntityTitleController.instance.onEnchantmentFontChange(this.config.entityTitleConfig);
        WorldMarkersController.instance.onFontChange(this.config.worldMarkersConfig);
        if (this.config.scriptsConfig.scripts.size() == 0) {
            String toggleEspName = "Toggle ESP";
            try {
                ScriptController.instance.add("Toggle ESP", "main.toggleEsp();", false);
                KeyBindingsController.instance.keys[0].m_90848_(InputConstants.m_84851_((String)"key.keyboard.backslash"));
                KeyBindingsController.instance.assign(0, "Toggle ESP");
            }
            catch (ScriptCompileException | ParseException e) {
                e.printStackTrace();
            }
            String toggleFreeCamName = "Toggle FreeCam";
            try {
                ScriptController.instance.add("Toggle FreeCam", "freeCam.toggle();", false);
                KeyBindingsController.instance.keys[1].m_90848_(InputConstants.m_84851_((String)"key.keyboard.f6"));
                KeyBindingsController.instance.assign(1, "Toggle FreeCam");
            }
            catch (ScriptCompileException | ParseException e) {
                e.printStackTrace();
            }
        } else {
            ArrayList<ScriptsConfig.ScriptEntry> copy = new ArrayList<ScriptsConfig.ScriptEntry>(this.config.scriptsConfig.scripts);
            this.config.scriptsConfig.scripts.clear();
            copy.forEach(s -> {
                try {
                    ScriptController.instance.add(s.name, s.code, true);
                }
                catch (ScriptCompileException | ParseException e) {
                    e.printStackTrace();
                }
            });
            String[] bindings = this.config.keyBindingsConfig.bindings;
            for (int i = 0; i < 20; ++i) {
                if (bindings[i] == null) continue;
                KeyBindingsController.instance.assign(i, bindings[i]);
            }
        }
        if (this.config.statusOverlayConfig.code != null) {
            try {
                script = ScriptController.instance.compileOverlay(this.config.statusOverlayConfig.code);
                StatusOverlay.instance.setScript(script);
            }
            catch (ScriptCompileException | ParseException e) {
                e.printStackTrace();
            }
        }
        if (this.config.gameTickScriptingConfig.code != null) {
            try {
                script = ScriptController.instance.compileKeys(this.config.gameTickScriptingConfig.code);
                GameTickScriptingController.instance.setScript(script);
            }
            catch (ScriptCompileException | ParseException e) {
                e.printStackTrace();
            }
        }
        if (this.config.scriptedBlockPlacerConfig.code != null) {
            try {
                script = ScriptController.instance.compileBlockPlacer(this.config.scriptedBlockPlacerConfig.code);
                ScriptedBlockPlacerController.instance.setScript(script);
            }
            catch (ScriptCompileException | ParseException e) {
                e.printStackTrace();
            }
        }
        if (this.config.autoDisconnectConfig.code != null) {
            try {
                script = ScriptController.instance.compileAutoDisconnect(this.config.autoDisconnectConfig.code);
                AutoDisconnect.instance.setScript(script);
            }
            catch (ScriptCompileException | ParseException e) {
                e.printStackTrace();
            }
        }
        if (this.config.villagerRollerConfig.code != null) {
            try {
                script = ScriptController.instance.compileVillagerRoller(this.config.villagerRollerConfig.code);
                VillagerRoller.instance.setScript(script);
            }
            catch (ScriptCompileException | ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

