/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.configs;

import com.zergatul.cheatutils.configs.ValidatableConfig;
import com.zergatul.cheatutils.configs.adapters.GsonSkip;
import com.zergatul.cheatutils.utils.MathUtils;
import java.time.format.DateTimeFormatter;

public class ChatUtilitiesConfig
implements ValidatableConfig {
    public boolean dontCloseChatOnEnter;
    public boolean overrideMessageLimit;
    public int messageLimit = 100;
    public boolean showTime;
    public String timeFormat = "HH:mm:ss";
    @GsonSkip
    private DateTimeFormatter formatter;

    public DateTimeFormatter getFormatter() {
        if (this.formatter == null) {
            try {
                this.formatter = DateTimeFormatter.ofPattern(this.timeFormat);
            }
            catch (IllegalArgumentException e) {
                this.formatter = null;
            }
        }
        return this.formatter;
    }

    @Override
    public void validate() {
        this.messageLimit = MathUtils.clamp(this.messageLimit, 20, 1000000);
        if (this.getFormatter() == null) {
            this.showTime = false;
        }
    }
}

