/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.configs;

import com.zergatul.cheatutils.configs.ModuleConfig;
import com.zergatul.cheatutils.configs.ScriptedBlockPlacerConfig;
import com.zergatul.cheatutils.configs.ValidatableConfig;
import com.zergatul.cheatutils.utils.MathUtils;
import java.util.ArrayList;

public abstract class BlockPlacerConfig
extends ModuleConfig
implements ValidatableConfig {
    public double maxRange = 5.0;
    public int[] autoSelectSlots = new int[]{9};
    public boolean attachToAir;
    public boolean useShift;

    protected BlockPlacerConfig() {
    }

    public void copyTo(ScriptedBlockPlacerConfig other) {
        super.copyTo(other);
        other.maxRange = this.maxRange;
        other.autoSelectSlots = this.autoSelectSlots;
        other.attachToAir = this.attachToAir;
        other.useShift = this.useShift;
    }

    @Override
    public void validate() {
        this.maxRange = MathUtils.clamp(this.maxRange, 1.0, 10.0);
        this.validateAutoSelectSlots();
    }

    private void validateAutoSelectSlots() {
        if (this.autoSelectSlots == null) {
            this.autoSelectSlots = new int[0];
        } else {
            int i;
            boolean[] slots = new boolean[9];
            for (int i2 = 0; i2 < this.autoSelectSlots.length; ++i2) {
                int slot = this.autoSelectSlots[i2] - 1;
                if (0 > slot || slot >= 9) continue;
                slots[slot] = true;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = 0; i < 9; ++i) {
                if (!slots[i]) continue;
                list.add(i + 1);
            }
            this.autoSelectSlots = new int[list.size()];
            for (i = 0; i < list.size(); ++i) {
                this.autoSelectSlots[i] = (Integer)list.get(i);
            }
        }
    }
}

