/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.collections;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LinesIterable<T>
implements Iterable<Pair<T, T>> {
    private final List<T> list;

    public LinesIterable(List<T> list) {
        this.list = list;
    }

    @Override
    @NotNull
    public Iterator<Pair<T, T>> iterator() {
        return new LinesIterator<T>(this.list);
    }

    private static class LinesIterator<T>
    implements Iterator<Pair<T, T>> {
        private final List<T> list;
        private int index;

        private LinesIterator(List<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size() - 1;
        }

        @Override
        public Pair<T, T> next() {
            T element1 = this.list.get(this.index++);
            T element2 = this.list.get(this.index);
            return new Pair(element1, element2);
        }
    }
}

