/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ImmutableList<E>
implements Iterable<E> {
    private final Object[] array;

    public ImmutableList() {
        this.array = new Object[0];
    }

    public ImmutableList(Collection<E> collection) {
        this(collection.toArray());
    }

    private ImmutableList(Object[] array) {
        this.array = array;
    }

    public ImmutableList<E> add(E element) {
        int size = this.array.length;
        Object[] newArray = new Object[size + 1];
        System.arraycopy(this.array, 0, newArray, 0, size);
        newArray[size] = element;
        return new ImmutableList<E>(newArray);
    }

    public boolean contains(E item) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!Objects.equals(this.array[i], item)) continue;
            return true;
        }
        return false;
    }

    public E get(int index) {
        return (E)this.array[index];
    }

    public int indexOf(Predicate<E> predicate) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!predicate.test(this.array[i])) continue;
            return i;
        }
        return -1;
    }

    public ImmutableList<E> remove(E element) {
        int i;
        int size;
        block8: {
            size = this.array.length;
            if (element == null) {
                for (i = 0; i < size; ++i) {
                    if (this.array[i] != null) {
                        continue;
                    }
                    break block8;
                }
            } else {
                while (i < size) {
                    if (!element.equals(this.array[i])) {
                        ++i;
                        continue;
                    }
                    break block8;
                }
            }
            return this;
        }
        Object[] newArray = new Object[size - 1];
        if (i > 0) {
            System.arraycopy(this.array, 0, newArray, 0, i);
        }
        if (i < size - 1) {
            System.arraycopy(this.array, i + 1, newArray, i, size - i - 1);
        }
        return new ImmutableList<E>(newArray);
    }

    public ImmutableList<E> removeIf(Predicate<E> predicate) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : this) {
            if (predicate.test(e)) continue;
            list.add(e);
        }
        return new ImmutableList<E>(list.toArray());
    }

    public ImmutableList<E> set(int index, E element) {
        int size = this.array.length;
        Object[] newArray = new Object[size];
        System.arraycopy(this.array, 0, newArray, 0, size);
        newArray[index] = element;
        return new ImmutableList<E>(newArray);
    }

    public ImmutableList<E> swap(int index1, int index2) {
        int size = this.array.length;
        Object[] newArray = new Object[size];
        System.arraycopy(this.array, 0, newArray, 0, size);
        newArray[index1] = this.array[index2];
        newArray[index2] = this.array[index1];
        return new ImmutableList<E>(newArray);
    }

    public int size() {
        return this.array.length;
    }

    public Stream<E> stream() {
        return Arrays.stream(this.array).map(e -> e);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ImmutableList.this.array.length;
            }

            @Override
            public E next() {
                return ImmutableList.this.array[this.index++];
            }
        };
    }
}

