/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.chunkoverlays;

import com.mojang.blaze3d.platform.NativeImage;
import com.zergatul.cheatutils.chunkoverlays.AbstractChunkOverlay;
import com.zergatul.cheatutils.chunkoverlays.NewChunksOverlay;
import com.zergatul.cheatutils.controllers.WorldDownloadController;
import com.zergatul.cheatutils.utils.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class WorldDownloadChunkOverlay
extends AbstractChunkOverlay {
    private final NativeImage texture = this.loadImage("textures/worlddownload/dl.png");

    public WorldDownloadChunkOverlay(int segmentSize, long updateDelay) {
        super(segmentSize, updateDelay);
    }

    @Override
    public int getTranslateZ() {
        return 102;
    }

    @Override
    public boolean isEnabled() {
        return WorldDownloadController.instance.isActive();
    }

    public void notifyChunkSaved(Dimension dimension, int x, int z) {
        this.addToRenderQueue(new AbstractChunkOverlay.RenderThreadQueueItem(() -> {
            int dy;
            int dx;
            ChunkPos chunkPos = new ChunkPos(x, z);
            AbstractChunkOverlay.SegmentPos segmentPos = new AbstractChunkOverlay.SegmentPos(chunkPos, this.segmentSize);
            Map<AbstractChunkOverlay.SegmentPos, AbstractChunkOverlay.Segment> segments = this.getSegmentsMap(dimension);
            if (!segments.containsKey(segmentPos)) {
                segments.put(segmentPos, new AbstractChunkOverlay.Segment(segmentPos, this.segmentSize));
            }
            AbstractChunkOverlay.Segment segment = segments.get(segmentPos);
            int xf = Math.floorMod(chunkPos.f_45578_, this.segmentSize) * 16;
            int yf = Math.floorMod(chunkPos.f_45579_, this.segmentSize) * 16;
            for (dx = 0; dx < 16; ++dx) {
                for (dy = 0; dy < 16; ++dy) {
                    segment.image.m_84988_(xf + dx, yf + dy, 0);
                }
            }
            for (dx = 0; dx < 16; ++dx) {
                for (dy = 0; dy < 16; ++dy) {
                    segment.image.m_84988_(xf + dx, yf + dy, this.texture.m_84985_(dx, dy));
                }
            }
            segment.onChange();
        }));
    }

    @Override
    protected String getThreadName() {
        return "WorldDownloadThread";
    }

    @Override
    protected boolean drawChunk(Dimension dimension, Map<AbstractChunkOverlay.SegmentPos, AbstractChunkOverlay.Segment> segments, LevelChunk chunk) {
        return true;
    }

    @Override
    protected void processBlockChange(Dimension dimension, ChunkPos chunkPos, AbstractChunkOverlay.Segment segment, BlockPos pos, BlockState state) {
    }

    private NativeImage loadImage(String filename) {
        ClassLoader classLoader = NewChunksOverlay.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(filename);
        try {
            return NativeImage.m_85058_((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

