/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.chunkoverlays;

import com.mojang.blaze3d.platform.NativeImage;
import com.zergatul.cheatutils.chunkoverlays.AbstractChunkOverlay;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.utils.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public class NewChunksOverlay
extends AbstractChunkOverlay {
    private final Map<Dimension, Map<ChunkPos, ChunkEntry>> dimensions = new ConcurrentHashMap<Dimension, Map<ChunkPos, ChunkEntry>>();
    private final NativeImage oldChunkImage = this.loadImage("textures/newchunks/old.png");
    private final NativeImage newChunkImage = this.loadImage("textures/newchunks/new.png");
    private final NativeImage semiNewChunkImage = this.loadImage("textures/newchunks/seminew.png");

    public NewChunksOverlay(int segmentSize, long updateDelay) {
        super(segmentSize, updateDelay);
    }

    @Override
    public int getTranslateZ() {
        return 101;
    }

    @Override
    public boolean isEnabled() {
        return ConfigStore.instance.getConfig().newChunksConfig.enabled;
    }

    @Override
    protected boolean drawChunk(Dimension dimension, Map<AbstractChunkOverlay.SegmentPos, AbstractChunkOverlay.Segment> segments, LevelChunk chunk) {
        if (chunk.m_6415_() != ChunkStatus.f_62326_) {
            return false;
        }
        ChunkPos chunkPos = chunk.m_7697_();
        Map chunks = this.dimensions.computeIfAbsent(dimension, k -> new ConcurrentHashMap());
        ChunkEntry entry = chunks.computeIfAbsent(chunkPos, p -> new ChunkEntry());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            pos.m_142451_(x);
            for (int z = 0; z < 16; ++z) {
                pos.m_142443_(z);
                int height = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z);
                for (int y = dimension.getMinY(); y <= height; ++y) {
                    pos.m_142448_(y);
                    BlockState blockState = chunk.m_8055_((BlockPos)pos);
                    if (!this.isFlowingLiquid(blockState)) continue;
                    entry.addExistingFlow(x, y - dimension.getMinY(), z);
                }
            }
        }
        AbstractChunkOverlay.SegmentPos segmentPos = new AbstractChunkOverlay.SegmentPos(chunkPos, this.segmentSize);
        this.addToRenderQueue(new AbstractChunkOverlay.RenderThreadQueueItem(() -> {
            if (!segments.containsKey(segmentPos)) {
                segments.put(segmentPos, new AbstractChunkOverlay.Segment(segmentPos, this.segmentSize));
            }
        }, () -> {
            AbstractChunkOverlay.Segment segment = (AbstractChunkOverlay.Segment)segments.get(segmentPos);
            int xf = Math.floorMod(chunkPos.f_45578_, this.segmentSize) * 16;
            int yf = Math.floorMod(chunkPos.f_45579_, this.segmentSize) * 16;
            this.redrawChunk(entry, segment, xf, yf);
            this.addToRenderQueue(new AbstractChunkOverlay.RenderThreadQueueItem(segment::onChange));
        }));
        return true;
    }

    @Override
    protected void processBlockChange(Dimension dimension, ChunkPos chunkPos, AbstractChunkOverlay.Segment segment, BlockPos pos, BlockState state) {
        if (!this.isFlowingLiquid(state)) {
            return;
        }
        Map chunks = this.dimensions.computeIfAbsent(dimension, d -> new ConcurrentHashMap());
        ChunkEntry entry = chunks.computeIfAbsent(chunkPos, p -> new ChunkEntry());
        entry.addNewFlow(pos.m_123341_() & 0xF, pos.m_123342_() - dimension.getMinY(), pos.m_123343_() & 0xF);
        if (segment == null) {
            return;
        }
        int xf = Math.floorMod(chunkPos.f_45578_, this.segmentSize) * 16;
        int yf = Math.floorMod(chunkPos.f_45579_, this.segmentSize) * 16;
        this.redrawChunk(entry, segment, xf, yf);
        if (!segment.updated) {
            segment.updated = true;
            segment.updateTime = System.nanoTime();
            this.addUpdatedSegment(segment);
        }
    }

    @Override
    protected String getThreadName() {
        return "NewChunksScanThread";
    }

    private void redrawChunk(ChunkEntry chunk, AbstractChunkOverlay.Segment segment, int xf, int yf) {
        for (int dx = 0; dx < 16; ++dx) {
            for (int dy = 0; dy < 16; ++dy) {
                segment.image.m_84988_(xf + dx, yf + dy, 0);
            }
        }
        int existingFlows = chunk.getExistingFlows();
        int newFlows = chunk.getNewFlows();
        if (existingFlows == 0 && newFlows == 0) {
            return;
        }
        NativeImage image = existingFlows == 0 ? this.newChunkImage : (newFlows == 0 ? this.oldChunkImage : this.semiNewChunkImage);
        for (int dx = 0; dx < 16; ++dx) {
            for (int dy = 0; dy < 16; ++dy) {
                segment.image.m_84988_(xf + dx, yf + dy, image.m_84985_(dx, dy));
            }
        }
    }

    private boolean isFlowingLiquid(BlockState blockState) {
        FluidState fluidState = blockState.m_60819_();
        return !fluidState.m_76178_() && !fluidState.m_76170_();
    }

    private NativeImage loadImage(String filename) {
        ClassLoader classLoader = NewChunksOverlay.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(filename);
        try {
            return NativeImage.m_85058_((InputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class ChunkEntry {
        private Set<Integer> existingFlows = new HashSet<Integer>();
        private Set<Integer> newFlows = new HashSet<Integer>();

        private ChunkEntry() {
        }

        public void addExistingFlow(int x, int y, int z) {
            int value = this.combine(x, y, z);
            if (!this.newFlows.contains(value)) {
                this.existingFlows.add(value);
            }
        }

        public void addNewFlow(int x, int y, int z) {
            int value = this.combine(x, y, z);
            if (!this.existingFlows.contains(value)) {
                this.newFlows.add(value);
            }
        }

        public int getExistingFlows() {
            return this.existingFlows.size();
        }

        public int getNewFlows() {
            return this.newFlows.size();
        }

        private int combine(int x, int y, int z) {
            return x | z << 4 | y << 8;
        }
    }
}

